/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPathBinder {
    public static CompoundEnv<ClassSymbol, BytecodeBoundClass> bind(Iterable<Path> classpath, Iterable<Path> bootclasspath, TopLevelIndex.Builder tli) throws IOException {
        Env<ClassSymbol, BytecodeBoundClass> cp = ClassPathBinder.bindClasspath(tli, classpath);
        Env<ClassSymbol, BytecodeBoundClass> bcp = ClassPathBinder.bindClasspath(tli, bootclasspath);
        return CompoundEnv.of(cp).append(bcp);
    }

    private static Env<ClassSymbol, BytecodeBoundClass> bindClasspath(TopLevelIndex.Builder tli, Iterable<Path> paths) throws IOException {
        final HashMap<ClassSymbol, BytecodeBoundClass> map = new HashMap<ClassSymbol, BytecodeBoundClass>();
        Env<ClassSymbol, BytecodeBoundClass> benv = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)map.get(sym);
            }
        };
        for (Path path : paths) {
            try {
                ClassPathBinder.bindJar(tli, path, map, benv);
            }
            catch (IOException e) {
                throw new IOException("error reading " + path, e);
            }
        }
        return new SimpleEnv<ClassSymbol, BytecodeBoundClass>(ImmutableMap.copyOf(map));
    }

    private static void bindJar(TopLevelIndex.Builder tli, Path path, Map<ClassSymbol, BytecodeBoundClass> env, Env<ClassSymbol, BytecodeBoundClass> benv) throws IOException {
        JarFile jf = new JarFile(path.toFile());
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            ClassSymbol sym;
            JarEntry je = entries.nextElement();
            String name = je.getName();
            if (!name.endsWith(".class") || env.containsKey(sym = new ClassSymbol(name.substring(0, name.length() - ".class".length())))) continue;
            env.put(sym, new BytecodeBoundClass(sym, (Supplier<byte[]>)((Supplier)() -> ClassPathBinder.toByteArrayOrDie(jf, je)), benv, path.toString()));
            tli.insert(sym);
        }
    }

    private static byte[] toByteArrayOrDie(JarFile jf, JarEntry je) {
        try {
            return ByteStreams.toByteArray((InputStream)jf.getInputStream(je));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

