const PROTOCOLS = {
    webdriver: require('../packages/wdio-protocols/protocols/webdriver.json'),
    appium: require('../packages/wdio-protocols/protocols/appium.json'),
    mjsonwp: require('../packages/wdio-protocols/protocols/mjsonwp.json'),
    chromium: require('../packages/wdio-protocols/protocols/chromium.json'),
    gecko: require('../packages/wdio-protocols/protocols/gecko.json'),
    saucelabs: require('../packages/wdio-protocols/protocols/saucelabs.json'),
    selenium: require('../packages/wdio-protocols/protocols/selenium.json'),
    jsonwp: require('../packages/wdio-protocols/protocols/jsonwp.json')
}
const PROTOCOL_NAMES = {
    appium: 'Appium',
    jsonwp: 'JSON Wire Protocol',
    mjsonwp: 'Mobile JSON Wire Protocol',
    webdriver: 'WebDriver Protocol',
    chromium: 'Chromium',
    gecko: 'Firefox',
    saucelabs: 'Sauce Labs',
    selenium: 'Selenium Standalone'
}
const MOBILE_PROTOCOLS = ['appium', 'mjsonwp']
const VENDOR_PROTOCOLS = ['chromium']
const IGNORED_SUBPACKAGES_FOR_DOCS = [
    'eslint-plugin-wdio',
    'wdio-smoke-test-service',
    'wdio-smoke-test-reporter'
]

const EDIT_WARNING = `// -------------------- ATTENTION --------------------
// Do not edit this file as it gets auto-generated!
// For edits modify /scripts/templates/*.tpl.d.ts
// Check CONTRIBUTING.md for more details.
// --------------------------------------------------
//
`

const SAUCE_API_DESCRIPTION = `
All commands are only supported on Chrome using Sauce Labs
[Extended Debugging](https://wiki.saucelabs.com/pages/viewpage.action?pageId=70072943)
capabilities. You can enable these by setting the following Sauce options:\n\n
\`\`\`js
{
    browserName: 'Chrome',
    browserVersion: 'latest',
    platformName: 'Windows 10',
    'sauce:options': {
        extendedDebugging: true
    }
}
\`\`\`
`

const JSONWP_API_DESCRIPTION = `
:::caution depcrecated

The JSONWireProtocol is decrecated and replaced by the [WebDriver](/docs/api/webdriver)
protocol.

:::
`

const PROTOCOL_API_DESCRIPTION = {
    'saucelabs': SAUCE_API_DESCRIPTION,
    'jsonwp': JSONWP_API_DESCRIPTION
}

module.exports = {
    PROTOCOLS,
    EDIT_WARNING,
    PROTOCOL_NAMES,
    MOBILE_PROTOCOLS,
    VENDOR_PROTOCOLS,
    IGNORED_SUBPACKAGES_FOR_DOCS,
    PROTOCOL_API_DESCRIPTION
}
