---
title: WireMock as a Service
author: Erwin Heitzman
authorURL: http://github.com/erwinheitzman
authorImageURL: https://avatars1.githubusercontent.com/u/15839059?s=80&v=4
---

We are pleased to announce that we now have a new mocking service for WebdriverIO called `wdio-wiremock-service`.

## What can it do?

This service helps you to run WireMock seamlessly when running tests with [WebdriverIO](https://webdriver.io). It uses the well known [Maven](https://mvnrepository.com/repos/central) repository to download the WireMock jar for you which is then automatically installed, started and stopped. Stay up to date by joining the community over at [Gitter](https://gitter.im/erwinheitzman/wdio-wiremock-service) for help and support.

A few things you can do with this service:

- Automatically run [WireMock](http://wiremock.org/) alongside the WebdriverIO testrunner
- Supports usage of mock and fixture files
- Match request URLs, methods, headers cookies and bodies using a wide variety of strategies. First class support for JSON and XML.
- Configure WireMock with all the available [options](https://github.com/erwinheitzman/wdio-wiremock-service/blob/master/README.md#options)

## Installation

```sh
npm install wdio-wiremock-service --save-dev
```

Instructions on how to install `WebdriverIO` can be found [here.](https://webdriver.io/docs/gettingstarted.html)

## Configuration

In order to use the service you need to add it to your service array:

```js title="wdio.conf.js"
export.config = {
  // ...
  services: ['wiremock'],
  // ...
};
```

There are a lot more options that are available for configuration, for a full overview go [here](https://github.com/erwinheitzman/wdio-wiremock-service/blob/master/README.md#options).

## Creating mocks and fixtures

The service creates a directory (`./mock` by default) with two subdirectories (`mappings` and `__files`). It will use the `mappings` directory to look for mock files and it will use the `__files` directory to look for fixture files.

Knowing this, creating a fixture is as easy as creating a file in the `__files` directory:

```json title="./mock/__files/hello-world.json"
Hello world
```

And creating your first mock is as simple as creating a file in the `mappings` directory:

Knowing this, creating a fixture is as easy as creating a file in the `__files` directory:

```json title="./mock/mappings/my-test.json"
{
  "request": {
      "method": "GET",
      "url": "/api/mytest"
  },
  "response": {
      "status": 200,
      "bodyFileName": "hello-world.json"
  }
}
```

## Writing tests

Writing your first test is really straight forward:

```js title="./test/specs/mytest.js"
const fetch = require('node-fetch');
const assert = require('assert');

describe('My test', () => {
  it('should assert the mock data', () => {
    browser.call(async () => {
      await fetch('http://localhost:8080/api/mytest')
        .then((res) => res.text())
        .then((body) => {
            // assert that the request body returns the expected value
            assert.equal(body, 'More content');
        });
    });
  });
});
```

# Support

Stay up to date by joining the community over at [Gitter](https://gitter.im/erwinheitzman/wdio-wiremock-service) to join others and for support and questions.

See you there!
