---
title: WebdriverIO Opens an OpenCollective
author: Christian Bromann
authorURL: http://twitter.com/bromann
authorImageURL: https://s.gravatar.com/avatar/d98b16d7c93d15865f34a225dd4b1254?s=80
---

Today the WebdriverIO team announced in their [OpenJS Foundation](https://openjsf.org/) Q&A session that the project opens an [OpenCollective](https://opencollective.com/webdriverio) to allow users and companies to donate to the development of the project and support community members to run WebdriverIO workshops and other types of events. This allows everyone to be paid to work on features and bug fixes as well as help the community to pay for pizza or rental space when hosting WebdriverIO workshops or meetups.

If your company uses WebdriverIO and benefits from it, please ask your manager or your marketing team to support the project by donating to the collective. Support will allow the maintainers to dedicate more time for maintenance and new features for everyone.

As part of this we also like to announce the official WebdriverIO Swag Store: [shop.webdriver.io](http://shop.webdriver.io), which will be used as an income source for the collective. All purchases from that store will directly go into our fund and to you. We start our collection with a T-shirt, a sweatshirt and a couple of accessories but will soon extend to more. So stay tuned!

We want to be transparent in the way we accept expenses to the collective. Everyone should be eligible to participate and send in expenses for development on certain features. We also want to give back to the community by allowing us to expense event expenses. The following expense types may be eligible to be reimbursed from the collective:

#### Event Expenses

If you host an event that has a speaker talking about using WebdriverIO and it's features you can expense up to __$100__. Reimbursement requirements for event expenses include:

- You or the event account must share the project on social media (Twitter, Facebook or LinkedIn) at least 3x
- The event page must have the WebdriverIO logo and a link to the project page in your meetup description
- You must use the funds for qualified event expenses such as food, beverage, room or equipment rental.
- You must submit receipts with your reimbursement request.

Our goal with this expense policy is to help the community to run events, to promote the project and support anyone learning about WebdriverIO. We've already seen project meetups happening in New York and The Netherlands and hope to see more of this in the future.

#### Development Expenses

If you have done development work on any of the repositories within the GitHub WebdriverIO organisation you may reimburse up to __$1000__ if the following requirements are met:

- You must have submitted qualifying pull requests that have closed at least 10 issues that were labeled with [`Expensable 💸`](https://github.com/webdriverio/webdriverio/labels/Expensable%20%F0%9F%92%B8)
- Every additional issue closed with that label can be expensed with $100
- You must submit links to all issues you’ve closed due to your pull requests
- In order to close the ticket automatically, you must have one commit message with the Fix keyword. For example, Fix #1234 to close ticket #1234.
- Pull Requests must be merged by someone from the [core team](https://github.com/webdriverio/webdriverio/blob/main/AUTHORS.md#tsc-technical-steering-committee). If there are several Pull Requests, the core team member either selects the most recent one or the best one - that’s up to them to decide what is best for the project.
- You must claim an [`Expensable 💸`](https://github.com/webdriverio/webdriverio/labels/Expensable%20%F0%9F%92%B8) issue by commenting to the issue thread to ensure that no one else is working on the same issue.
- Anyone contributing to WebdriverIO is eligible to expense their work if the implemented features or bug fixes are not objectives of a commercial job.

Please note that contributing on behalf of a company does not make you eligible to also get reimbursed by the collective. If a company pays you to work on WebdriverIO we see this already as a contribution to the project by the company.

We understand that $1000 for fixing 10 bugs or implementing 10 features may seem arbitrary because some work items will take longer than others. However by requiring someone to finish 10 work items we hope that this uncertainty of effort and time will balance out. We also understand that this will not reimburse someone by their market value and it certainly won't allow someone to work full time on WebdriverIO. The goal of the collective is to reimburse people that usually would contribute in their free time in a very transparent and open way.

#### Travel Expenses

If you are a member of the [Technical Steering Committee team](https://github.com/webdriverio/webdriverio/blob/main/AUTHORS.md#tsc-technical-steering-committee) you are eligible to expense flights and hotel accommodations for travel to conferences or meetups as part of a speaking engagement on WebdriverIO, not paid by the event itself or a company. You may expense up to $500. Reimbursement requirements for travel expenses include:

- You must send out a post from your main social media account (e.g. Twitter, LinkedIn or personal blog) thanking all contributors of the collective after the event took place.
- You must use the funds for qualified travel expenses such as ground or air transportation to the event and hotel accommodations.
- You must submit receipts with your reimbursement request.

Even though currently there are no in-person events happening due to the COVID-19 pandemic, we hope that we come back to times where we can reconnect with the community on a personal level. For that we would like to support the core team with their travel expenses.

Overall we hope that this expense policy is fair and inclusive enough that anyone can participate. Opening a collective might sound easy in the beginning but doesn't end up being a trivial effort when you consider transparency and fairness. We expect to make amendments to our policies once we gather more experience from the process.

Thank you to everyone who will donate money to the collective and therefore will support the project and everyone contributing to it. It really means a lot ❤️

