---
sitemap: false

pages:
  single-sign-on:
    title: Single Sign On 
    description: Say goodbye to multiple credentials.
    banner:
      image: "/media/landings/banner/hero-image-single-sign-on.png"
      socialmediaimage: "/media/landings/banner/twitter-card-single-sign-on.png"
    meta:
      title: Single Sign On Authentication
      description: Get started with Single Sign On and say goodbye to multiple credentials.
    modules:
      - implementation
      - login
      - integration-existing-users
      - integration-cloud-apps
      - device-agnostic
      - last-mile-integration
      - compliance-with-standards
  how-to-implement-single-sign-on:
    title: How to Implement Single Sign On 
    description: Implement Single Sign On to allow users to login to multiple systems with just one set of credentials.
    banner:
      image: "/media/landings/banner/hero-image-single-sign-on.png"
      socialmediaimage: "/media/landings/banner/twitter-card-single-sign-on.png"
    meta:
      title: Implement Single Sign On Authentication
      description: Implement Single Sign On to allow users to login with just one set of credentials to multiple systems.
    modules:
      - sso-login-just-once-depth
      - sso-how-it-works-depth
      - sso-easy-to-implement-depth
      - sso-integration-cloud-apps-depth
      - sso-single-log-out-depth
      - sso-last-mile-integration-depth
      - compliance-with-standards
  multi-factor-authentication:
    title: Multifactor Authentication 
    description: Increased security for your mission-critical systems.
    banner:
      image: "/media/landings/banner/bg-hero-mfa.png"
      socialmediaimage: "/media/landings/banner/bg-hero-mfa-sm.png"
    meta:
      title: Multifactor Authentication
      description: Increased security for your mission-critical systems.
    modules:
      - what-is-mfa
      - why-is-mfa-necessary
      - mfa-easy-to-implement
      - custom-mfa
      - compliance-with-standards
  get-started-with-mfa:
    title: Multifactor Authentication (MFA) 
    description: Learn everything about Multifactor Authentication (MFA) and how you can start using it right now in your application.
    banner:
      image: "/media/landings/banner/bg-hero-mfa.png"
      socialmediaimage: "/media/landings/banner/bg-hero-mfa-sm.png"
    meta:
      title: Multifactor Authentication (MFA)
      description: Learn everything about Multifactor Authentication (MFA) and how you can start using it right now in your application.
    modules:
      - what-is-mfa-depth
      - why-is-mfa-necessary-depth
      - multi-factor-options
      - mfa-easy-to-implement-depth
      - adaptative-context-aware-mfa
      - custom-mfa-providers
      - compliance-with-standards
  json-web-tokens:
    title: Get Started with JSON Web Tokens
    description: All you wanted to know about JSON Web Tokens but were afraid to ask.
    banner:
      image: "/media/landings/banner/jwt-hero.png"
      socialmediaimage: "/media/landings/banner/twitter-card-jwt.png"
    meta:
      title: Get Started with JSON Web Tokens
      description: All you wanted to know about JSON Web Tokens but were afraid to ask.
    modules:
      - jwt-what-is
      - jwt-when-should-you-use
      - jwt-which-is-the-structure
      - jwt-how-they-work
      - jwt-why-should-you-use
      - jwt-how-we-use-in-Auth0
  social-login:
    title: Social Login - Time to implement it in your apps
    description: Implement Social Login in a heartbeat with Auth0 and increase your registrations.
    banner:
      image: "/media/landings/banner/social-login-hero.png"
      socialmediaimage: "/media/landings/banner/twitter-card-social-login.png"
    meta:
      title: Social Login - Time to implement it in your apps
      description: Implement Social Login in a heartbeat with Auth0 and increase your registrations.
    modules:
      - sl-what-is
      - sl-why
      - sl-how-it-works
      - sl-supported-providers
      - sl-with-auth0-in-a-few-steps
      - sl-add-custom-social-connection
  angular-authentication:
    title: AngularJS Authentication, the Easy Way
    description: Add token authentication to your Angular 1.x or Angular 2 app in minutes with ready-to-go tools.
    banner:
      image: "/media/landings/banner/angular-hero.png"
      socialmediaimage: "/media/landings/banner/twitter-card-angular.png"
    meta:
      title: AngularJS Authentication, the Easy Way
      description: Add token authentication to your Angular 1.x or Angular 2 app in minutes with ready-to-go tools.
    modules:
      - angular-what-is
      - angular-tokens-work-best
      - angular-jwt
      - angular-auth0-how-it-works
      - angular-lock
      - angular-2-support
  refresh-tokens:
    title: Understanding Refresh Tokens
    description: Learn about refresh tokens and how they fit in the authentication process.
    banner:
      image: "/media/landings/banner/refresh-tokens-hero.png"
      socialmediaimage: "/media/landings/banner/twitter-card-refresh-tokens.png"
    meta:
      title: Understanding Refresh Tokens
      description: Learn about refresh tokens and how they fit in the authentication process.
    modules:
      - rtokens-what-is
      - rtokens-how-they-work
      - rtokens-using-them
      - rtokens-security-considerations
      - rtokens-in-auth0

---