# .NET repositories

.NET Core consists of many repositories. To file an issue, make a PR, or engage on specific topics, it's best to engage with developers working in the correct repo. A largely complete set of .NET Core and related repositories follows.

## .NET Core

|Repository                                                        |Description |
|------------------------------------------------------------------|------------|
|[dotnet/core](https://github.com/dotnet/core)                     |.NET Core home repository|
|[dotnet/runtime](https://github.com/dotnet/runtime)               |.NET Core runtime, runtime installers, application model, & Base Class Library (BCL)|
|[dotnet/docs](https://github.com/dotnet/docs)                     |.NET documentation|
|[dotnet/dotnet-api-docs](https://github.com/dotnet/dotnet-api-docs) |.NET API documentation|
|[dotnet/project-system](https://github.com/dotnet/project-system) |Visual Studio project system for C#, F#, & VB|
|[dotnet/sdk](https://github.com/dotnet/sdk)                       |.NET Core SDK (used by Visual Studio & .NET Core CLI)|
|[dotnet/installer](https://github.com/dotnet/installer)           |.NET Core installer (produces zips, tarballs, and installers for the .NET SDK)
|[dotnet/extensions](https://github.com/dotnet/extensions)         |.NET extension APIs (DI, logging, configuration, etc.)|
|[dotnet/dotnet-docker](https://github.com/dotnet/dotnet-docker)   |.NET Core Docker images|
|[dotnet/templating](https://github.com/dotnet/templating)         |Templating engine used by `dotnet new`|
|[dotnet/test-templates](https://github.com/dotnet/test-templates) |.NET Core unit testing project templates|
|[dotnet/winforms](https://github.com/dotnet/winforms)             |Windows Forms|
|[dotnet/wpf](https://github.com/dotnet/wpf)                       |Windows Presentation Foundation (WPF)|
|[dotnet/maui](https://github.com/dotnet/maui)                     |.NET Multi-platform App UI|

## .NET Framework

|Repository                                                        |Description |
|------------------------------------------------------------------|------------|
|[Dev Community](https://developercommunity.visualstudio.com/spaces/61/index.html) |Report isssues to .NET Framework Developer Community|
|[microsoft/dotnet-framework-docker](https://github.com/microsoft/dotnet-framework-docker) |.NET Framework Docker images|

## .NET Standard

|Repository                                            |Description             |
|------------------------------------------------------|------------------------|
|[dotnet/standard](https://github.com/dotnet/standard) |.NET Standard definition|

## ASP.NET

|Repository                                                         |Description                                  |
|-------------------------------------------------------------------|---------------------------------------------|
|[dotnet/aspnetcore](https://github.com/dotnet/aspnetcore)          |ASP.NET Core framework                       |
|[dotnet/AspNetCore.Docs](https://github.com/dotnet/AspNetCore.Docs)|ASP.NET Core documentation                   |
|[dotnet/AspNetDocs](https://github.com/dotnet/AspNetDocs)          |ASP.NET 4.x documentation                    |
|[dotnet/Scaffolding](https://github.com/dotnet/Scaffolding)        |ASP.NET Core code generators                 |
|[dotnet/websdk](https://github.com/dotnet/websdk)                  |MSBuild tasks & targets for ASP.NET Core apps|

## Build platform

|Repository                                               |Description                            |
|---------------------------------------------------------|---------------------------------------|
|[dotnet/msbuild](https://github.com/dotnet/msbuild)      |Build platform for .NET & Visual Studio|

## Entity Framework and data access

|Repository                                                                   |Description                           |
|-----------------------------------------------------------------------------|--------------------------------------|
|[dotnet/efcore](https://github.com/dotnet/efcore)                            |EF Core                               |
|[dotnet/ef6](https://github.com/dotnet/ef6)                                  |EF 6                                  |
|[dotnet/EntityFramework.Docs](https://github.com/dotnet/EntityFramework.Docs)|EF Core & EF 6 documentation          |
|[dotnet/sqlclient](https://github.com/dotnet/sqlclient)                      |SqlClient data provider for SQL Server|

## Languages

|Repository                                                               |Description                                            |
|-------------------------------------------------------------------------|-------------------------------------------------------|
|[dotnet/roslyn](https://github.com/dotnet/roslyn)                        |Roslyn (C# / VB compiler)                              |
|[dotnet/csharplang](https://github.com/dotnet/csharplang)                |C# suggestions, specification, ongoing language design |
|[dotnet/vblang](https://github.com/dotnet/vblang)                        |VB suggestions, specification, ongoing language design |
|[dotnet/fsharp](https://github.com/dotnet/fsharp)                        |The F# compiler, FSharp.Core library, and tools for F# |
|[fsharp/fslang-design](https://github.com/fsharp/fslang-design)          |RFCs and docs related to the F# language design process|
|[fsharp/fslang-suggestions](https://github.com/fsharp/fslang-suggestions)|F# language and FSharp.Core library suggestions        |

## NuGet

|Repository                                                  |Description |
|------------------------------------------------------------|------------|
|[nuget/home](https://github.com/nuget/home)                 |NuGet client|
|[nuget/nugetgallery](https://github.com/nuget/nugetgallery) |NuGet.org   |

## WCF

|Repository                                  |Description         |
|--------------------------------------------|--------------------|
|[dotnet/wcf](https://github.com/dotnet/wcf) |WCF client libraries|
