# System.Runtime.Versioning

``` diff
+namespace System.Runtime.Versioning {
+    public sealed class ComponentGuaranteesAttribute : Attribute {
+        public ComponentGuaranteesAttribute(ComponentGuaranteesOptions guarantees);
+        public ComponentGuaranteesOptions Guarantees { get; }
+    }
+    public enum ComponentGuaranteesOptions {
+        Exchange = 1,
+        None = 0,
+        SideBySide = 4,
+        Stable = 2,
+    }
+    public sealed class FrameworkName : IEquatable<FrameworkName> {
+        public FrameworkName(string frameworkName);
+        public FrameworkName(string identifier, Version version);
+        public FrameworkName(string identifier, Version version, string profile);
+        public string FullName { get; }
+        public string Identifier { get; }
+        public string Profile { get; }
+        public Version Version { get; }
+        public override bool Equals(object obj);
+        public bool Equals(FrameworkName other);
+        public override int GetHashCode();
+        public static bool operator ==(FrameworkName left, FrameworkName right);
+        public static bool operator !=(FrameworkName left, FrameworkName right);
+        public override string ToString();
+    }
+    public sealed class ResourceExposureAttribute : Attribute {
+        public ResourceExposureAttribute(ResourceScope exposureLevel);
+        public ResourceScope ResourceExposureLevel { get; }
+    }
+    public enum ResourceScope {
+        AppDomain = 4,
+        Assembly = 32,
+        Library = 8,
+        Machine = 1,
+        None = 0,
+        Private = 16,
+        Process = 2,
+    }
+    public sealed class TargetFrameworkAttribute : Attribute {
+        public TargetFrameworkAttribute(string frameworkName);
+        public string FrameworkDisplayName { get; set; }
+        public string FrameworkName { get; }
+    }
+    public static class VersioningHelper {
+        public static string MakeVersionSafeName(string name, ResourceScope from, ResourceScope to);
+        public static string MakeVersionSafeName(string name, ResourceScope from, ResourceScope to, Type type);
+    }
+}
```

