# .NET Core May 2019 Update - May 14, 2019

.NET Core 1.0.16 is available for [download](1.0.16-download.md) and usage in your environment.

* [.NET Core Blog][dotnet-blog]
* [Changes in this release](#changes-in-1016)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)

The .NET Core SDK 1.1.13 includes .NET Core 1.0.16 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 1.1.13, running `dotnet --version` will show that you're running version `1.1.13` of the .NET Core tools.

Your feedback is important and appreciated. We've created an issue at [dotnet/core #2727](https://github.com/dotnet/core/issues/2727) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the updated images for .NET Core 1.0.16 and .NET Core SDK 1.1.13 and read ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/) for details and insights into using the .NET Core images.

## Azure AppServices

* Deployment of .NET Core 1.0.16 to Azure App Services has begun. It will be available in limited regions today and expected worldwide by the end of the week.

## .NET Core Lifecycle News

Ubuntu 14.04 reached the [end of standard support April 2019](https://wiki.ubuntu.com/Releases). We will no longer produce and release packages for this OS version.

.NET Core 1.0 and 1.1, which entered "Maintenance" support status when 2.1 was declared LTS, will be end-of-life June 27, 2019. Updates for the 1.0 and 1.1 channels will no longer be offered after that date. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 1.0.16

* [CVE-2019-0820: .NET Core Tampering Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-0820)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core improperly process RegEx strings. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET application.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core applications handle RegEx string processing.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Text.RegularExpressions.dll | 4.3.0 | 4.3.1

* [CVE-2019-0980: ASP.NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-0980)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core and ASP.NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core and ASP.NET Core improperly handle web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core and ASP.NET Core application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core and ASP.NET Core web applications handle web requests.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0, 4.3.1 | 4.3.2

* [CVE-2019-0981: ASP.NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-0981)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core and ASP.NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core and ASP.NET Core improperly handle web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core and ASP.NET Core application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core and ASP.NET Core web applications handle web requests.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0, 4.3.1 | 4.3.2

## Package and Binary updates

Package name | Version
:------------ | :-----------------
Microsoft.NETCore.App|1.0.16
Microsoft.NETCore.DotNetHostPolicy|1.0.16
Microsoft.NETCore.ILAsm|1.0.18
Microsoft.NETCore.ILDAsm|1.0.18
Microsoft.NETCore.Jit|1.0.18
Microsoft.NETCore.Runtime.CoreCLR|1.0.18
Microsoft.Private.PackageBaseline|1.0.0-servicing-27618-03
runtime.debian.8-x64.Microsoft.NETCore.DotNetHostPolicy|1.0.16
runtime.debian.8-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.debian.8-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.debian.8-x64.Microsoft.NETCore.Jit|1.0.18
runtime.debian.8-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.fedora.23-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.fedora.23-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.fedora.23-x64.Microsoft.NETCore.Jit|1.0.18
runtime.fedora.23-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.opensuse.13.2-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.opensuse.13.2-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.opensuse.13.2-x64.Microsoft.NETCore.Jit|1.0.18
runtime.opensuse.13.2-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.osx.10.10-x64.Microsoft.NETCore.DotNetHostPolicy|1.0.16
runtime.osx.10.10-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.osx.10.10-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.osx.10.10-x64.Microsoft.NETCore.Jit|1.0.18
runtime.osx.10.10-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.rhel.7-x64.Microsoft.NETCore.DotNetHostPolicy|1.0.16
runtime.rhel.7-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.rhel.7-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.rhel.7-x64.Microsoft.NETCore.Jit|1.0.18
runtime.rhel.7-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.ubuntu.14.04-x64.Microsoft.NETCore.DotNetHostPolicy|1.0.16
runtime.ubuntu.14.04-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.ubuntu.14.04-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.ubuntu.14.04-x64.Microsoft.NETCore.Jit|1.0.18
runtime.ubuntu.14.04-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.ubuntu.16.04-x64.Microsoft.NETCore.DotNetHostPolicy|1.0.16
runtime.ubuntu.16.04-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.ubuntu.16.04-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.ubuntu.16.04-x64.Microsoft.NETCore.Jit|1.0.18
runtime.ubuntu.16.04-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.unix.System.Net.Primitives|4.0.12
runtime.unix.System.Private.Uri|4.0.5
runtime.win.System.Net.Primitives|4.0.12
runtime.win7.System.Private.Uri|4.0.5
runtime.win7-x64.Microsoft.NETCore.DotNetHostPolicy|1.0.16
runtime.win7-x64.Microsoft.NETCore.ILAsm|1.0.18
runtime.win7-x64.Microsoft.NETCore.ILDAsm|1.0.18
runtime.win7-x64.Microsoft.NETCore.Jit|1.0.18
runtime.win7-x64.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
runtime.win7-x86.Microsoft.NETCore.DotNetHostPolicy|1.0.16
runtime.win7-x86.Microsoft.NETCore.ILAsm|1.0.18
runtime.win7-x86.Microsoft.NETCore.ILDAsm|1.0.18
runtime.win7-x86.Microsoft.NETCore.Jit|1.0.18
runtime.win7-x86.Microsoft.NETCore.Runtime.CoreCLR|1.0.18
System.Net.Primitives|4.0.12
System.Private.Uri|4.0.5
System.Text.RegularExpressions|4.1.1


[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-may-2019/
