# .NET Core February Update - February 12, 2019

.NET Core 1.1.11 is available for [download](1.1.11-download.md) and usage in your environment.

* [.NET Core Blog](https://blogs.msdn.microsoft.com/dotnet/2019)

The .NET Core SDK 1.1.12 includes .NET Core 1.1.11 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 1.1.12, running `dotnet --version` will show that you're running version `1.1.12` of the .NET Core tools.

Your feedback is important and appreciated. We've created an issue at [dotnet/core #2304](https://github.com/dotnet/core/issues/XXXX) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the updated images for .NET Core 1.1.11 and .NET Core SDK 1.1.12 and read ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/) for details and insights into using the .NET Core images.

## Azure AppServices

* Deployment of .NET Core 1.1.11 to Azure App Services has begun. It will be available in limited regions today and expected worldwide by the end of the week.

## .NET Core Lifecycle News

There are no changes this month in OS version support status.

.NET Core 1.0 and 1.1, which entered "Maintenance" support status when 2.1 was declared LTS, will be end-of-life June 27, 2019. Updates for the 1.0 and 1.1 channels will no longer be offered after that date. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Notable Changes in 1.1.11

* ### [CVE-2019-0657: .NET Core Domain Spoofing Vulnerability](https://github.com/dotnet/announcements/issues/97)

    This update addresses a domain spoofing vulnerability in .NET Framework and .NET Core which causes the meaning of a URI to change when International Domain Name encoding is applied. An attacker who successfully exploited the vulnerability could redirect a URI.
    
    **Package and Binary updates**
    
    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0 | 4.3.1

### Package and Binary updates

Package name | Version
:----------- | :----------------
Microsoft.NETCore.ILAsm | 1.1.11
Microsoft.NETCore.ILDAsm | 1.1.11
Microsoft.NETCore.Jit | 1.1.11
Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
Microsoft.NETCore.TestHost | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.Jit | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.TestHost | 1.1.11
runtime.win7-x64.Microsoft.NETCore.ILAsm | 1.1.11
runtime.win7-x64.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.win7-x64.Microsoft.NETCore.Jit | 1.1.11
runtime.win7-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.win7-x64.Microsoft.NETCore.TestHost | 1.1.11
runtime.win7-x86.Microsoft.NETCore.ILAsm | 1.1.11
runtime.win7-x86.Microsoft.NETCore.ILDAsm | 1.1.11
runtime.win7-x86.Microsoft.NETCore.Jit | 1.1.11
runtime.win7-x86.Microsoft.NETCore.Runtime.CoreCLR | 1.1.11
runtime.win7-x86.Microsoft.NETCore.TestHost | 1.1.11
Microsoft.NETCore.Platforms | 1.1.2
Microsoft.NETCore.Targets | 1.1.4
runtime.any.System.Runtime | 4.3.1
runtime.aot.System.Runtime | 4.3.1
runtime.unix.System.Private.Uri | 4.3.1
runtime.unix.System.Runtime.Extensions | 4.3.1
runtime.win.System.Runtime.Extensions | 4.3.1
runtime.win7.System.Private.Uri | 4.3.1
System.Private.Uri | 4.3.1
System.Runtime | 4.3.1
System.Runtime.Extensions | 4.3.1
Microsoft.NETCore.App | 1.1.11
Microsoft.NETCore.DotNetHost | 1.1.11
Microsoft.NETCore.DotNetHostPolicy | 1.1.11
Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.debian.8-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.debian.9-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.fedora.24-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.fedora.27-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.fedora.28-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.opensuse.42.1-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.opensuse.42.3-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.osx.10.10-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.rhel.7-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.ubuntu.14.04-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.ubuntu.16.04-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.ubuntu.18.04-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.win10-arm64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.win7-x64.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.win7-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.win7-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.11
runtime.win7-x86.Microsoft.NETCore.DotNetHost | 1.1.11
runtime.win7-x86.Microsoft.NETCore.DotNetHostPolicy | 1.1.11
runtime.win7-x86.Microsoft.NETCore.DotNetHostResolver | 1.1.11
