# .NET Core 2.1.15 Update - January 14, 2020

[.NET Core 2.1.15](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.15, ASP.NET Core 2.1.15 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2115)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4119](https://github.com/dotnet/core/issues/4119) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.608](2.1.608-download.md) |
| Windows | Visual Studio 2017 | [2.1.511](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |



## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)
* [dotnet/aspnetcore](https://hub.docker.com/_/microsoft-dotnet-core-aspnet)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.15 is being deployed to Azure App Services and the deployment is expected to complete later in January 2020.

## .NET Core Lifecycle News

[.NET Core 2.2 reached end of life](https://github.com/dotnet/announcements/issues/147/) on December 23, 2019. This means .NET Core 2.2 is no longer supported and updates will no longer be provided. We recommend moving to .NET Core 3.1, our long term support (LTS) release.

.NET Core 3.0 will reach end of life on March 3, 2020 which is 3 months after the release of .NET Core 3.1. You can view the [Microsoft Support for .NET Core](https://github.com/dotnet/core/blob/main/microsoft-support.md) for more information about life-cycle of each product.

Fedora 29 has been out of support since [November 29, 2019](https://fedoraproject.org/wiki/End_of_life) and .NET Core no longer provides support for it.

Ubuntu 19.04 will be out of support on [January 23, 2020](https://lists.ubuntu.com/archives/ubuntu-announce/2020-January/thread.html).

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.


## Changes in 2.1.15

.NET Core 2.1.15 release carries both security and non-security fixes.

### [CVE-2020-0602: ASP.NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-0602)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability exists when ASP.NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how the ASP.NET Core web application handles web requests.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.Http.Connections  | 1.0.0 - 1.0.4  | 1.0.15
Microsoft.AspNetCore.App  | 2.1.0 - 2.1.14 <br> 3.0.0 <br> 3.1.0 | 2.1.15 <br> 3.0.1 <br> 3.1.1
Microsoft.AspNetCore.All  | 2.1.0 - 2.1.14 | 2.0.15

### [CVE-2020-0603: ASP.NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-0603)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a remote code execution vulnerability exists in ASP.NET Core software when the software fails to handle objects in memory. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how the ASP.NET Core web application handles in memory.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.Http.Connections  | 1.0.0 - 1.0.4 | 1.0.15
Microsoft.AspNetCore.App  | 2.1.0 - 2.1.14 <br> 3.0.0 <br> 3.1.0 | 2.1.15 <br> 3.0.1 <br> 3.1.1
Microsoft.AspNetCore.All  | 2.1.0 - 2.1.14 | 2.1.15

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.1.15+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.15+label%3Aservicing-approved)


## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.AspNetCore.All | 2.1.15
Microsoft.AspNetCore.App | 2.1.15
Microsoft.AspNetCore.Http.Connections | 1.0.15
Microsoft.AspNetCore.SignalR.Core | 1.0.15
Microsoft.DotNet.Web.Client.ItemTemplates | 2.1.15
Microsoft.DotNet.Web.ItemTemplates | 2.1.15
Microsoft.DotNet.Web.ProjectTemplates.2.1 | 2.1.15
Microsoft.DotNet.Web.Spa.ProjectTemplates.2.1 | 2.1.15
Microsoft.NETCore.App | 2.1.15
Microsoft.NETCore.DotNetAppHost | 2.1.15
Microsoft.NETCore.DotNetHost | 2.1.15
Microsoft.NETCore.DotNetHostPolicy | 2.1.15
Microsoft.NETCore.DotNetHostResolver | 2.1.15
Microsoft.NETCore.Platforms | 2.1.7
runtime.linux-arm.Microsoft.NETCore.App | 2.1.15
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.linux-arm64.Microsoft.NETCore.App | 2.1.15
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.linux-musl-x64.Microsoft.NETCore.App | 2.1.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.linux-x64.Microsoft.NETCore.App | 2.1.15
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.osx-x64.Microsoft.NETCore.App | 2.1.15
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.rhel.6-x64.Microsoft.NETCore.App | 2.1.15
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.win-arm.Microsoft.NETCore.App | 2.1.15
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.win-arm.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.win-arm64.Microsoft.NETCore.App | 2.1.15
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.win-x64.Microsoft.NETCore.App | 2.1.15
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.win-x64.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.15
runtime.win-x86.Microsoft.NETCore.App | 2.1.15
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 2.1.15
runtime.win-x86.Microsoft.NETCore.DotNetHost | 2.1.15
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 2.1.15
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 2.1.15
System.Security.Cryptography.Cng | 4.5.
VS.Redist.Common.NetCore.HostFXR.x64.2.1 | 2.1.15
VS.Redist.Common.NetCore.HostFXR.x86.2.1 | 2.1.15
VS.Redist.Common.NetCore.SharedFramework.x64.2.1 | 2.1.15
VS.Redist.Common.NetCore.SharedFramework.x86.2.1 | 2.1.15
VS.Redist.Common.NetCore.SharedHost.x64.2.1 | 2.1.15
VS.Redist.Common.NetCore.SharedHost.x86.2.1 | 2.1.15


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.15/2.1.15.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.15-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.15-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-January-2020/


[//]: # ( Runtime 2.1.15)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0f4dff6-b11d-410f-b1ba-7b07cd52de03/f2b41b5eb264457f93289b24ec00840e/dotnet-runtime-2.1.15-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d2f71530-ae4d-4e39-883a-2b1f352d881f/691aa2a1575b82d78947444dabc07b74/dotnet-runtime-2.1.15-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aac35220-5c0f-4710-be3e-4a45cf102351/946ae9324c315180b81ca01fd9e88160/dotnet-runtime-2.1.15-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d2fb0b54-01ce-452c-b2a2-86dbef286265/055ad7740827cbe862d14ceb7ea54fac/dotnet-runtime-2.1.15-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/216582f3-9bcd-42c9-b08d-bcb47135b9d9/a66ae31d9ecfff817d315064f8ce82da/dotnet-runtime-2.1.15-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dfbcb9bd-def7-4d3d-9349-e89eec00a211/d68922ee27202d871b434c9ec02bc7fd/dotnet-runtime-2.1.15-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8cc8c64b-ac76-4196-a256-3e3ca704d50d/6d22b4069c3b2f565b2e8e51920554cb/dotnet-runtime-2.1.15-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/37c65512-8151-4922-8793-673aafb8fd77/b021fcde664e9f5e66bf6b335db89616/dotnet-runtime-2.1.15-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/18787ef1-5947-4a39-8359-5da842e3dce9/c5366b88a66bf3630d243105465f9ed0/dotnet-runtime-2.1.15-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0ec339ef-df14-4b42-804a-46d776a70886/7010c6bb774ebb437deab0fc21ed6428/dotnet-runtime-2.1.15-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/67a6e7a9-943a-4e6f-86e4-f9342d6332ce/1a9ee400989c4c60cd6c91b63da98809/dotnet-runtime-2.1.15-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/07f587cb-fb85-445d-818d-0b11771cdf5b/0185a27025624277fc3c2d053cd536e4/dotnet-runtime-2.1.15-win-x86.zip

[//]: # ( WindowsDesktop 2.1.15)

[//]: # ( ASP 2.1.15)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/125a3a2f-fd71-4b95-bf18-084356595eca/d48ffcd3bdf63cbb52d47b81781f930f/aspnetcore-runtime-2.1.15-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12108519-40db-47ed-bf20-8804eecaf7be/0439b2c3f24b1279880a29c42459e1ee/aspnetcore-runtime-2.1.15-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3a4fa17f-1c69-497c-b04d-b2d323b58f17/0994ea07591e8592f95f6057f5a68bdc/aspnetcore-runtime-2.1.15-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ce8e365-3992-46f5-a933-e8717ece8e45/4eb1c9bd819a9a4042b92440a5af86a9/aspnetcore-runtime-2.1.15-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a7a9163f-85d3-4c9b-a54b-26e8b43d054e/d5f4d4a2f3f1623c7caed71a21a96ddf/aspnetcore-runtime-2.1.15-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8ab75ed5-07d8-4903-9ea3-5bff2ed6acc6/2123f26d41da7d13701e7e482291eb43/aspnetcore-runtime-2.1.15-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c9df4e72-e7b1-4d87-b0ca-4512bc462d81/a67e6e1c998ece8d771bd795f3bcd426/aspnetcore-runtime-2.1.15-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a7ca5304-9c43-4f80-8996-78bb1730fd18/6d0e83e74d1119858dff1aec2198740c/aspnetcore-runtime-2.1.15-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/633b17e5-a489-4da4-9713-5ddedf17a5f0/5c18f4203e837dd90ba3da59eee92b01/dotnet-hosting-2.1.15-win.exe

[//]: # ( SDK 2.1.511 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d123c59a-c417-40e6-9f68-9f935ab0b18a/8f5546ddd18d4ca13b8f9f156ab60c3b/dotnet-sdk-2.1.511-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c04f7a6-93bb-44a2-8c23-2a0b1afde050/aebadbbf9c054dc532ecce47b67496d4/dotnet-sdk-2.1.511-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f31cf2dc-2b05-4b6d-8f7c-581c9f0956cc/181e3633963630e979f6886067b5447c/dotnet-sdk-2.1.511-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75f67c37-7717-4ebe-91a8-4206133d087f/61c0569e4e25a7c3acebed759be26d49/dotnet-sdk-2.1.511-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4d10b6ee-f840-411f-b1e3-e9708a9ec091/3bd7834a25f089062ab6f20f0f0fe977/dotnet-sdk-2.1.511-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb764d9c-da7c-435a-b1c0-66343fda4f96/87f5b39f6ceabae27a717071f72cb527/dotnet-sdk-2.1.511-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ed2be02-7bb0-4b54-8dea-b32da5599315/530f585aad1a3d2cc4da71ba858a195e/dotnet-sdk-2.1.511-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/eb676217-04c4-414d-819e-c51233e5bff9/5dc9947b4ee57d665452c1f50374a357/dotnet-sdk-2.1.511-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/21d6a062-4777-4ad4-a97d-50ca2339a1da/822258211dcb8260b3b46e8fa2807cdd/dotnet-sdk-2.1.511-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7b947d96-d1b9-4950-a023-9956d3dc47db/c779f3ce8edcfe515859dd1bb6dcccbb/dotnet-sdk-2.1.511-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7a59180e-fab9-4d9a-be6c-861d198ca9a0/1a14a920ee35b09ab71366e622335b39/dotnet-sdk-2.1.511-win-x86.zip

[//]: # ( Symbols )
