# .NET Core 2.1.23 Update - October 13, 2020

[.NET Core 2.1.23](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.23, ASP.NET Core 2.1.23 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2123)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5347](https://github.com/dotnet/core/issues/5347) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.616](2.1.616-download.md) |
| Windows | Visual Studio 2017 | [2.1.519](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update won't be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's October servicing release.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies


## .NET Core Lifecycle News

Fedroa 33 and Ubuntu 20.10 has been added as [supported OS](../2.1-supported-os.md) with this update of .NET Core 3.1.

## Changes in 2.1.23

.NET Core 2.1.23 release carries only non-security fixes.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.23.nupkg
microsoft.aspnetcore.app | 2.1.23.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.23.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.23.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.23.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.23.nupkg
microsoft.extensions.caching.abstractions | 2.1.23.nupkg
microsoft.extensions.caching.memory | 2.1.23.nupkg
system.io.pipelines | 4.5.4.nupkg
microsoft.netcore.app | 2.1.23.nupkg
microsoft.netcore.dotnetapphost | 2.1.23.nupkg
microsoft.netcore.dotnethost | 2.1.23.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.23.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.23.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.23.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.23.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.23.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.23.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.23.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.23.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.23.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.23.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.23.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.23.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.23.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.23.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.23-servicing-29322-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.23-servicing-29322-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.23-servicing-29322-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.23-servicing-29322-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.23-servicing-29322-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.23-servicing-29322-01.nupkg




[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.23/2.1.23.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.23-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.23-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-october-2020/

[//]: # ( Runtime 2.1.23)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0d4bf96-e481-4c16-a2dc-69f002f2f892/ee8457bcbfae80bb4e76efe04f5bd3e2/dotnet-runtime-2.1.23-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/832a703f-ca7e-4fa5-8b8d-bc87d6cbf4f0/15d78d838a2173d470c2e9a97b0c7b63/dotnet-runtime-2.1.23-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1693393c-e916-497d-ab55-304be84f75d6/aca7f9d2befdec0b26373510eddf51bb/dotnet-runtime-2.1.23-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e52a08ae-0a98-4dbf-b371-bf50815ae05a/48e4eb969aee8df978fa2f32b743ae76/dotnet-runtime-2.1.23-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8cd129d5-207f-4cfd-a5fb-5f2c56ee81c0/824ed5222546398bc90b586b402c0324/dotnet-runtime-2.1.23-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d6c0e87-ed74-4a83-939a-3bc752a442b3/f989f900d202e949b0fba3a2afc442f5/dotnet-runtime-2.1.23-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e391c65-0174-4ce6-8fbc-254fb4cbc567/2cfabd8d9a8f46ab32084ceb0d2ebf37/dotnet-runtime-2.1.23-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/35d8cc1b-4cd0-49b9-bd9f-9d4183842d3e/a91ceb48d8716bd600619dd8eb5a784e/dotnet-runtime-2.1.23-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b6dd738b-bb15-448a-86cd-e8cf96138a06/0b0ad58041510ca8ed00957764b37c13/dotnet-runtime-2.1.23-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/75a5ff0b-f69f-4364-b922-60e2dbe562e2/823dfb5bab4dadf9ca9b698e191d0a81/dotnet-runtime-2.1.23-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d5f6d9c8-7634-4b44-80e1-6e07670c08df/53aae9018e45a5c3e2a0ff503ec8c4af/dotnet-runtime-2.1.23-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c4fa76ed-1afe-4902-8ef9-2b4768e84202/1e239ee5c1de03a712ae57ab3184f2e9/dotnet-runtime-2.1.23-win-x86.zip

[//]: # ( ASP 2.1.23)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73592379-5553-461d-9472-f54688488955/74bc7c5a34487da9447b9544679566c1/aspnetcore-runtime-2.1.23-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c881d8d-bae5-4f70-adf9-278d7c0d3ea1/c5d707365e2b84d3cf97d68211592300/aspnetcore-runtime-2.1.23-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3422a123-3f37-4544-b0ed-e3922b50e1b0/c34c607ba18a67763bacded434607c56/aspnetcore-runtime-2.1.23-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6469b602-063e-4296-a446-57a00845d542/45e3896844149e1109661d89f2ee12ab/aspnetcore-runtime-2.1.23-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7464f6c4-0d39-470b-824d-50ffb3825b33/2d6b1e085f5429413d9fb7e42632f5b1/aspnetcore-runtime-2.1.23-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c1907d59-03d9-4f47-a3e6-640720010103/fcb027da4bc9ba076fbe7c7cb1a2690b/aspnetcore-runtime-2.1.23-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/175fcf7f-3cc3-413f-afa2-2c7f1b6357a8/55e778aa29242f4b8cee9e40eeb43605/aspnetcore-runtime-2.1.23-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9b97a12c-818c-485c-8ebd-cc7d132ce5b0/6fe7f407e019364da2d3458e88d9c5fc/aspnetcore-runtime-2.1.23-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/3e3c37fb-4d77-4558-a78c-17434e1cc804/60116643f610fb43f858af4e0dc1b223/dotnet-hosting-2.1.23-win.exe

[//]: # ( SDK 2.1.519 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f753b68-cf67-4562-b964-0fac9df4b6d6/e6d40a254c63dbab79bdd60f78f5c10c/dotnet-sdk-2.1.519-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25cfd780-54b4-4170-8c08-d0a96d8837d4/6d5f74febc099b18d1161f0c17b97ebb/dotnet-sdk-2.1.519-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1dfd7066-ad28-42d7-94a6-55619798b86a/4e99d531894f06372f3ed04813a624f0/dotnet-sdk-2.1.519-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a908e90e-fb10-4573-bb63-a7c09cd3bf06/b540d5eb1b3fd581c996921b60fc9e91/dotnet-sdk-2.1.519-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7871387c-aea9-4228-b703-f81bfe3b41ca/217ff603d32ec97fa604e9b2a52e2e95/dotnet-sdk-2.1.519-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79c061fe-1bdc-4134-8138-da5dd897e6c5/2dd0ef1775073970448cd62bb48c2a47/dotnet-sdk-2.1.519-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0c32495-bc33-421c-a12d-d05a5ae0faeb/1de14ecaaddeaa5c75de102871fd19ec/dotnet-sdk-2.1.519-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/548c6de4-bc4c-4e4f-b148-9551656f994a/0016fbe28e9193844b8aad8aa8b090fd/dotnet-sdk-2.1.519-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/41ccf3eb-f137-4140-9dc0-b39caa9861d6/12da178dc042f00201a65fbf120abae5/dotnet-sdk-2.1.519-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/77ecbd22-23fc-488c-aab9-d5e419f8d1b0/2542e487b475bfb3a5eb8ee0f03946d9/dotnet-sdk-2.1.519-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b4937af6-a9bb-4f02-addf-1ce59b792d65/a8597f405ce235f1bca1723c461534d8/dotnet-sdk-2.1.519-win-x86.zip
