# .NET Core 3.0 Known Issues

This document lists known issues for **.NET Core 3.0 GA and beyond releases** which may be encountered during usage.

## .NET Core

### .NET Core 3.0.2 SDK (3.0.102 SDK)
- **ASP.NET Core runtime issue on systems other than Windows x-64 ([aspnet/Announcements/401](https://github.com/aspnet/Announcements/issues/401))**

    When using the 3.0.102 SDK to build an application and then deploying to a runtime environment other than 64-bit Windows, people may see a runtime exception failing to load certain dependencies.  This can be worked around by adding a `PackageReference` directly to the package that fails to load.

    More information can be found in the referenced issue.

### .NET Core 3.0.1 SDK (3.0.101 SDK)

- **ASP.NET Core workloads may use older dependencies for libraries that are present in the Targeting Pack ([aspnet/Announcements/398](https://github.com/aspnet/Announcements/issues/398))** 

    When using the 3.0.101 SDK, people who are building ASP.NET Core workloads may encounter an error where lower versioned dependencies that are referenced by the application aren't removed correctly. The most common occurrence of this issue is when hosting with IIS, where there is mismatch between two libraries causing a `NullReferenceException`. 
    
    Workarounds and more information are in the referenced issue.

### .NET Core 3.0 SDK, all releases

- **`PATH` intermittently not updated when installing on MacOS ([core-sdk/3331](https://github.com/dotnet/core-sdk/issues/3331))**

    There are some situations, which we do not yet understand, where PATH is not properly updated after installing the .NET Core SDK on MacOS. The result is a `dotnet: command not found` error reported in the terminal when attempting to run a `dotnet` command.

    The PATH issue can be confirmed by typing `echo $PATH | grep "dotnet"` and observing if `dotnet` is shown in the output. If `/usr/local/share/dotnet` is not present in PATH, it can be added for the current terminal session with `export PATH = $PATH:/usr/local/share/dotnet`.

    To update the path for every new terminal session, the `export` entry will need to be added to your terminal resource file. This file will be different depending upon your default terminal (eg bash, zsh, ...) and configuration (.bash_profile, .bashrc, .zshrc, ...).

- **Projects fail to build if the `UserSecretsId` property is set but the project doesn't reference Microsoft.Extensions.Configuration.UserSecrets ([core-sdk/3290](https://github.com/dotnet/core/issues/3290))**

    The .NET SDK now generates a `Microsoft.Extensions.Configuration.UserSecrets.UserSecretsIdAttribute` if the `UserSecretsId` property is set.  If the assembly which defines this attribute (Microsoft.Extensions.Configuration.UserSecrets.dll) isn't referenced, then the project will fail to build, with an error similar to the following:
    
    > Error CS0234 The type or namespace name 'Extensions' does not exist in the namespace 'Microsoft' (are you missing an assembly reference?)
    
    To work around the issue, you can do any of the following:
    
    - Set the `GenerateUserSecretsAttribute` MSBuild property to false.
    - Unset the `UserSecretsId` property
    - If targeting .NET Core 3.0, add a `FrameworkReference` item to `Microsoft.AspNetCore.App`
    - Add a `PackageReference` to the `Microsoft.Extensions.Configuration.UserSecrets`

### Preview 9

- **Misnamed or colliding non-resx resources ([microsoft/msbuild#4740](https://github.com/microsoft/msbuild/issues/4740))**

    Projects that specify non-resx `EmbeddedResource`s may have the resources embedded under an incorrect name (causing code that uses the correct name to fail at runtime). If two or more files are embedded in this way, `CS1508: The resource identifier ... has already been used in this assembly` may be issued at build time.
    
    This can be worked around with a property in the project file
    
    ```xml
    <PropertyGroup>
        <!-- Work around https://github.com/microsoft/msbuild/issues/4740 -->
        <EmbeddedResourceUseDependentUponConvention>false</EmbeddedResourceUseDependentUponConvention>
    </PropertyGroup>
    ```

### Preview 5

- **Visual style in WinForms app not showing correctly when publishing with PublishReadyToRun=true**

    The ReadyToRun compiler in this preview does not copy Win32 resources from the managed assembly to the compiled output binary, which causes an issue with visual styles in WinForms apps. The workaround is to skip compilation of System.Windows.Forms.dll by adding the following to the project file:
    ```xml
    <ItemGroup>
      <PublishReadyToRunExclude Include="System.Windows.Forms.dll" />            
    </ItemGroup>
    ```    

## ASP.NET Core

### 3.0.0 GA
    
- **gRPC runtime files may not be deployed on publish**

    It is possible that some gRPC runtime files (PDBs) will not be deployed when publishing your application.
    
    This can be fixed by updating your package reference to `Grpc.AspNetCore` to `2.23.2` (or greater) in the project file:
    
    ```xml
    <ItemGroup>
      <PackageReference Include="Grpc.AspNetCore" Version="2.23.2" />
    </ItemGroup>
    ```
## WPF.NET Core

### 3.0.0 GA
    
- **Trying to use the AspNetCore gRPC fails to build ([WPF/810](https://github.com/dotnet/wpf/issues/810))**

 Trying to use a gRPC service in a WPF app, `<UseWPF>true</UseWPF>`, results in a build error. Visual Studio and VSCode does not report the problem in intellisense but it appears when doing a `dotnet build .sln`.
 
 **Actual behavior:** <!-- callstack for crashes / exceptions -->
Results in a 
```
error CS0246: The type or namespace name 'Greet' could not be found (are you missing a using directive or an assembly reference?)
```

As a workaround the client gRPC portion can be split into a separate project and it will build correctly. 
