# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public class ComAwareEventInfo : EventInfo {
+        public override int MetadataToken { get; }
+        public override Module Module { get; }
+        public override IList<CustomAttributeData> GetCustomAttributesData();
+        public override MethodInfo[] GetOtherMethods(bool nonPublic);
     }
+    public delegate IntPtr DllImportResolver(string libraryName, Assembly assembly, DllImportSearchPath? searchPath);
-    public struct HandleRef
+    public readonly struct HandleRef
     public static class Marshal {
+        public static int GetEndComSlot(Type t);
+        public static IntPtr GetExceptionPointers();
+        public static bool IsTypeVisibleFromCom(Type t);
     }
     public static class MemoryMarshal {
+        public static ref readonly T AsRef<T>(ReadOnlySpan<byte> span) where T : struct;
+        public static ref T AsRef<T>(Span<byte> span) where T : struct;
     }
+    public static class NativeLibrary {
+        public static void Free(IntPtr handle);
+        public static IntPtr GetExport(IntPtr handle, string name);
+        public static IntPtr Load(string libraryPath);
+        public static IntPtr Load(string libraryName, Assembly assembly, DllImportSearchPath? searchPath);
+        public static void SetDllImportResolver(Assembly assembly, DllImportResolver resolver);
+        public static bool TryGetExport(IntPtr handle, string name, out IntPtr address);
+        public static bool TryLoad(string libraryPath, out IntPtr handle);
+        public static bool TryLoad(string libraryName, Assembly assembly, DllImportSearchPath? searchPath, out IntPtr handle);
+    }
     public readonly struct OSPlatform : IEquatable<OSPlatform> {
+        public static OSPlatform FreeBSD { get; }
     }
     public static class SequenceMarshal {
+        public static bool TryRead<T>(ref SequenceReader<byte> reader, out T value) where T : struct;
     }
+    public class StandardOleMarshalObject : MarshalByRefObject {
+        protected StandardOleMarshalObject();
+    }
 }
```

