# System.Runtime.Intrinsics.X86

``` diff
+namespace System.Runtime.Intrinsics.X86 {
+    public abstract class Aes : Sse2 {
+        public static new bool IsSupported { get; }
+        public static Vector128<byte> Decrypt(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<byte> DecryptLast(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<byte> Encrypt(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<byte> EncryptLast(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<byte> InverseMixColumns(Vector128<byte> value);
+        public static Vector128<byte> KeygenAssist(Vector128<byte> value, byte control);
+    }
+    public abstract class Avx : Sse42 {
+        public static new bool IsSupported { get; }
+        public static Vector256<double> Add(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Add(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> AddSubtract(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> AddSubtract(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> And(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> And(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> AndNot(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> AndNot(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Blend(Vector256<double> left, Vector256<double> right, byte control);
+        public static Vector256<float> Blend(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<double> BlendVariable(Vector256<double> left, Vector256<double> right, Vector256<double> mask);
+        public static Vector256<float> BlendVariable(Vector256<float> left, Vector256<float> right, Vector256<float> mask);
+        public unsafe static Vector128<float> BroadcastScalarToVector128(float* source);
+        public unsafe static Vector256<double> BroadcastScalarToVector256(double* source);
+        public unsafe static Vector256<float> BroadcastScalarToVector256(float* source);
+        public unsafe static Vector256<double> BroadcastVector128ToVector256(double* address);
+        public unsafe static Vector256<float> BroadcastVector128ToVector256(float* address);
+        public static Vector256<double> Ceiling(Vector256<double> value);
+        public static Vector256<float> Ceiling(Vector256<float> value);
+        public static Vector128<double> Compare(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<float> Compare(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static Vector256<double> Compare(Vector256<double> left, Vector256<double> right, FloatComparisonMode mode);
+        public static Vector256<float> Compare(Vector256<float> left, Vector256<float> right, FloatComparisonMode mode);
+        public static Vector128<double> CompareScalar(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<float> CompareScalar(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static Vector128<int> ConvertToVector128Int32(Vector256<double> value);
+        public static Vector128<int> ConvertToVector128Int32WithTruncation(Vector256<double> value);
+        public static Vector128<float> ConvertToVector128Single(Vector256<double> value);
+        public static Vector256<double> ConvertToVector256Double(Vector128<int> value);
+        public static Vector256<double> ConvertToVector256Double(Vector128<float> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector256<float> value);
+        public static Vector256<int> ConvertToVector256Int32WithTruncation(Vector256<float> value);
+        public static Vector256<float> ConvertToVector256Single(Vector256<int> value);
+        public static Vector256<double> Divide(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Divide(Vector256<float> left, Vector256<float> right);
+        public static Vector256<float> DotProduct(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<double> DuplicateEvenIndexed(Vector256<double> value);
+        public static Vector256<float> DuplicateEvenIndexed(Vector256<float> value);
+        public static Vector256<float> DuplicateOddIndexed(Vector256<float> value);
+        public static Vector128<byte> ExtractVector128(Vector256<byte> value, byte index);
+        public static Vector128<double> ExtractVector128(Vector256<double> value, byte index);
+        public static Vector128<short> ExtractVector128(Vector256<short> value, byte index);
+        public static Vector128<int> ExtractVector128(Vector256<int> value, byte index);
+        public static Vector128<long> ExtractVector128(Vector256<long> value, byte index);
+        public static Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, byte index);
+        public static Vector128<float> ExtractVector128(Vector256<float> value, byte index);
+        public static Vector128<ushort> ExtractVector128(Vector256<ushort> value, byte index);
+        public static Vector128<uint> ExtractVector128(Vector256<uint> value, byte index);
+        public static Vector128<ulong> ExtractVector128(Vector256<ulong> value, byte index);
+        public static Vector256<double> Floor(Vector256<double> value);
+        public static Vector256<float> Floor(Vector256<float> value);
+        public static Vector256<double> HorizontalAdd(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> HorizontalAdd(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> HorizontalSubtract(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> HorizontalSubtract(Vector256<float> left, Vector256<float> right);
+        public static Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, byte index);
+        public static Vector256<double> InsertVector128(Vector256<double> value, Vector128<double> data, byte index);
+        public static Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, byte index);
+        public static Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, byte index);
+        public static Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, byte index);
+        public static Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, byte index);
+        public static Vector256<float> InsertVector128(Vector256<float> value, Vector128<float> data, byte index);
+        public static Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, byte index);
+        public static Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, byte index);
+        public static Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, byte index);
+        public unsafe static Vector256<byte> LoadAlignedVector256(byte* address);
+        public unsafe static Vector256<double> LoadAlignedVector256(double* address);
+        public unsafe static Vector256<short> LoadAlignedVector256(short* address);
+        public unsafe static Vector256<int> LoadAlignedVector256(int* address);
+        public unsafe static Vector256<long> LoadAlignedVector256(long* address);
+        public unsafe static Vector256<sbyte> LoadAlignedVector256(sbyte* address);
+        public unsafe static Vector256<float> LoadAlignedVector256(float* address);
+        public unsafe static Vector256<ushort> LoadAlignedVector256(ushort* address);
+        public unsafe static Vector256<uint> LoadAlignedVector256(uint* address);
+        public unsafe static Vector256<ulong> LoadAlignedVector256(ulong* address);
+        public unsafe static Vector256<byte> LoadDquVector256(byte* address);
+        public unsafe static Vector256<short> LoadDquVector256(short* address);
+        public unsafe static Vector256<int> LoadDquVector256(int* address);
+        public unsafe static Vector256<long> LoadDquVector256(long* address);
+        public unsafe static Vector256<sbyte> LoadDquVector256(sbyte* address);
+        public unsafe static Vector256<ushort> LoadDquVector256(ushort* address);
+        public unsafe static Vector256<uint> LoadDquVector256(uint* address);
+        public unsafe static Vector256<ulong> LoadDquVector256(ulong* address);
+        public unsafe static Vector256<byte> LoadVector256(byte* address);
+        public unsafe static Vector256<double> LoadVector256(double* address);
+        public unsafe static Vector256<short> LoadVector256(short* address);
+        public unsafe static Vector256<int> LoadVector256(int* address);
+        public unsafe static Vector256<long> LoadVector256(long* address);
+        public unsafe static Vector256<sbyte> LoadVector256(sbyte* address);
+        public unsafe static Vector256<float> LoadVector256(float* address);
+        public unsafe static Vector256<ushort> LoadVector256(ushort* address);
+        public unsafe static Vector256<uint> LoadVector256(uint* address);
+        public unsafe static Vector256<ulong> LoadVector256(ulong* address);
+        public unsafe static Vector128<double> MaskLoad(double* address, Vector128<double> mask);
+        public unsafe static Vector256<double> MaskLoad(double* address, Vector256<double> mask);
+        public unsafe static Vector128<float> MaskLoad(float* address, Vector128<float> mask);
+        public unsafe static Vector256<float> MaskLoad(float* address, Vector256<float> mask);
+        public unsafe static void MaskStore(double* address, Vector128<double> mask, Vector128<double> source);
+        public unsafe static void MaskStore(double* address, Vector256<double> mask, Vector256<double> source);
+        public unsafe static void MaskStore(float* address, Vector128<float> mask, Vector128<float> source);
+        public unsafe static void MaskStore(float* address, Vector256<float> mask, Vector256<float> source);
+        public static Vector256<double> Max(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Max(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Min(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Min(Vector256<float> left, Vector256<float> right);
+        public static int MoveMask(Vector256<double> value);
+        public static int MoveMask(Vector256<float> value);
+        public static Vector256<double> Multiply(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Multiply(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Or(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Or(Vector256<float> left, Vector256<float> right);
+        public static Vector128<double> Permute(Vector128<double> value, byte control);
+        public static Vector128<float> Permute(Vector128<float> value, byte control);
+        public static Vector256<double> Permute(Vector256<double> value, byte control);
+        public static Vector256<float> Permute(Vector256<float> value, byte control);
+        public static Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, byte control);
+        public static Vector256<double> Permute2x128(Vector256<double> left, Vector256<double> right, byte control);
+        public static Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, byte control);
+        public static Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, byte control);
+        public static Vector256<float> Permute2x128(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, byte control);
+        public static Vector128<double> PermuteVar(Vector128<double> left, Vector128<long> control);
+        public static Vector128<float> PermuteVar(Vector128<float> left, Vector128<int> control);
+        public static Vector256<double> PermuteVar(Vector256<double> left, Vector256<long> control);
+        public static Vector256<float> PermuteVar(Vector256<float> left, Vector256<int> control);
+        public static Vector256<float> Reciprocal(Vector256<float> value);
+        public static Vector256<float> ReciprocalSqrt(Vector256<float> value);
+        public static Vector256<double> RoundCurrentDirection(Vector256<double> value);
+        public static Vector256<float> RoundCurrentDirection(Vector256<float> value);
+        public static Vector256<double> RoundToNearestInteger(Vector256<double> value);
+        public static Vector256<float> RoundToNearestInteger(Vector256<float> value);
+        public static Vector256<double> RoundToNegativeInfinity(Vector256<double> value);
+        public static Vector256<float> RoundToNegativeInfinity(Vector256<float> value);
+        public static Vector256<double> RoundToPositiveInfinity(Vector256<double> value);
+        public static Vector256<float> RoundToPositiveInfinity(Vector256<float> value);
+        public static Vector256<double> RoundToZero(Vector256<double> value);
+        public static Vector256<float> RoundToZero(Vector256<float> value);
+        public static Vector256<double> Shuffle(Vector256<double> value, Vector256<double> right, byte control);
+        public static Vector256<float> Shuffle(Vector256<float> value, Vector256<float> right, byte control);
+        public static Vector256<double> Sqrt(Vector256<double> value);
+        public static Vector256<float> Sqrt(Vector256<float> value);
+        public unsafe static void Store(byte* address, Vector256<byte> source);
+        public unsafe static void Store(double* address, Vector256<double> source);
+        public unsafe static void Store(short* address, Vector256<short> source);
+        public unsafe static void Store(int* address, Vector256<int> source);
+        public unsafe static void Store(long* address, Vector256<long> source);
+        public unsafe static void Store(sbyte* address, Vector256<sbyte> source);
+        public unsafe static void Store(float* address, Vector256<float> source);
+        public unsafe static void Store(ushort* address, Vector256<ushort> source);
+        public unsafe static void Store(uint* address, Vector256<uint> source);
+        public unsafe static void Store(ulong* address, Vector256<ulong> source);
+        public unsafe static void StoreAligned(byte* address, Vector256<byte> source);
+        public unsafe static void StoreAligned(double* address, Vector256<double> source);
+        public unsafe static void StoreAligned(short* address, Vector256<short> source);
+        public unsafe static void StoreAligned(int* address, Vector256<int> source);
+        public unsafe static void StoreAligned(long* address, Vector256<long> source);
+        public unsafe static void StoreAligned(sbyte* address, Vector256<sbyte> source);
+        public unsafe static void StoreAligned(float* address, Vector256<float> source);
+        public unsafe static void StoreAligned(ushort* address, Vector256<ushort> source);
+        public unsafe static void StoreAligned(uint* address, Vector256<uint> source);
+        public unsafe static void StoreAligned(ulong* address, Vector256<ulong> source);
+        public unsafe static void StoreAlignedNonTemporal(byte* address, Vector256<byte> source);
+        public unsafe static void StoreAlignedNonTemporal(double* address, Vector256<double> source);
+        public unsafe static void StoreAlignedNonTemporal(short* address, Vector256<short> source);
+        public unsafe static void StoreAlignedNonTemporal(int* address, Vector256<int> source);
+        public unsafe static void StoreAlignedNonTemporal(long* address, Vector256<long> source);
+        public unsafe static void StoreAlignedNonTemporal(sbyte* address, Vector256<sbyte> source);
+        public unsafe static void StoreAlignedNonTemporal(float* address, Vector256<float> source);
+        public unsafe static void StoreAlignedNonTemporal(ushort* address, Vector256<ushort> source);
+        public unsafe static void StoreAlignedNonTemporal(uint* address, Vector256<uint> source);
+        public unsafe static void StoreAlignedNonTemporal(ulong* address, Vector256<ulong> source);
+        public static Vector256<double> Subtract(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Subtract(Vector256<float> left, Vector256<float> right);
+        public static bool TestC(Vector128<double> left, Vector128<double> right);
+        public static bool TestC(Vector128<float> left, Vector128<float> right);
+        public static bool TestC(Vector256<byte> left, Vector256<byte> right);
+        public static bool TestC(Vector256<double> left, Vector256<double> right);
+        public static bool TestC(Vector256<short> left, Vector256<short> right);
+        public static bool TestC(Vector256<int> left, Vector256<int> right);
+        public static bool TestC(Vector256<long> left, Vector256<long> right);
+        public static bool TestC(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static bool TestC(Vector256<float> left, Vector256<float> right);
+        public static bool TestC(Vector256<ushort> left, Vector256<ushort> right);
+        public static bool TestC(Vector256<uint> left, Vector256<uint> right);
+        public static bool TestC(Vector256<ulong> left, Vector256<ulong> right);
+        public static bool TestNotZAndNotC(Vector128<double> left, Vector128<double> right);
+        public static bool TestNotZAndNotC(Vector128<float> left, Vector128<float> right);
+        public static bool TestNotZAndNotC(Vector256<byte> left, Vector256<byte> right);
+        public static bool TestNotZAndNotC(Vector256<double> left, Vector256<double> right);
+        public static bool TestNotZAndNotC(Vector256<short> left, Vector256<short> right);
+        public static bool TestNotZAndNotC(Vector256<int> left, Vector256<int> right);
+        public static bool TestNotZAndNotC(Vector256<long> left, Vector256<long> right);
+        public static bool TestNotZAndNotC(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static bool TestNotZAndNotC(Vector256<float> left, Vector256<float> right);
+        public static bool TestNotZAndNotC(Vector256<ushort> left, Vector256<ushort> right);
+        public static bool TestNotZAndNotC(Vector256<uint> left, Vector256<uint> right);
+        public static bool TestNotZAndNotC(Vector256<ulong> left, Vector256<ulong> right);
+        public static bool TestZ(Vector128<double> left, Vector128<double> right);
+        public static bool TestZ(Vector128<float> left, Vector128<float> right);
+        public static bool TestZ(Vector256<byte> left, Vector256<byte> right);
+        public static bool TestZ(Vector256<double> left, Vector256<double> right);
+        public static bool TestZ(Vector256<short> left, Vector256<short> right);
+        public static bool TestZ(Vector256<int> left, Vector256<int> right);
+        public static bool TestZ(Vector256<long> left, Vector256<long> right);
+        public static bool TestZ(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static bool TestZ(Vector256<float> left, Vector256<float> right);
+        public static bool TestZ(Vector256<ushort> left, Vector256<ushort> right);
+        public static bool TestZ(Vector256<uint> left, Vector256<uint> right);
+        public static bool TestZ(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<double> UnpackHigh(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> UnpackHigh(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> UnpackLow(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> UnpackLow(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Xor(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Xor(Vector256<float> left, Vector256<float> right);
+    }
+    public abstract class Avx2 : Avx {
+        public static new bool IsSupported { get; }
+        public static Vector256<ushort> Abs(Vector256<short> value);
+        public static Vector256<uint> Abs(Vector256<int> value);
+        public static Vector256<byte> Abs(Vector256<sbyte> value);
+        public static Vector256<byte> Add(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Add(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Add(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Add(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Add(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Add(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Add(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Add(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> AddSaturate(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> AddSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<sbyte> AddSaturate(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> AddSaturate(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<byte> AlignRight(Vector256<byte> left, Vector256<byte> right, byte mask);
+        public static Vector256<short> AlignRight(Vector256<short> left, Vector256<short> right, byte mask);
+        public static Vector256<int> AlignRight(Vector256<int> left, Vector256<int> right, byte mask);
+        public static Vector256<long> AlignRight(Vector256<long> left, Vector256<long> right, byte mask);
+        public static Vector256<sbyte> AlignRight(Vector256<sbyte> left, Vector256<sbyte> right, byte mask);
+        public static Vector256<ushort> AlignRight(Vector256<ushort> left, Vector256<ushort> right, byte mask);
+        public static Vector256<uint> AlignRight(Vector256<uint> left, Vector256<uint> right, byte mask);
+        public static Vector256<ulong> AlignRight(Vector256<ulong> left, Vector256<ulong> right, byte mask);
+        public static Vector256<byte> And(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> And(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> And(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> And(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> And(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> And(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> And(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> And(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> AndNot(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> AndNot(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> AndNot(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> AndNot(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> AndNot(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> AndNot(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> AndNot(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> AndNot(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> Average(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<ushort> Average(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector128<int> Blend(Vector128<int> left, Vector128<int> right, byte control);
+        public static Vector128<uint> Blend(Vector128<uint> left, Vector128<uint> right, byte control);
+        public static Vector256<short> Blend(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<int> Blend(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<ushort> Blend(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<uint> Blend(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<byte> BlendVariable(Vector256<byte> left, Vector256<byte> right, Vector256<byte> mask);
+        public static Vector256<short> BlendVariable(Vector256<short> left, Vector256<short> right, Vector256<short> mask);
+        public static Vector256<int> BlendVariable(Vector256<int> left, Vector256<int> right, Vector256<int> mask);
+        public static Vector256<long> BlendVariable(Vector256<long> left, Vector256<long> right, Vector256<long> mask);
+        public static Vector256<sbyte> BlendVariable(Vector256<sbyte> left, Vector256<sbyte> right, Vector256<sbyte> mask);
+        public static Vector256<ushort> BlendVariable(Vector256<ushort> left, Vector256<ushort> right, Vector256<ushort> mask);
+        public static Vector256<uint> BlendVariable(Vector256<uint> left, Vector256<uint> right, Vector256<uint> mask);
+        public static Vector256<ulong> BlendVariable(Vector256<ulong> left, Vector256<ulong> right, Vector256<ulong> mask);
+        public unsafe static Vector128<byte> BroadcastScalarToVector128(byte* source);
+        public unsafe static Vector128<short> BroadcastScalarToVector128(short* source);
+        public unsafe static Vector128<int> BroadcastScalarToVector128(int* source);
+        public unsafe static Vector128<long> BroadcastScalarToVector128(long* source);
+        public static Vector128<byte> BroadcastScalarToVector128(Vector128<byte> value);
+        public static Vector128<double> BroadcastScalarToVector128(Vector128<double> value);
+        public static Vector128<short> BroadcastScalarToVector128(Vector128<short> value);
+        public static Vector128<int> BroadcastScalarToVector128(Vector128<int> value);
+        public static Vector128<long> BroadcastScalarToVector128(Vector128<long> value);
+        public static Vector128<sbyte> BroadcastScalarToVector128(Vector128<sbyte> value);
+        public static Vector128<float> BroadcastScalarToVector128(Vector128<float> value);
+        public static Vector128<ushort> BroadcastScalarToVector128(Vector128<ushort> value);
+        public static Vector128<uint> BroadcastScalarToVector128(Vector128<uint> value);
+        public static Vector128<ulong> BroadcastScalarToVector128(Vector128<ulong> value);
+        public unsafe static Vector128<sbyte> BroadcastScalarToVector128(sbyte* source);
+        public unsafe static Vector128<ushort> BroadcastScalarToVector128(ushort* source);
+        public unsafe static Vector128<uint> BroadcastScalarToVector128(uint* source);
+        public unsafe static Vector128<ulong> BroadcastScalarToVector128(ulong* source);
+        public unsafe static Vector256<byte> BroadcastScalarToVector256(byte* source);
+        public unsafe static Vector256<short> BroadcastScalarToVector256(short* source);
+        public unsafe static Vector256<int> BroadcastScalarToVector256(int* source);
+        public unsafe static Vector256<long> BroadcastScalarToVector256(long* source);
+        public static Vector256<byte> BroadcastScalarToVector256(Vector128<byte> value);
+        public static Vector256<double> BroadcastScalarToVector256(Vector128<double> value);
+        public static Vector256<short> BroadcastScalarToVector256(Vector128<short> value);
+        public static Vector256<int> BroadcastScalarToVector256(Vector128<int> value);
+        public static Vector256<long> BroadcastScalarToVector256(Vector128<long> value);
+        public static Vector256<sbyte> BroadcastScalarToVector256(Vector128<sbyte> value);
+        public static Vector256<float> BroadcastScalarToVector256(Vector128<float> value);
+        public static Vector256<ushort> BroadcastScalarToVector256(Vector128<ushort> value);
+        public static Vector256<uint> BroadcastScalarToVector256(Vector128<uint> value);
+        public static Vector256<ulong> BroadcastScalarToVector256(Vector128<ulong> value);
+        public unsafe static Vector256<sbyte> BroadcastScalarToVector256(sbyte* source);
+        public unsafe static Vector256<ushort> BroadcastScalarToVector256(ushort* source);
+        public unsafe static Vector256<uint> BroadcastScalarToVector256(uint* source);
+        public unsafe static Vector256<ulong> BroadcastScalarToVector256(ulong* source);
+        public unsafe static Vector256<byte> BroadcastVector128ToVector256(byte* address);
+        public unsafe static Vector256<short> BroadcastVector128ToVector256(short* address);
+        public unsafe static Vector256<int> BroadcastVector128ToVector256(int* address);
+        public unsafe static Vector256<long> BroadcastVector128ToVector256(long* address);
+        public unsafe static Vector256<sbyte> BroadcastVector128ToVector256(sbyte* address);
+        public unsafe static Vector256<ushort> BroadcastVector128ToVector256(ushort* address);
+        public unsafe static Vector256<uint> BroadcastVector128ToVector256(uint* address);
+        public unsafe static Vector256<ulong> BroadcastVector128ToVector256(ulong* address);
+        public static Vector256<byte> CompareEqual(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> CompareEqual(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> CompareEqual(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> CompareEqual(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> CompareEqual(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> CompareEqual(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> CompareEqual(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> CompareEqual(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<short> CompareGreaterThan(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> CompareGreaterThan(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> CompareGreaterThan(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> CompareGreaterThan(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static int ConvertToInt32(Vector256<int> value);
+        public static uint ConvertToUInt32(Vector256<uint> value);
+        public unsafe static Vector256<short> ConvertToVector256Int16(byte* address);
+        public static Vector256<short> ConvertToVector256Int16(Vector128<byte> value);
+        public static Vector256<short> ConvertToVector256Int16(Vector128<sbyte> value);
+        public unsafe static Vector256<short> ConvertToVector256Int16(sbyte* address);
+        public unsafe static Vector256<int> ConvertToVector256Int32(byte* address);
+        public unsafe static Vector256<int> ConvertToVector256Int32(short* address);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<byte> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<short> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<sbyte> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<ushort> value);
+        public unsafe static Vector256<int> ConvertToVector256Int32(sbyte* address);
+        public unsafe static Vector256<int> ConvertToVector256Int32(ushort* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(byte* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(short* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(int* address);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<byte> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<short> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<int> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<sbyte> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<ushort> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<uint> value);
+        public unsafe static Vector256<long> ConvertToVector256Int64(sbyte* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(ushort* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(uint* address);
+        public static new Vector128<byte> ExtractVector128(Vector256<byte> value, byte index);
+        public static new Vector128<short> ExtractVector128(Vector256<short> value, byte index);
+        public static new Vector128<int> ExtractVector128(Vector256<int> value, byte index);
+        public static new Vector128<long> ExtractVector128(Vector256<long> value, byte index);
+        public static new Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, byte index);
+        public static new Vector128<ushort> ExtractVector128(Vector256<ushort> value, byte index);
+        public static new Vector128<uint> ExtractVector128(Vector256<uint> value, byte index);
+        public static new Vector128<ulong> ExtractVector128(Vector256<ulong> value, byte index);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<int> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<long> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<int> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector256<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<int> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<long> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<int> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector256<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<int> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector256<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<int> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<long> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector128<int> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector256<long> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<int> GatherMaskVector256(Vector256<int> source, int* baseAddress, Vector256<int> index, Vector256<int> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector128<int> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector256<long> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<float> GatherMaskVector256(Vector256<float> source, float* baseAddress, Vector256<int> index, Vector256<float> mask, byte scale);
+        public unsafe static Vector256<uint> GatherMaskVector256(Vector256<uint> source, uint* baseAddress, Vector256<int> index, Vector256<uint> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector128<int> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector256<long> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<int> GatherVector256(int* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<float> GatherVector256(float* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<uint> GatherVector256(uint* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector256<long> index, byte scale);
+        public static Vector256<short> HorizontalAdd(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> HorizontalAdd(Vector256<int> left, Vector256<int> right);
+        public static Vector256<short> HorizontalAddSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> HorizontalSubtract(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> HorizontalSubtract(Vector256<int> left, Vector256<int> right);
+        public static Vector256<short> HorizontalSubtractSaturate(Vector256<short> left, Vector256<short> right);
+        public static new Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, byte index);
+        public static new Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, byte index);
+        public static new Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, byte index);
+        public static new Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, byte index);
+        public static new Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, byte index);
+        public static new Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, byte index);
+        public static new Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, byte index);
+        public static new Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, byte index);
+        public unsafe static Vector256<byte> LoadAlignedVector256NonTemporal(byte* address);
+        public unsafe static Vector256<short> LoadAlignedVector256NonTemporal(short* address);
+        public unsafe static Vector256<int> LoadAlignedVector256NonTemporal(int* address);
+        public unsafe static Vector256<long> LoadAlignedVector256NonTemporal(long* address);
+        public unsafe static Vector256<sbyte> LoadAlignedVector256NonTemporal(sbyte* address);
+        public unsafe static Vector256<ushort> LoadAlignedVector256NonTemporal(ushort* address);
+        public unsafe static Vector256<uint> LoadAlignedVector256NonTemporal(uint* address);
+        public unsafe static Vector256<ulong> LoadAlignedVector256NonTemporal(ulong* address);
+        public unsafe static Vector128<int> MaskLoad(int* address, Vector128<int> mask);
+        public unsafe static Vector256<int> MaskLoad(int* address, Vector256<int> mask);
+        public unsafe static Vector128<long> MaskLoad(long* address, Vector128<long> mask);
+        public unsafe static Vector256<long> MaskLoad(long* address, Vector256<long> mask);
+        public unsafe static Vector128<uint> MaskLoad(uint* address, Vector128<uint> mask);
+        public unsafe static Vector256<uint> MaskLoad(uint* address, Vector256<uint> mask);
+        public unsafe static Vector128<ulong> MaskLoad(ulong* address, Vector128<ulong> mask);
+        public unsafe static Vector256<ulong> MaskLoad(ulong* address, Vector256<ulong> mask);
+        public unsafe static void MaskStore(int* address, Vector128<int> mask, Vector128<int> source);
+        public unsafe static void MaskStore(int* address, Vector256<int> mask, Vector256<int> source);
+        public unsafe static void MaskStore(long* address, Vector128<long> mask, Vector128<long> source);
+        public unsafe static void MaskStore(long* address, Vector256<long> mask, Vector256<long> source);
+        public unsafe static void MaskStore(uint* address, Vector128<uint> mask, Vector128<uint> source);
+        public unsafe static void MaskStore(uint* address, Vector256<uint> mask, Vector256<uint> source);
+        public unsafe static void MaskStore(ulong* address, Vector128<ulong> mask, Vector128<ulong> source);
+        public unsafe static void MaskStore(ulong* address, Vector256<ulong> mask, Vector256<ulong> source);
+        public static Vector256<byte> Max(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Max(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Max(Vector256<int> left, Vector256<int> right);
+        public static Vector256<sbyte> Max(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Max(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Max(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<byte> Min(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Min(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Min(Vector256<int> left, Vector256<int> right);
+        public static Vector256<sbyte> Min(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Min(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Min(Vector256<uint> left, Vector256<uint> right);
+        public static int MoveMask(Vector256<byte> value);
+        public static int MoveMask(Vector256<sbyte> value);
+        public static Vector256<ushort> MultipleSumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right, byte mask);
+        public static Vector256<long> Multiply(Vector256<int> left, Vector256<int> right);
+        public static Vector256<ulong> Multiply(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<short> MultiplyAddAdjacent(Vector256<byte> left, Vector256<sbyte> right);
+        public static Vector256<int> MultiplyAddAdjacent(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> MultiplyHigh(Vector256<short> left, Vector256<short> right);
+        public static Vector256<ushort> MultiplyHigh(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<short> MultiplyHighRoundScale(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> MultiplyLow(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> MultiplyLow(Vector256<int> left, Vector256<int> right);
+        public static Vector256<ushort> MultiplyLow(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> MultiplyLow(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<byte> Or(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Or(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Or(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Or(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Or(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Or(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Or(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Or(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<sbyte> PackSignedSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> PackSignedSaturate(Vector256<int> left, Vector256<int> right);
+        public static Vector256<byte> PackUnsignedSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<ushort> PackUnsignedSaturate(Vector256<int> left, Vector256<int> right);
+        public static new Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, byte control);
+        public static new Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, byte control);
+        public static new Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, byte control);
+        public static new Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, byte control);
+        public static new Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, byte control);
+        public static new Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static new Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static new Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, byte control);
+        public static Vector256<double> Permute4x64(Vector256<double> value, byte control);
+        public static Vector256<long> Permute4x64(Vector256<long> value, byte control);
+        public static Vector256<ulong> Permute4x64(Vector256<ulong> value, byte control);
+        public static Vector256<int> PermuteVar8x32(Vector256<int> left, Vector256<int> control);
+        public static Vector256<float> PermuteVar8x32(Vector256<float> left, Vector256<int> control);
+        public static Vector256<uint> PermuteVar8x32(Vector256<uint> left, Vector256<uint> control);
+        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, Vector128<short> count);
+        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, Vector128<int> count);
+        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, Vector128<long> count);
+        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, Vector128<ushort> count);
+        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, Vector128<uint> count);
+        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, Vector128<ulong> count);
+        public static Vector256<byte> ShiftLeftLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<short> ShiftLeftLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<int> ShiftLeftLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<long> ShiftLeftLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<sbyte> ShiftLeftLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<ushort> ShiftLeftLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<uint> ShiftLeftLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<ulong> ShiftLeftLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector128<int> ShiftLeftLogicalVariable(Vector128<int> value, Vector128<uint> count);
+        public static Vector128<long> ShiftLeftLogicalVariable(Vector128<long> value, Vector128<ulong> count);
+        public static Vector128<uint> ShiftLeftLogicalVariable(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftLeftLogicalVariable(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector256<int> ShiftLeftLogicalVariable(Vector256<int> value, Vector256<uint> count);
+        public static Vector256<long> ShiftLeftLogicalVariable(Vector256<long> value, Vector256<ulong> count);
+        public static Vector256<uint> ShiftLeftLogicalVariable(Vector256<uint> value, Vector256<uint> count);
+        public static Vector256<ulong> ShiftLeftLogicalVariable(Vector256<ulong> value, Vector256<ulong> count);
+        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, Vector128<short> count);
+        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, Vector128<int> count);
+        public static Vector128<int> ShiftRightArithmeticVariable(Vector128<int> value, Vector128<uint> count);
+        public static Vector256<int> ShiftRightArithmeticVariable(Vector256<int> value, Vector256<uint> count);
+        public static Vector256<short> ShiftRightLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightLogical(Vector256<short> value, Vector128<short> count);
+        public static Vector256<int> ShiftRightLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightLogical(Vector256<int> value, Vector128<int> count);
+        public static Vector256<long> ShiftRightLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftRightLogical(Vector256<long> value, Vector128<long> count);
+        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, Vector128<ushort> count);
+        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, Vector128<uint> count);
+        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, Vector128<ulong> count);
+        public static Vector256<byte> ShiftRightLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<short> ShiftRightLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<int> ShiftRightLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<long> ShiftRightLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<sbyte> ShiftRightLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<ushort> ShiftRightLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<uint> ShiftRightLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<ulong> ShiftRightLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector128<int> ShiftRightLogicalVariable(Vector128<int> value, Vector128<uint> count);
+        public static Vector128<long> ShiftRightLogicalVariable(Vector128<long> value, Vector128<ulong> count);
+        public static Vector128<uint> ShiftRightLogicalVariable(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftRightLogicalVariable(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector256<int> ShiftRightLogicalVariable(Vector256<int> value, Vector256<uint> count);
+        public static Vector256<long> ShiftRightLogicalVariable(Vector256<long> value, Vector256<ulong> count);
+        public static Vector256<uint> ShiftRightLogicalVariable(Vector256<uint> value, Vector256<uint> count);
+        public static Vector256<ulong> ShiftRightLogicalVariable(Vector256<ulong> value, Vector256<ulong> count);
+        public static Vector256<byte> Shuffle(Vector256<byte> value, Vector256<byte> mask);
+        public static Vector256<int> Shuffle(Vector256<int> value, byte control);
+        public static Vector256<sbyte> Shuffle(Vector256<sbyte> value, Vector256<sbyte> mask);
+        public static Vector256<uint> Shuffle(Vector256<uint> value, byte control);
+        public static Vector256<short> ShuffleHigh(Vector256<short> value, byte control);
+        public static Vector256<ushort> ShuffleHigh(Vector256<ushort> value, byte control);
+        public static Vector256<short> ShuffleLow(Vector256<short> value, byte control);
+        public static Vector256<ushort> ShuffleLow(Vector256<ushort> value, byte control);
+        public static Vector256<short> Sign(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Sign(Vector256<int> left, Vector256<int> right);
+        public static Vector256<sbyte> Sign(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<byte> Subtract(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Subtract(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Subtract(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Subtract(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Subtract(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Subtract(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Subtract(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Subtract(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> SubtractSaturate(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> SubtractSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<sbyte> SubtractSaturate(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> SubtractSaturate(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<ushort> SumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<byte> UnpackHigh(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> UnpackHigh(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> UnpackHigh(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> UnpackHigh(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> UnpackHigh(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> UnpackHigh(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> UnpackHigh(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> UnpackHigh(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> UnpackLow(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> UnpackLow(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> UnpackLow(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> UnpackLow(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> UnpackLow(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> UnpackLow(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> UnpackLow(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> UnpackLow(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> Xor(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Xor(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Xor(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Xor(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Xor(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Xor(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Xor(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Xor(Vector256<ulong> left, Vector256<ulong> right);
+    }
+    public abstract class Bmi1 {
+        public static bool IsSupported { get; }
+        public static uint AndNot(uint left, uint right);
+        public static uint BitFieldExtract(uint value, byte start, byte length);
+        public static uint BitFieldExtract(uint value, ushort control);
+        public static uint ExtractLowestSetBit(uint value);
+        public static uint GetMaskUpToLowestSetBit(uint value);
+        public static uint ResetLowestSetBit(uint value);
+        public static uint TrailingZeroCount(uint value);
+        public abstract class X64 {
+            public static bool IsSupported { get; }
+            public static ulong AndNot(ulong left, ulong right);
+            public static ulong BitFieldExtract(ulong value, byte start, byte length);
+            public static ulong BitFieldExtract(ulong value, ushort control);
+            public static ulong ExtractLowestSetBit(ulong value);
+            public static ulong GetMaskUpToLowestSetBit(ulong value);
+            public static ulong ResetLowestSetBit(ulong value);
+            public static ulong TrailingZeroCount(ulong value);
+        }
+    }
+    public abstract class Bmi2 {
+        public static bool IsSupported { get; }
+        public static uint MultiplyNoFlags(uint left, uint right);
+        public unsafe static uint MultiplyNoFlags(uint left, uint right, uint* low);
+        public static uint ParallelBitDeposit(uint value, uint mask);
+        public static uint ParallelBitExtract(uint value, uint mask);
+        public static uint ZeroHighBits(uint value, uint index);
+        public abstract class X64 {
+            public static bool IsSupported { get; }
+            public static ulong MultiplyNoFlags(ulong left, ulong right);
+            public unsafe static ulong MultiplyNoFlags(ulong left, ulong right, ulong* low);
+            public static ulong ParallelBitDeposit(ulong value, ulong mask);
+            public static ulong ParallelBitExtract(ulong value, ulong mask);
+            public static ulong ZeroHighBits(ulong value, ulong index);
+        }
+    }
+    public enum FloatComparisonMode : byte {
+        OrderedEqualNonSignaling = (byte)0,
+        OrderedEqualSignaling = (byte)16,
+        OrderedFalseNonSignaling = (byte)11,
+        OrderedFalseSignaling = (byte)27,
+        OrderedGreaterThanNonSignaling = (byte)30,
+        OrderedGreaterThanOrEqualNonSignaling = (byte)29,
+        OrderedGreaterThanOrEqualSignaling = (byte)13,
+        OrderedGreaterThanSignaling = (byte)14,
+        OrderedLessThanNonSignaling = (byte)17,
+        OrderedLessThanOrEqualNonSignaling = (byte)18,
+        OrderedLessThanOrEqualSignaling = (byte)2,
+        OrderedLessThanSignaling = (byte)1,
+        OrderedNonSignaling = (byte)7,
+        OrderedNotEqualNonSignaling = (byte)12,
+        OrderedNotEqualSignaling = (byte)28,
+        OrderedSignaling = (byte)23,
+        UnorderedEqualNonSignaling = (byte)8,
+        UnorderedEqualSignaling = (byte)24,
+        UnorderedNonSignaling = (byte)3,
+        UnorderedNotEqualNonSignaling = (byte)4,
+        UnorderedNotEqualSignaling = (byte)20,
+        UnorderedNotGreaterThanNonSignaling = (byte)26,
+        UnorderedNotGreaterThanOrEqualNonSignaling = (byte)25,
+        UnorderedNotGreaterThanOrEqualSignaling = (byte)9,
+        UnorderedNotGreaterThanSignaling = (byte)10,
+        UnorderedNotLessThanNonSignaling = (byte)21,
+        UnorderedNotLessThanOrEqualNonSignaling = (byte)22,
+        UnorderedNotLessThanOrEqualSignaling = (byte)6,
+        UnorderedNotLessThanSignaling = (byte)5,
+        UnorderedSignaling = (byte)19,
+        UnorderedTrueNonSignaling = (byte)15,
+        UnorderedTrueSignaling = (byte)31,
+    }
+    public abstract class Fma : Avx {
+        public static new bool IsSupported { get; }
+        public static Vector128<double> MultiplyAdd(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAdd(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplyAdd(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplyAdd(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplyAddNegated(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddNegated(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplyAddNegated(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplyAddNegated(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplyAddNegatedScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddNegatedScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector128<double> MultiplyAddScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector128<double> MultiplyAddSubtract(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddSubtract(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplyAddSubtract(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplyAddSubtract(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtract(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtract(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplySubtract(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplySubtract(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtractAdd(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractAdd(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplySubtractAdd(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplySubtractAdd(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtractNegated(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractNegated(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplySubtractNegated(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplySubtractNegated(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtractNegatedScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractNegatedScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector128<double> MultiplySubtractScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+    }
+    public abstract class Lzcnt {
+        public static bool IsSupported { get; }
+        public static uint LeadingZeroCount(uint value);
+        public abstract class X64 {
+            public static bool IsSupported { get; }
+            public static ulong LeadingZeroCount(ulong value);
+        }
+    }
+    public abstract class Pclmulqdq : Sse2 {
+        public static new bool IsSupported { get; }
+        public static Vector128<long> CarrylessMultiply(Vector128<long> left, Vector128<long> right, byte control);
+        public static Vector128<ulong> CarrylessMultiply(Vector128<ulong> left, Vector128<ulong> right, byte control);
+    }
+    public abstract class Popcnt : Sse42 {
+        public static new bool IsSupported { get; }
+        public static uint PopCount(uint value);
+        public new abstract class X64 : Sse41.X64 {
+            public static new bool IsSupported { get; }
+            public static ulong PopCount(ulong value);
+        }
+    }
+    public abstract class Sse {
+        public static bool IsSupported { get; }
+        public static Vector128<float> Add(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> AddScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> And(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> AndNot(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareLessThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotLessThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareOrdered(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarLessThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotLessThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarOrdered(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedLessThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedNotEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarUnordered(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedLessThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedNotEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareUnordered(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, int value);
+        public static int ConvertToInt32(Vector128<float> value);
+        public static int ConvertToInt32WithTruncation(Vector128<float> value);
+        public static Vector128<float> Divide(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> DivideScalar(Vector128<float> left, Vector128<float> right);
+        public unsafe static Vector128<float> LoadAlignedVector128(float* address);
+        public unsafe static Vector128<float> LoadHigh(Vector128<float> lower, float* address);
+        public unsafe static Vector128<float> LoadLow(Vector128<float> upper, float* address);
+        public unsafe static Vector128<float> LoadScalarVector128(float* address);
+        public unsafe static Vector128<float> LoadVector128(float* address);
+        public static Vector128<float> Max(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MaxScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> Min(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MinScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MoveHighToLow(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MoveLowToHigh(Vector128<float> left, Vector128<float> right);
+        public static int MoveMask(Vector128<float> value);
+        public static Vector128<float> MoveScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<float> Multiply(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MultiplyScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> Or(Vector128<float> left, Vector128<float> right);
+        public unsafe static void Prefetch0(void* address);
+        public unsafe static void Prefetch1(void* address);
+        public unsafe static void Prefetch2(void* address);
+        public unsafe static void PrefetchNonTemporal(void* address);
+        public static Vector128<float> Reciprocal(Vector128<float> value);
+        public static Vector128<float> ReciprocalScalar(Vector128<float> value);
+        public static Vector128<float> ReciprocalScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<float> ReciprocalSqrt(Vector128<float> value);
+        public static Vector128<float> ReciprocalSqrtScalar(Vector128<float> value);
+        public static Vector128<float> ReciprocalSqrtScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<float> Shuffle(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> Sqrt(Vector128<float> value);
+        public static Vector128<float> SqrtScalar(Vector128<float> value);
+        public static Vector128<float> SqrtScalar(Vector128<float> upper, Vector128<float> value);
+        public unsafe static void Store(float* address, Vector128<float> source);
+        public unsafe static void StoreAligned(float* address, Vector128<float> source);
+        public unsafe static void StoreAlignedNonTemporal(float* address, Vector128<float> source);
+        public static void StoreFence();
+        public unsafe static void StoreHigh(float* address, Vector128<float> source);
+        public unsafe static void StoreLow(float* address, Vector128<float> source);
+        public unsafe static void StoreScalar(float* address, Vector128<float> source);
+        public static Vector128<float> Subtract(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> SubtractScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> UnpackHigh(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> UnpackLow(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> Xor(Vector128<float> left, Vector128<float> right);
+        public abstract class X64 {
+            public static bool IsSupported { get; }
+            public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, long value);
+            public static long ConvertToInt64(Vector128<float> value);
+            public static long ConvertToInt64WithTruncation(Vector128<float> value);
+        }
+    }
+    public abstract class Sse2 : Sse {
+        public static new bool IsSupported { get; }
+        public static Vector128<byte> Add(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Add(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Add(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Add(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Add(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Add(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Add(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Add(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Add(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> AddSaturate(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> AddSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<sbyte> AddSaturate(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> AddSaturate(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<double> AddScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<byte> And(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> And(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> And(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> And(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> And(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> And(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> And(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> And(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> And(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> AndNot(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> AndNot(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> AndNot(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> AndNot(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> AndNot(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> AndNot(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> AndNot(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> AndNot(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> AndNot(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> Average(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<ushort> Average(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<byte> CompareEqual(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> CompareEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareEqual(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareEqual(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> CompareEqual(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> CompareEqual(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> CompareEqual(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<double> CompareGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareGreaterThan(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareGreaterThan(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> CompareGreaterThan(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<double> CompareGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareLessThan(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareLessThan(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> CompareLessThan(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<double> CompareLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareOrdered(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarOrdered(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedLessThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedNotEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarUnordered(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedLessThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedNotEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareUnordered(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, int value);
+        public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, Vector128<float> value);
+        public static Vector128<int> ConvertScalarToVector128Int32(int value);
+        public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, Vector128<double> value);
+        public static Vector128<uint> ConvertScalarToVector128UInt32(uint value);
+        public static int ConvertToInt32(Vector128<double> value);
+        public static int ConvertToInt32(Vector128<int> value);
+        public static int ConvertToInt32WithTruncation(Vector128<double> value);
+        public static uint ConvertToUInt32(Vector128<uint> value);
+        public static Vector128<double> ConvertToVector128Double(Vector128<int> value);
+        public static Vector128<double> ConvertToVector128Double(Vector128<float> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<double> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<float> value);
+        public static Vector128<int> ConvertToVector128Int32WithTruncation(Vector128<double> value);
+        public static Vector128<int> ConvertToVector128Int32WithTruncation(Vector128<float> value);
+        public static Vector128<float> ConvertToVector128Single(Vector128<double> value);
+        public static Vector128<float> ConvertToVector128Single(Vector128<int> value);
+        public static Vector128<double> Divide(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> DivideScalar(Vector128<double> left, Vector128<double> right);
+        public static ushort Extract(Vector128<ushort> value, byte index);
+        public static Vector128<short> Insert(Vector128<short> value, short data, byte index);
+        public static Vector128<ushort> Insert(Vector128<ushort> value, ushort data, byte index);
+        public unsafe static Vector128<byte> LoadAlignedVector128(byte* address);
+        public unsafe static Vector128<double> LoadAlignedVector128(double* address);
+        public unsafe static Vector128<short> LoadAlignedVector128(short* address);
+        public unsafe static Vector128<int> LoadAlignedVector128(int* address);
+        public unsafe static Vector128<long> LoadAlignedVector128(long* address);
+        public unsafe static Vector128<sbyte> LoadAlignedVector128(sbyte* address);
+        public unsafe static Vector128<ushort> LoadAlignedVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadAlignedVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadAlignedVector128(ulong* address);
+        public static void LoadFence();
+        public unsafe static Vector128<double> LoadHigh(Vector128<double> lower, double* address);
+        public unsafe static Vector128<double> LoadLow(Vector128<double> upper, double* address);
+        public unsafe static Vector128<double> LoadScalarVector128(double* address);
+        public unsafe static Vector128<int> LoadScalarVector128(int* address);
+        public unsafe static Vector128<long> LoadScalarVector128(long* address);
+        public unsafe static Vector128<uint> LoadScalarVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadScalarVector128(ulong* address);
+        public unsafe static Vector128<byte> LoadVector128(byte* address);
+        public unsafe static Vector128<double> LoadVector128(double* address);
+        public unsafe static Vector128<short> LoadVector128(short* address);
+        public unsafe static Vector128<int> LoadVector128(int* address);
+        public unsafe static Vector128<long> LoadVector128(long* address);
+        public unsafe static Vector128<sbyte> LoadVector128(sbyte* address);
+        public unsafe static Vector128<ushort> LoadVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadVector128(ulong* address);
+        public unsafe static void MaskMove(Vector128<byte> source, Vector128<byte> mask, byte* address);
+        public unsafe static void MaskMove(Vector128<sbyte> source, Vector128<sbyte> mask, sbyte* address);
+        public static Vector128<byte> Max(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Max(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Max(Vector128<short> left, Vector128<short> right);
+        public static Vector128<double> MaxScalar(Vector128<double> left, Vector128<double> right);
+        public static void MemoryFence();
+        public static Vector128<byte> Min(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Min(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Min(Vector128<short> left, Vector128<short> right);
+        public static Vector128<double> MinScalar(Vector128<double> left, Vector128<double> right);
+        public static int MoveMask(Vector128<byte> value);
+        public static int MoveMask(Vector128<double> value);
+        public static int MoveMask(Vector128<sbyte> value);
+        public static Vector128<double> MoveScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<long> MoveScalar(Vector128<long> value);
+        public static Vector128<ulong> MoveScalar(Vector128<ulong> value);
+        public static Vector128<double> Multiply(Vector128<double> left, Vector128<double> right);
+        public static Vector128<ulong> Multiply(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<int> MultiplyAddAdjacent(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> MultiplyHigh(Vector128<short> left, Vector128<short> right);
+        public static Vector128<ushort> MultiplyHigh(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<short> MultiplyLow(Vector128<short> left, Vector128<short> right);
+        public static Vector128<ushort> MultiplyLow(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<double> MultiplyScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<byte> Or(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Or(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Or(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Or(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Or(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Or(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Or(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Or(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Or(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<sbyte> PackSignedSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> PackSignedSaturate(Vector128<int> left, Vector128<int> right);
+        public static Vector128<byte> PackUnsignedSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, Vector128<short> count);
+        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, Vector128<int> count);
+        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, Vector128<long> count);
+        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, Vector128<ushort> count);
+        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector128<byte> ShiftLeftLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<short> ShiftLeftLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<int> ShiftLeftLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<long> ShiftLeftLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<sbyte> ShiftLeftLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<ushort> ShiftLeftLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<uint> ShiftLeftLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<ulong> ShiftLeftLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, Vector128<short> count);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, Vector128<int> count);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> value, Vector128<short> count);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> value, Vector128<int> count);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> value, Vector128<long> count);
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, Vector128<ushort> count);
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector128<byte> ShiftRightLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<short> ShiftRightLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<int> ShiftRightLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<long> ShiftRightLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<sbyte> ShiftRightLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<ushort> ShiftRightLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<uint> ShiftRightLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<ulong> ShiftRightLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<double> Shuffle(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<int> Shuffle(Vector128<int> value, byte control);
+        public static Vector128<uint> Shuffle(Vector128<uint> value, byte control);
+        public static Vector128<short> ShuffleHigh(Vector128<short> value, byte control);
+        public static Vector128<ushort> ShuffleHigh(Vector128<ushort> value, byte control);
+        public static Vector128<short> ShuffleLow(Vector128<short> value, byte control);
+        public static Vector128<ushort> ShuffleLow(Vector128<ushort> value, byte control);
+        public static Vector128<double> Sqrt(Vector128<double> value);
+        public static Vector128<double> SqrtScalar(Vector128<double> value);
+        public static Vector128<double> SqrtScalar(Vector128<double> upper, Vector128<double> value);
+        public unsafe static void Store(byte* address, Vector128<byte> source);
+        public unsafe static void Store(double* address, Vector128<double> source);
+        public unsafe static void Store(short* address, Vector128<short> source);
+        public unsafe static void Store(int* address, Vector128<int> source);
+        public unsafe static void Store(long* address, Vector128<long> source);
+        public unsafe static void Store(sbyte* address, Vector128<sbyte> source);
+        public unsafe static void Store(ushort* address, Vector128<ushort> source);
+        public unsafe static void Store(uint* address, Vector128<uint> source);
+        public unsafe static void Store(ulong* address, Vector128<ulong> source);
+        public unsafe static void StoreAligned(byte* address, Vector128<byte> source);
+        public unsafe static void StoreAligned(double* address, Vector128<double> source);
+        public unsafe static void StoreAligned(short* address, Vector128<short> source);
+        public unsafe static void StoreAligned(int* address, Vector128<int> source);
+        public unsafe static void StoreAligned(long* address, Vector128<long> source);
+        public unsafe static void StoreAligned(sbyte* address, Vector128<sbyte> source);
+        public unsafe static void StoreAligned(ushort* address, Vector128<ushort> source);
+        public unsafe static void StoreAligned(uint* address, Vector128<uint> source);
+        public unsafe static void StoreAligned(ulong* address, Vector128<ulong> source);
+        public unsafe static void StoreAlignedNonTemporal(byte* address, Vector128<byte> source);
+        public unsafe static void StoreAlignedNonTemporal(double* address, Vector128<double> source);
+        public unsafe static void StoreAlignedNonTemporal(short* address, Vector128<short> source);
+        public unsafe static void StoreAlignedNonTemporal(int* address, Vector128<int> source);
+        public unsafe static void StoreAlignedNonTemporal(long* address, Vector128<long> source);
+        public unsafe static void StoreAlignedNonTemporal(sbyte* address, Vector128<sbyte> source);
+        public unsafe static void StoreAlignedNonTemporal(ushort* address, Vector128<ushort> source);
+        public unsafe static void StoreAlignedNonTemporal(uint* address, Vector128<uint> source);
+        public unsafe static void StoreAlignedNonTemporal(ulong* address, Vector128<ulong> source);
+        public unsafe static void StoreHigh(double* address, Vector128<double> source);
+        public unsafe static void StoreLow(double* address, Vector128<double> source);
+        public unsafe static void StoreNonTemporal(int* address, int value);
+        public unsafe static void StoreNonTemporal(uint* address, uint value);
+        public unsafe static void StoreScalar(double* address, Vector128<double> source);
+        public unsafe static void StoreScalar(long* address, Vector128<long> source);
+        public unsafe static void StoreScalar(ulong* address, Vector128<ulong> source);
+        public static Vector128<byte> Subtract(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Subtract(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Subtract(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Subtract(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Subtract(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Subtract(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Subtract(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Subtract(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Subtract(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> SubtractSaturate(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> SubtractSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<sbyte> SubtractSaturate(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> SubtractSaturate(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<double> SubtractScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<ushort> SumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<byte> UnpackHigh(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> UnpackHigh(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> UnpackHigh(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> UnpackHigh(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> UnpackHigh(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> UnpackHigh(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> UnpackHigh(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> UnpackHigh(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> UnpackHigh(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> UnpackLow(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> UnpackLow(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> UnpackLow(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> UnpackLow(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> UnpackLow(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> UnpackLow(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> UnpackLow(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> UnpackLow(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> UnpackLow(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> Xor(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Xor(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Xor(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Xor(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Xor(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Xor(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Xor(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Xor(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Xor(Vector128<ulong> left, Vector128<ulong> right);
+        public new abstract class X64 : Sse.X64 {
+            public static new bool IsSupported { get; }
+            public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, long value);
+            public static Vector128<long> ConvertScalarToVector128Int64(long value);
+            public static Vector128<ulong> ConvertScalarToVector128UInt64(ulong value);
+            public static long ConvertToInt64(Vector128<double> value);
+            public static long ConvertToInt64(Vector128<long> value);
+            public static long ConvertToInt64WithTruncation(Vector128<double> value);
+            public static ulong ConvertToUInt64(Vector128<ulong> value);
+            public unsafe static void StoreNonTemporal(long* address, long value);
+            public unsafe static void StoreNonTemporal(ulong* address, ulong value);
+        }
+    }
+    public abstract class Sse3 : Sse2 {
+        public static new bool IsSupported { get; }
+        public static Vector128<double> AddSubtract(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> AddSubtract(Vector128<float> left, Vector128<float> right);
+        public static Vector128<double> HorizontalAdd(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> HorizontalAdd(Vector128<float> left, Vector128<float> right);
+        public static Vector128<double> HorizontalSubtract(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> HorizontalSubtract(Vector128<float> left, Vector128<float> right);
+        public unsafe static Vector128<double> LoadAndDuplicateToVector128(double* address);
+        public unsafe static Vector128<byte> LoadDquVector128(byte* address);
+        public unsafe static Vector128<short> LoadDquVector128(short* address);
+        public unsafe static Vector128<int> LoadDquVector128(int* address);
+        public unsafe static Vector128<long> LoadDquVector128(long* address);
+        public unsafe static Vector128<sbyte> LoadDquVector128(sbyte* address);
+        public unsafe static Vector128<ushort> LoadDquVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadDquVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadDquVector128(ulong* address);
+        public static Vector128<double> MoveAndDuplicate(Vector128<double> source);
+        public static Vector128<float> MoveHighAndDuplicate(Vector128<float> source);
+        public static Vector128<float> MoveLowAndDuplicate(Vector128<float> source);
+    }
+    public abstract class Sse41 : Ssse3 {
+        public static new bool IsSupported { get; }
+        public static Vector128<double> Blend(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<short> Blend(Vector128<short> left, Vector128<short> right, byte control);
+        public static Vector128<float> Blend(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<ushort> Blend(Vector128<ushort> left, Vector128<ushort> right, byte control);
+        public static Vector128<byte> BlendVariable(Vector128<byte> left, Vector128<byte> right, Vector128<byte> mask);
+        public static Vector128<double> BlendVariable(Vector128<double> left, Vector128<double> right, Vector128<double> mask);
+        public static Vector128<short> BlendVariable(Vector128<short> left, Vector128<short> right, Vector128<short> mask);
+        public static Vector128<int> BlendVariable(Vector128<int> left, Vector128<int> right, Vector128<int> mask);
+        public static Vector128<long> BlendVariable(Vector128<long> left, Vector128<long> right, Vector128<long> mask);
+        public static Vector128<sbyte> BlendVariable(Vector128<sbyte> left, Vector128<sbyte> right, Vector128<sbyte> mask);
+        public static Vector128<float> BlendVariable(Vector128<float> left, Vector128<float> right, Vector128<float> mask);
+        public static Vector128<ushort> BlendVariable(Vector128<ushort> left, Vector128<ushort> right, Vector128<ushort> mask);
+        public static Vector128<uint> BlendVariable(Vector128<uint> left, Vector128<uint> right, Vector128<uint> mask);
+        public static Vector128<ulong> BlendVariable(Vector128<ulong> left, Vector128<ulong> right, Vector128<ulong> mask);
+        public static Vector128<double> Ceiling(Vector128<double> value);
+        public static Vector128<float> Ceiling(Vector128<float> value);
+        public static Vector128<double> CeilingScalar(Vector128<double> value);
+        public static Vector128<double> CeilingScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> CeilingScalar(Vector128<float> value);
+        public static Vector128<float> CeilingScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<long> CompareEqual(Vector128<long> left, Vector128<long> right);
+        public static Vector128<ulong> CompareEqual(Vector128<ulong> left, Vector128<ulong> right);
+        public unsafe static Vector128<short> ConvertToVector128Int16(byte* address);
+        public static Vector128<short> ConvertToVector128Int16(Vector128<byte> value);
+        public static Vector128<short> ConvertToVector128Int16(Vector128<sbyte> value);
+        public unsafe static Vector128<short> ConvertToVector128Int16(sbyte* address);
+        public unsafe static Vector128<int> ConvertToVector128Int32(byte* address);
+        public unsafe static Vector128<int> ConvertToVector128Int32(short* address);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<byte> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<short> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<sbyte> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<ushort> value);
+        public unsafe static Vector128<int> ConvertToVector128Int32(sbyte* address);
+        public unsafe static Vector128<int> ConvertToVector128Int32(ushort* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(byte* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(short* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(int* address);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<byte> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<short> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<int> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<sbyte> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<ushort> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<uint> value);
+        public unsafe static Vector128<long> ConvertToVector128Int64(sbyte* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(ushort* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(uint* address);
+        public static Vector128<double> DotProduct(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<float> DotProduct(Vector128<float> left, Vector128<float> right, byte control);
+        public static byte Extract(Vector128<byte> value, byte index);
+        public static int Extract(Vector128<int> value, byte index);
+        public static float Extract(Vector128<float> value, byte index);
+        public static uint Extract(Vector128<uint> value, byte index);
+        public static Vector128<double> Floor(Vector128<double> value);
+        public static Vector128<float> Floor(Vector128<float> value);
+        public static Vector128<double> FloorScalar(Vector128<double> value);
+        public static Vector128<double> FloorScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> FloorScalar(Vector128<float> value);
+        public static Vector128<float> FloorScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<byte> Insert(Vector128<byte> value, byte data, byte index);
+        public static Vector128<int> Insert(Vector128<int> value, int data, byte index);
+        public static Vector128<sbyte> Insert(Vector128<sbyte> value, sbyte data, byte index);
+        public static Vector128<float> Insert(Vector128<float> value, Vector128<float> data, byte index);
+        public static Vector128<uint> Insert(Vector128<uint> value, uint data, byte index);
+        public unsafe static Vector128<byte> LoadAlignedVector128NonTemporal(byte* address);
+        public unsafe static Vector128<short> LoadAlignedVector128NonTemporal(short* address);
+        public unsafe static Vector128<int> LoadAlignedVector128NonTemporal(int* address);
+        public unsafe static Vector128<long> LoadAlignedVector128NonTemporal(long* address);
+        public unsafe static Vector128<sbyte> LoadAlignedVector128NonTemporal(sbyte* address);
+        public unsafe static Vector128<ushort> LoadAlignedVector128NonTemporal(ushort* address);
+        public unsafe static Vector128<uint> LoadAlignedVector128NonTemporal(uint* address);
+        public unsafe static Vector128<ulong> LoadAlignedVector128NonTemporal(ulong* address);
+        public static Vector128<int> Max(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Max(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Max(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Max(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<int> Min(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Min(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Min(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Min(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ushort> MinHorizontal(Vector128<ushort> value);
+        public static Vector128<ushort> MultipleSumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right, byte mask);
+        public static Vector128<long> Multiply(Vector128<int> left, Vector128<int> right);
+        public static Vector128<int> MultiplyLow(Vector128<int> left, Vector128<int> right);
+        public static Vector128<uint> MultiplyLow(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ushort> PackUnsignedSaturate(Vector128<int> left, Vector128<int> right);
+        public static Vector128<double> RoundCurrentDirection(Vector128<double> value);
+        public static Vector128<float> RoundCurrentDirection(Vector128<float> value);
+        public static Vector128<double> RoundCurrentDirectionScalar(Vector128<double> value);
+        public static Vector128<double> RoundCurrentDirectionScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> RoundCurrentDirectionScalar(Vector128<float> value);
+        public static Vector128<float> RoundCurrentDirectionScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<double> RoundToNearestInteger(Vector128<double> value);
+        public static Vector128<float> RoundToNearestInteger(Vector128<float> value);
+        public static Vector128<double> RoundToNearestIntegerScalar(Vector128<double> value);
+        public static Vector128<double> RoundToNearestIntegerScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> RoundToNearestIntegerScalar(Vector128<float> value);
+        public static Vector128<float> RoundToNearestIntegerScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<double> RoundToNegativeInfinity(Vector128<double> value);
+        public static Vector128<float> RoundToNegativeInfinity(Vector128<float> value);
+        public static Vector128<double> RoundToNegativeInfinityScalar(Vector128<double> value);
+        public static Vector128<double> RoundToNegativeInfinityScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> RoundToNegativeInfinityScalar(Vector128<float> value);
+        public static Vector128<float> RoundToNegativeInfinityScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<double> RoundToPositiveInfinity(Vector128<double> value);
+        public static Vector128<float> RoundToPositiveInfinity(Vector128<float> value);
+        public static Vector128<double> RoundToPositiveInfinityScalar(Vector128<double> value);
+        public static Vector128<double> RoundToPositiveInfinityScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> RoundToPositiveInfinityScalar(Vector128<float> value);
+        public static Vector128<float> RoundToPositiveInfinityScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<double> RoundToZero(Vector128<double> value);
+        public static Vector128<float> RoundToZero(Vector128<float> value);
+        public static Vector128<double> RoundToZeroScalar(Vector128<double> value);
+        public static Vector128<double> RoundToZeroScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> RoundToZeroScalar(Vector128<float> value);
+        public static Vector128<float> RoundToZeroScalar(Vector128<float> upper, Vector128<float> value);
+        public static bool TestC(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestC(Vector128<short> left, Vector128<short> right);
+        public static bool TestC(Vector128<int> left, Vector128<int> right);
+        public static bool TestC(Vector128<long> left, Vector128<long> right);
+        public static bool TestC(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestC(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestC(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestC(Vector128<ulong> left, Vector128<ulong> right);
+        public static bool TestNotZAndNotC(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestNotZAndNotC(Vector128<short> left, Vector128<short> right);
+        public static bool TestNotZAndNotC(Vector128<int> left, Vector128<int> right);
+        public static bool TestNotZAndNotC(Vector128<long> left, Vector128<long> right);
+        public static bool TestNotZAndNotC(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestNotZAndNotC(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestNotZAndNotC(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestNotZAndNotC(Vector128<ulong> left, Vector128<ulong> right);
+        public static bool TestZ(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestZ(Vector128<short> left, Vector128<short> right);
+        public static bool TestZ(Vector128<int> left, Vector128<int> right);
+        public static bool TestZ(Vector128<long> left, Vector128<long> right);
+        public static bool TestZ(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestZ(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestZ(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestZ(Vector128<ulong> left, Vector128<ulong> right);
+        public new abstract class X64 : Sse2.X64 {
+            public static new bool IsSupported { get; }
+            public static long Extract(Vector128<long> value, byte index);
+            public static ulong Extract(Vector128<ulong> value, byte index);
+            public static Vector128<long> Insert(Vector128<long> value, long data, byte index);
+            public static Vector128<ulong> Insert(Vector128<ulong> value, ulong data, byte index);
+        }
+    }
+    public abstract class Sse42 : Sse41 {
+        public static new bool IsSupported { get; }
+        public static Vector128<long> CompareGreaterThan(Vector128<long> left, Vector128<long> right);
+        public static uint Crc32(uint crc, byte data);
+        public static uint Crc32(uint crc, ushort data);
+        public static uint Crc32(uint crc, uint data);
+        public new abstract class X64 : Sse41.X64 {
+            public static new bool IsSupported { get; }
+            public static ulong Crc32(ulong crc, ulong data);
+        }
+    }
+    public abstract class Ssse3 : Sse3 {
+        public static new bool IsSupported { get; }
+        public static Vector128<ushort> Abs(Vector128<short> value);
+        public static Vector128<uint> Abs(Vector128<int> value);
+        public static Vector128<byte> Abs(Vector128<sbyte> value);
+        public static Vector128<byte> AlignRight(Vector128<byte> left, Vector128<byte> right, byte mask);
+        public static Vector128<short> AlignRight(Vector128<short> left, Vector128<short> right, byte mask);
+        public static Vector128<int> AlignRight(Vector128<int> left, Vector128<int> right, byte mask);
+        public static Vector128<long> AlignRight(Vector128<long> left, Vector128<long> right, byte mask);
+        public static Vector128<sbyte> AlignRight(Vector128<sbyte> left, Vector128<sbyte> right, byte mask);
+        public static Vector128<ushort> AlignRight(Vector128<ushort> left, Vector128<ushort> right, byte mask);
+        public static Vector128<uint> AlignRight(Vector128<uint> left, Vector128<uint> right, byte mask);
+        public static Vector128<ulong> AlignRight(Vector128<ulong> left, Vector128<ulong> right, byte mask);
+        public static Vector128<short> HorizontalAdd(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> HorizontalAdd(Vector128<int> left, Vector128<int> right);
+        public static Vector128<short> HorizontalAddSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> HorizontalSubtract(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> HorizontalSubtract(Vector128<int> left, Vector128<int> right);
+        public static Vector128<short> HorizontalSubtractSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> MultiplyAddAdjacent(Vector128<byte> left, Vector128<sbyte> right);
+        public static Vector128<short> MultiplyHighRoundScale(Vector128<short> left, Vector128<short> right);
+        public static Vector128<byte> Shuffle(Vector128<byte> value, Vector128<byte> mask);
+        public static Vector128<sbyte> Shuffle(Vector128<sbyte> value, Vector128<sbyte> mask);
+        public static Vector128<short> Sign(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Sign(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Sign(Vector128<sbyte> left, Vector128<sbyte> right);
+    }
+}
```

