# System.Text.Json.Serialization

``` diff
+namespace System.Text.Json.Serialization {
+    public abstract class JsonAttribute : Attribute {
+        protected JsonAttribute();
+    }
+    public abstract class JsonConverter {
+        public abstract bool CanConvert(Type typeToConvert);
+    }
+    public abstract class JsonConverter<T> : JsonConverter {
+        protected internal JsonConverter();
+        public override bool CanConvert(Type typeToConvert);
+        public abstract T Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options);
+        public abstract void Write(Utf8JsonWriter writer, T value, JsonSerializerOptions options);
+    }
+    public class JsonConverterAttribute : JsonAttribute {
+        protected JsonConverterAttribute();
+        public JsonConverterAttribute(Type converterType);
+        public Type ConverterType { get; }
+        public virtual JsonConverter CreateConverter(Type typeToConvert);
+    }
+    public abstract class JsonConverterFactory : JsonConverter {
+        protected JsonConverterFactory();
+        public abstract JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+    }
+    public sealed class JsonExtensionDataAttribute : JsonAttribute {
+        public JsonExtensionDataAttribute();
+    }
+    public sealed class JsonIgnoreAttribute : JsonAttribute {
+        public JsonIgnoreAttribute();
+    }
+    public sealed class JsonPropertyNameAttribute : JsonAttribute {
+        public JsonPropertyNameAttribute(string name);
+        public string Name { get; }
+    }
+    public sealed class JsonStringEnumConverter : JsonConverterFactory {
+        public JsonStringEnumConverter();
+        public JsonStringEnumConverter(JsonNamingPolicy namingPolicy = null, bool allowIntegerValues = true);
+        public override bool CanConvert(Type typeToConvert);
+        public override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+    }
+}
```

