# Microsoft.AspNetCore.SignalR.Redis

``` diff
 {
 {
-    namespace Microsoft.AspNetCore.SignalR.Redis {
 {
-        public class RedisHubLifetimeManager<THub> : HubLifetimeManager<THub>, IDisposable where THub : Hub {
 {
-            public RedisHubLifetimeManager(ILogger<RedisHubLifetimeManager<THub>> logger, IOptions<RedisOptions> options, IHubProtocolResolver hubProtocolResolver);

-            public override Task AddToGroupAsync(string connectionId, string groupName, CancellationToken cancellationToken = default(CancellationToken));

-            public void Dispose();

-            public override Task OnConnectedAsync(HubConnectionContext connection);

-            public override Task OnDisconnectedAsync(HubConnectionContext connection);

-            public override Task RemoveFromGroupAsync(string connectionId, string groupName, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendAllAsync(string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendAllExceptAsync(string methodName, object[] args, IReadOnlyList<string> excludedConnectionIds, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendConnectionAsync(string connectionId, string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendConnectionsAsync(IReadOnlyList<string> connectionIds, string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendGroupAsync(string groupName, string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendGroupExceptAsync(string groupName, string methodName, object[] args, IReadOnlyList<string> excludedConnectionIds, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendGroupsAsync(IReadOnlyList<string> groupNames, string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendUserAsync(string userId, string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));

-            public override Task SendUsersAsync(IReadOnlyList<string> userIds, string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));

-        }
-        public class RedisOptions {
 {
-            public RedisOptions();

-            public ConfigurationOptions Configuration { get; set; }

-            public Func<TextWriter, Task<IConnectionMultiplexer>> ConnectionFactory { get; set; }

-        }
-    }
-    namespace Microsoft.AspNetCore.SignalR.Redis.Internal {
 {
-        public enum GroupAction : byte {
 {
-            Add = (byte)1,

-            Remove = (byte)2,

-        }
-        public readonly struct RedisGroupCommand {
 {
-            public RedisGroupCommand(int id, string serverName, GroupAction action, string groupName, string connectionId);

-            public GroupAction Action { get; }

-            public string ConnectionId { get; }

-            public string GroupName { get; }

-            public int Id { get; }

-            public string ServerName { get; }

-        }
-        public readonly struct RedisInvocation {
 {
-            public RedisInvocation(SerializedHubMessage message, IReadOnlyList<string> excludedConnectionIds);

-            public IReadOnlyList<string> ExcludedConnectionIds { get; }

-            public SerializedHubMessage Message { get; }

-            public static RedisInvocation Create(string target, object[] arguments, IReadOnlyList<string> excludedConnectionIds = null);

-        }
-        public class RedisProtocol {
 {
-            public RedisProtocol(IReadOnlyList<IHubProtocol> protocols);

-            public int ReadAck(ReadOnlyMemory<byte> data);

-            public RedisGroupCommand ReadGroupCommand(ReadOnlyMemory<byte> data);

-            public RedisInvocation ReadInvocation(ReadOnlyMemory<byte> data);

-            public static SerializedHubMessage ReadSerializedHubMessage(ref ReadOnlyMemory<byte> data);

-            public byte[] WriteAck(int messageId);

-            public byte[] WriteGroupCommand(RedisGroupCommand command);

-            public byte[] WriteInvocation(string methodName, object[] args);

-            public byte[] WriteInvocation(string methodName, object[] args, IReadOnlyList<string> excludedConnectionIds);

-        }
-    }
-    namespace Microsoft.Extensions.DependencyInjection {
 {
-        public static class RedisDependencyInjectionExtensions {
 {
-            public static ISignalRServerBuilder AddRedis(this ISignalRServerBuilder signalrBuilder);

-            public static ISignalRServerBuilder AddRedis(this ISignalRServerBuilder signalrBuilder, Action<RedisOptions> configure);

-            public static ISignalRServerBuilder AddRedis(this ISignalRServerBuilder signalrBuilder, string redisConnectionString);

-            public static ISignalRServerBuilder AddRedis(this ISignalRServerBuilder signalrBuilder, string redisConnectionString, Action<RedisOptions> configure);

-        }
-    }
-}
```

