# Microsoft.Extensions.Hosting.Abstractions

``` diff
 {
     namespace Microsoft.Extensions.DependencyInjection {
         public static class ServiceCollectionHostedServiceExtensions {
+            public static IServiceCollection AddHostedService<THostedService>(this IServiceCollection services, Func<IServiceProvider, THostedService> implementationFactory) where THostedService : class, IHostedService;
         }
     }
     namespace Microsoft.Extensions.Hosting {
+        public static class Environments {
+            public static readonly string Development;
+            public static readonly string Production;
+            public static readonly string Staging;
+        }
         public class HostBuilderContext {
-            public IHostingEnvironment HostingEnvironment { get; set; }
+            public IHostEnvironment HostingEnvironment { get; set; }
         }
+        public static class HostEnvironmentEnvExtensions {
+            public static bool IsDevelopment(this IHostEnvironment hostEnvironment);
+            public static bool IsEnvironment(this IHostEnvironment hostEnvironment, string environmentName);
+            public static bool IsProduction(this IHostEnvironment hostEnvironment);
+            public static bool IsStaging(this IHostEnvironment hostEnvironment);
+        }
         public static class HostingAbstractionsHostBuilderExtensions {
+            public static Task<IHost> StartAsync(this IHostBuilder hostBuilder, CancellationToken cancellationToken = default(CancellationToken));
         }
+        public interface IHostApplicationLifetime {
+            CancellationToken ApplicationStarted { get; }
+            CancellationToken ApplicationStopped { get; }
+            CancellationToken ApplicationStopping { get; }
+            void StopApplication();
+        }
         public interface IHostBuilder {
+            IHostBuilder UseServiceProviderFactory<TContainerBuilder>(Func<HostBuilderContext, IServiceProviderFactory<TContainerBuilder>> factory);
         }
+        public interface IHostEnvironment {
+            string ApplicationName { get; set; }
+            IFileProvider ContentRootFileProvider { get; set; }
+            string ContentRootPath { get; set; }
+            string EnvironmentName { get; set; }
+        }
     }
 }
```

