# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
-    public class AuthenticationState {
 {
-        public AuthenticationState(ClaimsPrincipal user);

-        public ClaimsPrincipal User { get; }

-    }
-    public delegate void AuthenticationStateChangedHandler(Task<AuthenticationState> task);

-    public abstract class AuthenticationStateProvider {
 {
-        protected AuthenticationStateProvider();

-        public event AuthenticationStateChangedHandler AuthenticationStateChanged;

-        public abstract Task<AuthenticationState> GetAuthenticationStateAsync();

-        protected void NotifyAuthenticationStateChanged(Task<AuthenticationState> task);

-    }
-    public class AuthorizeView : AuthorizeViewCore {
 {
-        public AuthorizeView();

-        public string Policy { get; set; }

-        public string Roles { get; set; }

-        protected override IAuthorizeData[] GetAuthorizeData();

-    }
-    public abstract class AuthorizeViewCore : ComponentBase {
 {
-        protected AuthorizeViewCore();

-        public RenderFragment<AuthenticationState> Authorized { get; set; }

-        public RenderFragment Authorizing { get; set; }

-        public RenderFragment<AuthenticationState> ChildContent { get; set; }

-        public RenderFragment<AuthenticationState> NotAuthorized { get; set; }

-        public object Resource { get; set; }

-        protected override void BuildRenderTree(RenderTreeBuilder builder);

-        protected abstract IAuthorizeData[] GetAuthorizeData();

-        protected override Task OnParametersSetAsync();

-    }
-    public static class BindAttributes

     public static class BindConverter {
         public static string FormatValue(Decimal value, CultureInfo culture = null);
         public static string FormatValue(Nullable<Decimal> value, CultureInfo culture = null);
         public static bool TryConvertToDecimal(object obj, CultureInfo culture, out Decimal value);
         public static bool TryConvertToNullableDecimal(object obj, CultureInfo culture, out Nullable<Decimal> value);
     }
-    public class CascadingAuthenticationState : ComponentBase, IDisposable {
 {
-        public CascadingAuthenticationState();

-        public RenderFragment ChildContent { get; set; }

-        protected override void BuildRenderTree(RenderTreeBuilder builder);

-        protected override void OnInitialized();

-        void System.IDisposable.Dispose();

-    }
-    public class CascadingValue<T> : IComponent {
 {
-        public CascadingValue();

-        public RenderFragment ChildContent { get; set; }

-        public bool IsFixed { get; set; }

-        public string Name { get; set; }

-        public T Value { get; set; }

-        public void Attach(RenderHandle renderHandle);

-        public Task SetParametersAsync(ParameterView parameters);

-    }
+    public class CascadingValue<TValue> : IComponent {
+        public CascadingValue();
+        public RenderFragment ChildContent { get; set; }
+        public bool IsFixed { get; set; }
+        public string Name { get; set; }
+        public TValue Value { get; set; }
+        public void Attach(RenderHandle renderHandle);
+        public Task SetParametersAsync(ParameterView parameters);
+    }
+    public class ChangeEventArgs : EventArgs {
+        public ChangeEventArgs();
+        public object Value { get; set; }
+    }
     public abstract class ComponentBase : IComponent, IHandleAfterRender, IHandleEvent {
+        protected virtual void BuildRenderTree(RenderTreeBuilder builder);
-        protected virtual void BuildRenderTree(RenderTreeBuilder builder);

-        protected virtual void OnAfterRender();

+        protected virtual void OnAfterRender(bool firstRender);
-        protected virtual Task OnAfterRenderAsync();

+        protected virtual Task OnAfterRenderAsync(bool firstRender);
     }
-    public class DataTransfer {
 {
-        public DataTransfer();

-        public string DropEffect { get; set; }

-        public string EffectAllowed { get; set; }

-        public string[] Files { get; set; }

-        public UIDataTransferItem[] Items { get; set; }

-        public string[] Types { get; set; }

-    }
     public abstract class Dispatcher {
+        public void AssertAccess();
     }
     public readonly struct ElementReference {
+        public ElementReference(string id);
+        public string Id { get; }
     }
-    public readonly struct EventCallback<T> {
 {
-        public static readonly EventCallback<T> Empty;

-        public EventCallback(IHandleEvent receiver, MulticastDelegate @delegate);

-        public bool HasDelegate { get; }

-        public Task InvokeAsync(T arg);

-    }
+    public readonly struct EventCallback<TValue> {
+        public static readonly EventCallback<TValue> Empty;
+        public EventCallback(IHandleEvent receiver, MulticastDelegate @delegate);
+        public bool HasDelegate { get; }
+        public Task InvokeAsync(TValue arg);
+    }
     public sealed class EventCallbackFactory {
-        public EventCallback<T> Create<T>(object receiver, EventCallback callback);

-        public EventCallback<T> Create<T>(object receiver, EventCallback<T> callback);

-        public EventCallback<T> Create<T>(object receiver, Action callback);

-        public EventCallback<T> Create<T>(object receiver, Action<T> callback);

-        public EventCallback<T> Create<T>(object receiver, Func<Task> callback);

-        public EventCallback<T> Create<T>(object receiver, Func<T, Task> callback);

+        public EventCallback<TValue> Create<TValue>(object receiver, EventCallback callback);
+        public EventCallback<TValue> Create<TValue>(object receiver, EventCallback<TValue> callback);
+        public EventCallback<TValue> Create<TValue>(object receiver, Action callback);
+        public EventCallback<TValue> Create<TValue>(object receiver, Action<TValue> callback);
+        public EventCallback<TValue> Create<TValue>(object receiver, Func<Task> callback);
+        public EventCallback<TValue> Create<TValue>(object receiver, Func<TValue, Task> callback);
-        public EventCallback<T> CreateInferred<T>(object receiver, Action<T> callback, T value);

-        public EventCallback<T> CreateInferred<T>(object receiver, Func<T, Task> callback, T value);

+        public EventCallback<TValue> CreateInferred<TValue>(object receiver, Action<TValue> callback, TValue value);
+        public EventCallback<TValue> CreateInferred<TValue>(object receiver, Func<TValue, Task> callback, TValue value);
     }
     public static class EventCallbackFactoryBinderExtensions {
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<bool> setter, bool existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<bool> setter, bool existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, string format, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, string format, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, string format, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, string format, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Decimal> setter, Decimal existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<decimal> setter, decimal existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<double> setter, double existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<double> setter, double existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<int> setter, int existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<int> setter, int existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<long> setter, long existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<long> setter, long existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<bool>> setter, Nullable<bool> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<bool>> setter, Nullable<bool> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTime>> setter, Nullable<DateTime> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTime>> setter, Nullable<DateTime> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTime>> setter, Nullable<DateTime> existingValue, string format, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTime>> setter, Nullable<DateTime> existingValue, string format, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTimeOffset>> setter, Nullable<DateTimeOffset> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTimeOffset>> setter, Nullable<DateTimeOffset> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTimeOffset>> setter, Nullable<DateTimeOffset> existingValue, string format, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTimeOffset>> setter, Nullable<DateTimeOffset> existingValue, string format, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<Decimal>> setter, Nullable<Decimal> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<decimal>> setter, Nullable<decimal> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<double>> setter, Nullable<double> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<double>> setter, Nullable<double> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<int>> setter, Nullable<int> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<int>> setter, Nullable<int> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<long>> setter, Nullable<long> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<long>> setter, Nullable<long> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<float>> setter, Nullable<float> existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<float>> setter, Nullable<float> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<float> setter, float existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<float> setter, float existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<string> setter, string existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<string> setter, string existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder<T>(this EventCallbackFactory factory, object receiver, Action<T> setter, T existingValue, CultureInfo culture = null);

+        public static EventCallback<ChangeEventArgs> CreateBinder<T>(this EventCallbackFactory factory, object receiver, Action<T> setter, T existingValue, CultureInfo culture = null);
     }
+    public static class EventCallbackFactoryEventArgsExtensions {
+        public static EventCallback<ChangeEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ChangeEventArgs> callback);
+        public static EventCallback<EventArgs> Create(this EventCallbackFactory factory, object receiver, Action<EventArgs> callback);
+        public static EventCallback<ChangeEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ChangeEventArgs, Task> callback);
+        public static EventCallback<EventArgs> Create(this EventCallbackFactory factory, object receiver, Func<EventArgs, Task> callback);
+    }
-    public static class EventCallbackFactoryUIEventArgsExtensions {
 {
-        public static EventCallback<UIChangeEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIChangeEventArgs> callback);

-        public static EventCallback<UIEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIEventArgs> callback);

-        public static EventCallback<UIChangeEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIChangeEventArgs, Task> callback);

-        public static EventCallback<UIEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIEventArgs, Task> callback);

-    }
-    public static class EventHandlers

-    public interface IComponentContext {
 {
-        bool IsConnected { get; }

-    }
-    public interface IHostEnvironmentAuthenticationStateProvider {
 {
-        void SetAuthenticationState(Task<AuthenticationState> authenticationStateTask);

-    }
-    public interface IUriHelper {
 {
-        event EventHandler<LocationChangedEventArgs> OnLocationChanged;

-        string GetAbsoluteUri();

-        string GetBaseUri();

-        void NavigateTo(string uri);

-        void NavigateTo(string uri, bool forceLoad);

-        Uri ToAbsoluteUri(string href);

-        string ToBaseRelativePath(string baseUri, string locationAbsolute);

-    }
+    public class LayoutView : IComponent {
+        public LayoutView();
+        public RenderFragment ChildContent { get; set; }
+        public Type Layout { get; set; }
+        public void Attach(RenderHandle renderHandle);
+        public Task SetParametersAsync(ParameterView parameters);
+    }
+    public sealed class LocationChangeException : Exception {
+        public LocationChangeException(string message, Exception innerException);
+    }
+    public abstract class NavigationManager {
+        protected NavigationManager();
+        public string BaseUri { get; protected set; }
+        public string Uri { get; protected set; }
+        public event EventHandler<LocationChangedEventArgs> LocationChanged;
+        protected virtual void EnsureInitialized();
+        protected void Initialize(string baseUri, string uri);
+        public void NavigateTo(string uri, bool forceLoad = false);
+        protected abstract void NavigateToCore(string uri, bool forceLoad);
+        protected void NotifyLocationChanged(bool isInterceptedLink);
+        public Uri ToAbsoluteUri(string relativeUri);
+        public string ToBaseRelativePath(string uri);
+    }
+    public abstract class OwningComponentBase : ComponentBase, IDisposable {
+        protected OwningComponentBase();
+        protected bool IsDisposed { get; }
+        protected IServiceProvider ScopedServices { get; }
+        protected virtual void Dispose(bool disposing);
+        void System.IDisposable.Dispose();
+    }
+    public abstract class OwningComponentBase<TService> : OwningComponentBase, IDisposable {
+        protected OwningComponentBase();
+        protected TService Service { get; }
+    }
-    public class PageDisplay : IComponent {
 {
-        public PageDisplay();

-        public RenderFragment AuthorizingContent { get; set; }

-        public RenderFragment<AuthenticationState> NotAuthorizedContent { get; set; }

-        public Type Page { get; set; }

-        public IDictionary<string, object> PageParameters { get; set; }

-        public void Attach(RenderHandle renderHandle);

-        public Task SetParametersAsync(ParameterView parameters);

-    }
     public readonly struct ParameterView {
-        public T GetValueOrDefault<T>(string parameterName);

-        public T GetValueOrDefault<T>(string parameterName, T defaultValue);

+        public TValue GetValueOrDefault<TValue>(string parameterName);
+        public TValue GetValueOrDefault<TValue>(string parameterName, TValue defaultValue);
-        public bool TryGetValue<T>(string parameterName, out T result);

+        public bool TryGetValue<TValue>(string parameterName, out TValue result);
     }
     public delegate void RenderFragment(RenderTreeBuilder builder);
-    public delegate RenderFragment RenderFragment<T>(T value);

+    public delegate RenderFragment RenderFragment<TValue>(TValue value);
+    public sealed class RouteData {
+        public RouteData(Type pageType, IReadOnlyDictionary<string, object> routeValues);
+        public Type PageType { get; }
+        public IReadOnlyDictionary<string, object> RouteValues { get; }
+    }
+    public class RouteView : IComponent {
+        public RouteView();
+        public Type DefaultLayout { get; set; }
+        public RouteData RouteData { get; set; }
+        public void Attach(RenderHandle renderHandle);
+        protected virtual void Render(RenderTreeBuilder builder);
+        public Task SetParametersAsync(ParameterView parameters);
+    }
-    public class UIChangeEventArgs : UIEventArgs {
 {
-        public UIChangeEventArgs();

-        public object Value { get; set; }

-    }
-    public class UIClipboardEventArgs : UIEventArgs {
 {
-        public UIClipboardEventArgs();

-    }
-    public class UIDataTransferItem {
 {
-        public UIDataTransferItem();

-        public string Kind { get; set; }

-        public string Type { get; set; }

-    }
-    public class UIDragEventArgs : UIMouseEventArgs {
 {
-        public UIDragEventArgs();

-        public DataTransfer DataTransfer { get; set; }

-    }
-    public class UIErrorEventArgs : UIEventArgs {
 {
-        public UIErrorEventArgs();

-        public int Colno { get; set; }

-        public string Filename { get; set; }

-        public int Lineno { get; set; }

-        public string Message { get; set; }

-    }
-    public class UIEventArgs {
 {
-        public UIEventArgs();

-        public string Type { get; set; }

-    }
-    public class UIFocusEventArgs : UIEventArgs {
 {
-        public UIFocusEventArgs();

-    }
-    public class UIKeyboardEventArgs : UIEventArgs {
 {
-        public UIKeyboardEventArgs();

-        public bool AltKey { get; set; }

-        public string Code { get; set; }

-        public bool CtrlKey { get; set; }

-        public string Key { get; set; }

-        public float Location { get; set; }

-        public bool MetaKey { get; set; }

-        public bool Repeat { get; set; }

-        public bool ShiftKey { get; set; }

-    }
-    public class UIMouseEventArgs : UIEventArgs {
 {
-        public UIMouseEventArgs();

-        public bool AltKey { get; set; }

-        public long Button { get; set; }

-        public long Buttons { get; set; }

-        public double ClientX { get; set; }

-        public double ClientY { get; set; }

-        public bool CtrlKey { get; set; }

-        public long Detail { get; set; }

-        public bool MetaKey { get; set; }

-        public double ScreenX { get; set; }

-        public double ScreenY { get; set; }

-        public bool ShiftKey { get; set; }

-    }
-    public class UIPointerEventArgs : UIMouseEventArgs {
 {
-        public UIPointerEventArgs();

-        public float Height { get; set; }

-        public bool IsPrimary { get; set; }

-        public long PointerId { get; set; }

-        public string PointerType { get; set; }

-        public float Pressure { get; set; }

-        public float TiltX { get; set; }

-        public float TiltY { get; set; }

-        public float Width { get; set; }

-    }
-    public class UIProgressEventArgs : UIEventArgs {
 {
-        public UIProgressEventArgs();

-        public bool LengthComputable { get; set; }

-        public long Loaded { get; set; }

-        public long Total { get; set; }

-    }
-    public class UITouchEventArgs : UIEventArgs {
 {
-        public UITouchEventArgs();

-        public bool AltKey { get; set; }

-        public UITouchPoint[] ChangedTouches { get; set; }

-        public bool CtrlKey { get; set; }

-        public long Detail { get; set; }

-        public bool MetaKey { get; set; }

-        public bool ShiftKey { get; set; }

-        public UITouchPoint[] TargetTouches { get; set; }

-        public UITouchPoint[] Touches { get; set; }

-    }
-    public class UITouchPoint {
 {
-        public UITouchPoint();

-        public double ClientX { get; set; }

-        public double ClientY { get; set; }

-        public long Identifier { get; set; }

-        public double PageX { get; set; }

-        public double PageY { get; set; }

-        public double ScreenX { get; set; }

-        public double ScreenY { get; set; }

-    }
-    public class UIWheelEventArgs : UIMouseEventArgs {
 {
-        public UIWheelEventArgs();

-        public long DeltaMode { get; set; }

-        public double DeltaX { get; set; }

-        public double DeltaY { get; set; }

-        public double DeltaZ { get; set; }

-    }
-    public abstract class UriHelperBase : IUriHelper {
 {
-        protected UriHelperBase();

-        public event EventHandler<LocationChangedEventArgs> OnLocationChanged;

-        protected virtual void EnsureInitialized();

-        public string GetAbsoluteUri();

-        public virtual string GetBaseUri();

-        public virtual void InitializeState(string uriAbsolute, string baseUriAbsolute);

-        public void NavigateTo(string uri);

-        public void NavigateTo(string uri, bool forceLoad);

-        protected abstract void NavigateToCore(string uri, bool forceLoad);

-        protected void SetAbsoluteBaseUri(string baseUri);

-        protected void SetAbsoluteUri(string uri);

-        public Uri ToAbsoluteUri(string href);

-        public string ToBaseRelativePath(string baseUri, string locationAbsolute);

-        protected void TriggerOnLocationChanged(bool isinterceptedLink);

-    }
-    public static class WebEventCallbackFactoryUIEventArgsExtensions {
 {
-        public static EventCallback<UIClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIClipboardEventArgs> callback);

-        public static EventCallback<UIDragEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIDragEventArgs> callback);

-        public static EventCallback<UIErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIErrorEventArgs> callback);

-        public static EventCallback<UIFocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIFocusEventArgs> callback);

-        public static EventCallback<UIKeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIKeyboardEventArgs> callback);

-        public static EventCallback<UIMouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIMouseEventArgs> callback);

-        public static EventCallback<UIPointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIPointerEventArgs> callback);

-        public static EventCallback<UIProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIProgressEventArgs> callback);

-        public static EventCallback<UITouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UITouchEventArgs> callback);

-        public static EventCallback<UIWheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIWheelEventArgs> callback);

-        public static EventCallback<UIClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIClipboardEventArgs, Task> callback);

-        public static EventCallback<UIDragEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIDragEventArgs, Task> callback);

-        public static EventCallback<UIErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIErrorEventArgs, Task> callback);

-        public static EventCallback<UIFocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIFocusEventArgs, Task> callback);

-        public static EventCallback<UIKeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIKeyboardEventArgs, Task> callback);

-        public static EventCallback<UIMouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIMouseEventArgs, Task> callback);

-        public static EventCallback<UIPointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIPointerEventArgs, Task> callback);

-        public static EventCallback<UIProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIProgressEventArgs, Task> callback);

-        public static EventCallback<UITouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UITouchEventArgs, Task> callback);

-        public static EventCallback<UIWheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIWheelEventArgs, Task> callback);

-    }
 }
```

