# .NET Core 3.1 - Supported OS versions

[.NET Core 3.1](README.md) is supported on multiple operating systems per their [lifecycle policy](../../os-lifecycle-policy.md).

## Keys used in the tables

* **Bold numbers** indicate additions to this release.
* A '+' indicates the minimum supported version.
* Where possible, links to Distribution-owned lifecycle documentation is provided.

## Windows

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Windows Client                | 7 SP1(**\***), 8.1            | x64, x86       |
Windows 10 Client             | Version 1607+                 | x64, x86       | 1607 is the minimum version for support. See [Out of support OS versions](#out-of-support-os-versions) below for Windows 10 releases that are no longer supported.
Nano Server                   | Version 1803+                 | x64, ARM32     |
Windows Server                | 2012 R2+                  | x64, x86       |

**\*** Windows 7 SP1 is supported with [Extended Security Updates](https://docs.microsoft.com/troubleshoot/windows-client/windows-7-eos-faq/windows-7-extended-security-updates-faq) installed.

s
See the [Windows Lifecycle Fact Sheet](https://support.microsoft.com/help/13853/windows-lifecycle-fact-sheet) for details regarding each Windows release lifecycle.

## macOS

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Mac OS X                      | 10.13+                        | x64            | [Apple Support Sitemap](https://support.apple.com/sitemap) <br> [Apple Security Updates](https://support.apple.com/en-us/HT201222)

## Linux

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Red Hat Enterprise Linux      | 7+                            | x64            | [Microsoft support policy](https://dotnet.microsoft.com/platform/support/policy/)
Red Hat Enterprise Linux <br> CentOS <br> Oracle Linux | 7+    | x64            | [Red Hat support policy](https://access.redhat.com/support/policy/updates/errata/) <br> [CentOS lifecycle](https://wiki.centos.org/FAQ/General#head-fe8a0be91ee3e7dea812e8694491e1dde5b75e6d) <br> [Oracle Linux lifecycle](https://www.oracle.com/a/ocom/docs/elsp-lifetime-069338.pdf)
Fedora                        | 33+                    | x64            | [Fedora lifecycle](https://fedoraproject.org/wiki/End_of_life)
Debian                        | 9+                       | x64, ARM32, ARM64     | [Debian lifecycle](https://wiki.debian.org/DebianReleases)
Ubuntu                        | 21.04, 20.04, 18.04                  | x64, ARM32, ARM64   | [Ubuntu lifecycle](https://wiki.ubuntu.com/Releases)
Linux Mint                    | 18+                          | x64            | [Linux Mint end of life announcements](https://forums.linuxmint.com/search.php?keywords=%22end+of+life%22&terms=all&author=&sc=1&sf=titleonly&sr=posts&sk=t&sd=d&st=0&ch=300&t=0&submit=Search)
openSUSE                      | 15+                         | x64            | [OpenSUSE lifecycle](https://en.opensuse.org/Lifetime)
SUSE Enterprise Linux (SLES)  | 12 SP2+                       | x64            | [SUSE lifecycle](https://www.suse.com/lifecycle/)
Alpine Linux                  | 3.10+                          | x64, ARM64            | [Alpine lifecycle](https://wiki.alpinelinux.org/wiki/Alpine_Linux:Releases)

* **Bold numbers** indicate additions in this release.
* '+' indicates the minimum supported version.

## Out of support OS versions

Support for the following versions was ended by the distribution owners and are [no longer supported by .NET Core 3.1](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md).

|OS         | Version  | End of Life | Supported Version|
|-----------|----------|-------------|------------------|
| Windows 10| 1703     | [10/08/2019](https://support.microsoft.com/help/13853/windows-lifecycle-fact-sheet) |
| Fedora    | 30       | [05/26/2020](https://lists.fedoraproject.org/archives/list/devel@lists.fedoraproject.org/message/7UTUFY7WEL6RTFRXJB75XAFH44Y6RPUC/)   |
| Fedora    | 31       | [11/24/2020](https://lists.fedoraproject.org/archives/list/announce@lists.fedoraproject.org/thread/NU5AENRUFG4XK5D34SJN5FZPLYMZF6ZQ/)   |
| Fedora    | 32       | [05/25/2021](https://lists.fedoraproject.org/archives/list/announce@lists.fedoraproject.org/thread/RPZQXPEV3L45YQV2HRBIQ5DQZ7GMP4X3/)   |
| Alpine    | 3.8      | [05/01/2020](https://alpinelinux.org/releases/)   |
| Ubuntu    | 19.04    | [01/23/2020](https://wiki.ubuntu.com/Releases)   |
| Ubuntu    | 19.10    | [07/17/2020](https://wiki.ubuntu.com/Releases)   |
| Ubuntu    | 20.10    | [07/22/2021](https://wiki.ubuntu.com/Releases)   |
| RHEL    | 6    | [11/30/2020](https://access.redhat.com/support/policy/updates/errata)   |
