# .NET Core 3.1.11 - January 12, 2021

The .NET 3.1.11 and .NET SDK 3.1.111 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.111
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.11 is being deployed to Azure App Services and the deployment is expected to complete later in January 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.405](3.1.405-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.111](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.11 release carries both security and non-security fixes.

### [CVE-2021-1723 | ASP.NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-1723)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core and ASP.NET 5. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists in the way Kestrel parses HTTP/2 requests. The security update addresses the vulnerability by fixing the way the Kestrel parses HTTP/2 requests.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/pulls?q=milestone%3A3.1.11+is%3Aclosed+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/pulls?q=milestone%3A3.1.11+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A3.1.11+is%3Aclosed+label%3Aservicing-approved)
* [Extensions](https://github.com/dotnet/extensions/pulls?q=milestone%3A3.1.11+is%3Aclosed+label%3Aservicing-approved)
* [EFCore](https://github.com/dotnet/efcore/pulls?q=is%3Apr+is%3Aclosed+3.1.11+label%3Aservicing-approved)

## Adding a switch to enable sending ISO-8859-1 headers with SocketsHttpHandler

Since the introduction of `SocketsHttpHandler` in .NET Core 2.1, an attempt to send non-ASCII characters in HTTP headers throws an `HttpRequestException`. This (RFC-conform) behavior turned out to be a blocker for some users trying to migrate from .NET Framework. In .NET 5 we are addressing this by the introduction of [`SocketsHttpHandler.RequestHeaderEncodingSelector`](https://docs.microsoft.com/dotnet/api/system.net.http.socketshttphandler.requestheaderencodingselector?view=net-5.0). To unblock users who are not (yet) able to migrate to .NET 5.0, we also added a runtime-configuration switch as part of .NET Core 3.1 servicing. This switch allows relaxing the HTTP header validation, enabling `SocketsHttpHandler` to send ISO-8859-1 (Latin-1) encoded characters in headers.

- `AppContext` switch: `System.Net.Http.SocketsHttpHandler.AllowLatin1Headers`. `false` - disabled, `true` - enabled
- Environment variable: `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_ALLOWLATIN1HEADERS`. `0` - disabled, `1` - enabled

**Note:**

This switch is specific to .NET Core 3.1 since service release 3.1.11, and not available in later versions.



## macOS Notarization Change
  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://docs.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, add the following to your project file:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5838](https://github.com/dotnet/core/issues/5838) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.11.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.11.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.11.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.11.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.11.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.11.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.11.nupkg
Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.11.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.11.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.11.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.11.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.11.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.11.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.11.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.11.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.11.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.11.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.11.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.11.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.11.nupkg
Microsoft.AspNetCore.Components | 3.1.11.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.11.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.11.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.11.nupkg
Microsoft.AspNetCore.Owin | 3.1.11.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.11.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.11.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.11.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.11.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.11.nupkg
Microsoft.AspNetCore.Metadata | 3.1.11.nupkg
Microsoft.dotnet-openapi | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.11.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.11.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.11.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.11.nupkg
Microsoft.Extensions.Identity.Core | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.11.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.11.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.11.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.11.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.11.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.11.nupkg
Microsoft.AspNetCore.TestHost | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.11.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.11.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.11.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.11.nupkg
Microsoft.AspNetCore.Authorization | 3.1.11.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.11.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.11.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.11.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.11.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.11.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.11.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.11.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.11.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.11.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.11.nupkg
dotnet-sql-cache | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.11.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.11.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.11.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.11.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.11.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.11.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.11.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.11.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.11.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.11.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.11.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.11.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.11.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.11.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.11.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.11.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.11.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.11.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.11.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.11.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.11.nupkg
System.IO.Pipelines | 4.7.4.nupkg
Microsoft.Bcl.HashCode | 1.1.1.nupkg
Microsoft.NET.Sdk.Razor | 3.1.11.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.11.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.11.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.11.nupkg
dotnet-ef | 3.1.11.nupkg
Microsoft.Data.Sqlite | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.11.nupkg
Microsoft.Data.Sqlite.Core | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.11.nupkg
Microsoft.EntityFrameworkCore | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.11.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.11.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.11.nupkg
Microsoft.Extensions.Configuration | 3.1.11.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.11.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.11.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.11.nupkg
Microsoft.Extensions.Hosting | 3.1.11.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.11.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.11.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.11.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.11.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.11.nupkg
Microsoft.Extensions.Primitives | 3.1.11.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.11.nupkg
Microsoft.Extensions.Logging.Console | 3.1.11.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.11.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.11.nupkg
Microsoft.Extensions.ObjectPool | 3.1.11.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.11.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.11.nupkg
Microsoft.Extensions.Http.Polly | 3.1.11.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.11.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.11.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.11.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.11.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.11.nupkg
Microsoft.Extensions.Http | 3.1.11.nupkg
Microsoft.Extensions.Logging | 3.1.11.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.11.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.11.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.11.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.11.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.11.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.11.nupkg
Microsoft.JSInterop | 3.1.11.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.11.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.11.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.11.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.11.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.11.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.11.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.11.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.11.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.11.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.11.nupkg
Microsoft.Extensions.WebEncoders | 3.1.11.nupkg
Microsoft.Extensions.Options | 3.1.11.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.11.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.11.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.11.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.11.nupkg
Microsoft.Extensions.Localization | 3.1.11.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.11.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.11/3.1.11.md
[snap-install]: 3.1.11-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.11-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.11-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-january-2021/


[//]: # ( Runtime 3.1.11)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a119100f-e7b3-4c30-a91a-d6ce6b02b51a/196c932070dd023726664a9789e4dc83/dotnet-runtime-3.1.11-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43f52041-c41e-45ae-a485-532936641962/bf876e3c12b18829ac4d7bcb7a882309/dotnet-runtime-3.1.11-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/385af258-998c-4b2b-a675-a7ee361a300b/d8925cb0e8ae78a0cc9935cbaa78100b/dotnet-runtime-3.1.11-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a6e98c93-c624-4735-ad33-80ab3f9fb2af/aad58a0613e58dcab40615bdc1d23b6d/dotnet-runtime-3.1.11-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3575ea2-ce06-4002-8568-e887da3e3a4f/7991b9bb111edcd2114efc6fe3ebfabb/dotnet-runtime-3.1.11-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8267f236-8793-4de0-86e3-bbf60e4efee1/2df414537a8cdc4d3248c6af888b8011/dotnet-runtime-3.1.11-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a4556f8-fca7-4037-9961-42c3730cb7a4/745d544a620d1ae33fe3ced88189e814/dotnet-runtime-3.1.11-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8cde680f-89ae-4af2-a892-92d1cd749e49/8862104362ea5b9fd3b1729e62ed7729/dotnet-runtime-3.1.11-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/15885ffa-ab48-4ee1-99a2-4f20e71ce956/06267d73270ed92fb5a8c873ef56045d/dotnet-runtime-3.1.11-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1663aa9d-6227-4045-bb8b-8398c583a7b1/f81cb5fe464422e758591d01fe5acbab/dotnet-runtime-3.1.11-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/11da2dd3-9946-49f4-9758-868dcfd9b479/5cc2813259ae85912c3484151637782e/dotnet-runtime-3.1.11-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/80f405da-33a3-4446-b3b4-c9bbdeaf22a0/7256a2a92f09a18634aa9ddbe25b7500/dotnet-runtime-3.1.11-win-x86.zip

[//]: # ( WindowsDesktop 3.1.11)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3f1cc4f7-0c1a-48ca-9551-a8447fa55892/ed9809822448f55b649858920afb35cb/windowsdesktop-runtime-3.1.11-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/42b8e14d-6f6d-421f-a150-39adc1727e07/c2963b894eaea409ca33f8c7076c41a8/windowsdesktop-runtime-3.1.11-win-x86.exe

[//]: # ( ASP 3.1.11)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cdd0f59e-e9ac-414c-9608-2f1aa415ce88/cf43b2bdd0218ce377027fd40cd5a162/aspnetcore-runtime-3.1.11-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08602346-21c0-43ed-9520-ad3bf1ab3dc0/0728031d0bdcad6468b3928eaea086ec/aspnetcore-runtime-3.1.11-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7102b3f2-fce2-4c58-af64-fcd34af9e35c/147c9506baba6a971583f0033010dea7/aspnetcore-runtime-3.1.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a2ba2ce-426f-4153-ad38-e914e45cac21/0fff19852b826f9cdb83f1fd1fdba5c0/aspnetcore-runtime-3.1.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91e7ea86-985e-401f-b3ed-103fb0fe6058/c1b1f633c9465c630e828f7f8bdf8f4e/aspnetcore-runtime-3.1.11-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5881a21e-96f5-4d6f-8a70-fb73a3469766/6341808487e5df818c064f45a206d0be/aspnetcore-runtime-3.1.11-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/6a0d9809-5cd3-4ae2-974e-517a23168441/d67bdbceb95b45cdcb015b1480368c94/aspnetcore-runtime-3.1.11-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e16f1d4a-6a2d-4c16-b286-1240642ae288/edeb427be7e487eb6a61108c1e6f53ce/aspnetcore-runtime-3.1.11-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6a85d2fd-8c7c-45d0-9058-e5c9fd7d8cf9/e017c13ab1fda23f2fa11b052c735871/aspnetcore-runtime-3.1.11-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8d9e6717-4158-432b-89fd-06c762e58831/cb9ae3d09dc0980f43a698159e308b9c/aspnetcore-runtime-3.1.11-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/42959533-fe1b-46a1-ad3d-5b2116f42d60/af89776aaa91efb767a0eeed08c11f9a/aspnetcore-runtime-3.1.11-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d8b046b7-c812-4200-905d-d2e0242be9d5/53d5698d79013be0232152ae1b43c86b/dotnet-hosting-3.1.11-win.exe

[//]: # ( SDK 3.1.111 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/127a8331-eb7c-423e-b326-fa2227c159bb/c5d9c46055e41b1b2486a2e289b382f7/dotnet-sdk-3.1.111-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e6d3a57-eba8-4036-af2f-257cc4e7c5ff/5307347389772eb8a9b60bbee6a808fa/dotnet-sdk-3.1.111-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a0ee29d-f5a0-4fcc-911c-50c142bdca92/6ed944880b4021c26218a017e2bc3acc/dotnet-sdk-3.1.111-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5d940c0-4c2f-4cbb-8d12-33bfb30c4db8/619b5be6e995cead6e9432134f903711/dotnet-sdk-3.1.111-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a94833ea-b78e-4985-8f32-8bd36b51a598/6dd5e3719633f8bda5ea6894353dbe51/dotnet-sdk-3.1.111-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e395edb9-a7ff-42b8-afa8-82f10e917722/20fd015da1553ffc2346e605d57e4c86/dotnet-sdk-3.1.111-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/5b48780e-47a1-4cea-a11a-659cdfaa80ac/0fc8ba01ef95736c4fdab26fda72e230/dotnet-sdk-3.1.111-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d5c614fa-73fe-43f1-9a80-56af8385cd30/f5730367b987c5ec3042af6eb7c8e18d/dotnet-sdk-3.1.111-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e2f22cc8-4336-465e-be29-389ef6a08032/72db32847724f488d4cc0d8a289fe584/dotnet-sdk-3.1.111-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7d4ac7a3-0859-4d92-8cd6-0d93aa13ba49/ef08b667ef13c2e6f40fcb2ca7023d09/dotnet-sdk-3.1.111-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/922824df-1f98-428d-8d8b-5dee6aa8377b/22f16b50d9cb0fb47dfbc2a8094f6224/dotnet-sdk-3.1.111-win-x86.zip
