# .NET Core 3.1.5 - June 9, 2020

[.NET Core 3.1.5](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.5 and .NET Core SDK 3.1.105.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-315)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.105 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.105, the following command will show that you're running version `3.1.105` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4803](https://github.com/dotnet/core/issues/4803) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.6 | [3.1.301](3.1.301-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.105](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)
* [dotnet/aspnetcore](https://hub.docker.com/_/microsoft-dotnet-core-aspnet)

### Azure App Services

* .NET Core 3.1.5 is being deployed to Azure App Services and the deployment is expected to complete later in June 2020.

## .NET Core Lifecycle News

Alpine 3.12 and Centos 8 has been added as [supported OS](../3.1-supported-os.md) with this update of .NET Core 3.1.

## Changes in 3.1.5

.NET Core 3.1.5 release carries both security and non-security fixes.

### [CVE-2020-1108: .NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1108)

To comprehensively address CVE-2020-1108, Microsoft has released updates for .NET Core 2.1 and .NET Core 3.1. Customers who use any of these versions of .NET Core should install the latest version of .NET Core. See the [Release Notes](https://github.com/dotnet/announcements/issues/157) for the latest version numbers and instructions for updating .NET Core.

Microsoft is aware of a denial of service vulnerability which exists when .NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core web application. The vulnerability can be exploited remotely, without authentication. 

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the .NET Core application. The update addresses the vulnerability by correcting how the .NET Core web application handles web requests. 

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.5+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.5+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.5+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:3.1.5+label:servicing-approved)

### macOS Notarization Change
  Running "dotnet build" will generate dll instead of binary on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://docs.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, please use following:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.5.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.5.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.5.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.5.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.5.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.5.nupkg
Microsoft.DotNet.PlatformAbstractions | 3.1.5.nupkg
Microsoft.NET.HostModel | 3.1.5.nupkg
Microsoft.Extensions.DependencyModel | 3.1.5.nupkg
System.Threading.Tasks.Dataflow | 4.11.1.nupkg
System.Text.Json | 4.7.2.nupkg
System.Collections.Immutable | 1.7.1.nupkg
Microsoft.XmlSerializer.Generator | 2.2.1.nupkg
Microsoft.NETCore.Platforms | 3.1.1.nupkg
Microsoft.Bcl.AsyncInterfaces | 1.1.1.nupkg
System.Threading.Channels | 4.7.1.nupkg
System.Composition | 1.4.1.nupkg
System.Composition.Convention | 1.4.1.nupkg
System.Text.Encodings.Web | 4.7.1.nupkg
System.Text.Encoding.CodePages | 4.7.1.nupkg
System.Resources.Extensions | 4.7.1.nupkg
System.Reflection.MetadataLoadContext | 4.7.2.nupkg
System.Reflection.Metadata | 1.8.1.nupkg
System.Reflection.DispatchProxy | 4.7.1.nupkg
System.Composition.AttributedModel | 1.4.1.nupkg
System.Json | 4.7.1.nupkg
System.IO.Pipelines | 4.7.2.nupkg
System.Diagnostics.DiagnosticSource | 4.7.1.nupkg
System.Data.OleDb | 4.7.1.nupkg
System.Composition.TypedParts | 1.4.1.nupkg
System.Composition.Runtime | 1.4.1.nupkg
System.Composition.Hosting | 1.4.1.nupkg
System.Net.WebSockets.WebSocketProtocol | 4.7.1.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.5.nupkg
Microsoft.Extensions.Identity.Core | 3.1.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.5.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.5.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.5.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.5.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.5.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.5.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.5.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.5.nupkg
dotnet-sql-cache | 3.1.5.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.5.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.5.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.5.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.5.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.5.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.5.nupkg
Microsoft.AspNetCore.Metadata | 3.1.5.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.5.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.5.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.5.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.5.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.5.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.5.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.5.nupkg
Microsoft.AspNetCore.Owin | 3.1.5.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.5.nupkg
Microsoft.dotnet-openapi | 3.1.5.nupkg
Microsoft.AspNetCore.TestHost | 3.1.5.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.5.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.5.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.5.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.5.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.5.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.5.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.5.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.5.nupkg
Microsoft.AspNetCore.Authorization | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.5.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.5.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.5.nupkg
Microsoft.AspNetCore.Components | 3.1.5.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.5.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.5.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.5.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.5.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.5.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.5.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.5.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.5.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.5.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.5.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.5.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.5.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.5.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.5.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.5.nupkg
dotnet-svcutil.xmlserializer | 1.2.0.nupkg
System.Net.Http.WinHttpHandler | 4.7.2.nupkg
System.Net.Http.Json | 3.2.1.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.5.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.5.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.5.nupkg
Microsoft.NET.Sdk.Razor | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.5.nupkg
Microsoft.EntityFrameworkCore | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.5.nupkg
dotnet-ef | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.5.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.5.nupkg
Microsoft.Data.Sqlite.Core | 3.1.5.nupkg
Microsoft.Data.Sqlite | 3.1.5.nupkg
Microsoft.JSInterop | 3.1.5.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.5.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.5.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.5.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.5.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.5.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.5.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.5.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.5.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.5.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.5.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.5.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.5.nupkg
Microsoft.Extensions.WebEncoders | 3.1.5.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.5.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.5.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.5.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.5.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.5.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.Configuration | 3.1.5.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.5.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.5.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.5.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.5.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.5.nupkg
Microsoft.Extensions.Primitives | 3.1.5.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.5.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.5.nupkg
Microsoft.Extensions.Options | 3.1.5.nupkg
Microsoft.Extensions.ObjectPool | 3.1.5.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.5.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.5.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.5.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.5.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.5.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.5.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.Logging | 3.1.5.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.Localization | 3.1.5.nupkg
Microsoft.Extensions.Http.Polly | 3.1.5.nupkg
Microsoft.Extensions.Http | 3.1.5.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.5.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.5.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.5.nupkg
Microsoft.Extensions.Hosting | 3.1.5.nupkg
Microsoft.Extensions.Logging.Console | 3.1.5.nupkg
microsoft.build | 16.6.0.nupkg
microsoft.build.conversion.core | 16.6.0.nupkg
microsoft.build.engine | 16.6.0.nupkg
microsoft.build.framework | 16.6.0.nupkg
microsoft.build.runtime | 16.6.0.nupkg
microsoft.build.tasks.core | 16.6.0.nupkg
microsoft.build.utilities.core | 16.6.0.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.5/3.1.5.md
[snap-install]: 3.1.5-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.5-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-june-2020/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/



[//]: # ( Runtime 3.1.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/15132a5c-f0f4-4373-8b8b-b7e70834d899/cad479dda52359ad43956471274ec932/dotnet-runtime-3.1.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65291ed8-e931-4605-9d5a-265928a835d0/1a15d18655c8b260170117e9bd1a1cb7/dotnet-runtime-3.1.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb2d5114-feed-4dd9-aada-afe3784d2c1a/95e7bc1576e4344b3a1b101e3b4f763d/dotnet-runtime-3.1.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56f86fa0-834a-4397-94b4-d4331078c91f/7de4bc57ed6a5cd7dddcefeed7aa1fd6/dotnet-runtime-3.1.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d00eaeea-6d7b-4e73-9d96-c0234ed3b665/0d25d9d1aeaebdeef01d15370d5cd22b/dotnet-runtime-3.1.5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e6494006-4940-48ed-9c28-a91fd4cfafba/fd10e3e409d55ff15f43611db6f9ead0/dotnet-runtime-3.1.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1c0ee25-9bd5-48ef-96e9-33d3d8e52a7c/8cf1d5065aa5352b838c1c4278942dcf/dotnet-runtime-3.1.5-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49656370-10aa-4db6-858b-db9fb51a1797/45929f56c70c9c6b7d864e353dae84e1/dotnet-runtime-3.1.5-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/49b6cd90-d8d1-4ce8-a7c2-2f7dfd3bdd5c/618343672c8f8972704f12b3517ce912/dotnet-runtime-3.1.5-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d97cfaf4-b17f-46c7-9a11-7f0d25dfd8b0/f76d4fce8e38b289efb9403aab0a0c9f/dotnet-runtime-3.1.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bc76dfb3-3666-4dcb-9e29-79f0a4e5c727/3b1c6aa838db8d49d8de1cb65feae626/dotnet-runtime-3.1.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fcea8129-4de7-4842-aa80-42efb2e0f250/3205c15852a1b559659991236eca5ac5/dotnet-runtime-3.1.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/76a97b28-a754-456b-be6d-fbf82cc8a237/746ac1926d55f8e0827404a763a5c5c0/dotnet-runtime-3.1.5-win-x86.zip

[//]: # ( WindowsDesktop 3.1.5)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/86835fe4-93b5-4f4e-a7ad-c0b0532e407b/f4f2b1239f1203a05b9952028d54fc13/windowsdesktop-runtime-3.1.5-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/df7b90d9-b93e-4974-85ef-c1de418bc186/e380e58bbd8505ebaee6c3abb23baade/windowsdesktop-runtime-3.1.5-win-x86.exe

[//]: # ( ASP 3.1.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e519c5b-b434-4067-bc0b-bb38179f7e4f/80a840dc7fb2c4a065f442aea1d98516/aspnetcore-runtime-3.1.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91f02336-1852-421d-907f-4aeae252a15e/dbb20e3a176c38a569cbcaa5d1d5782b/aspnetcore-runtime-3.1.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/021b09b2-1de4-47f8-9dcb-183795e2ada3/4f823c9ab8b968f734eda54f7d40090e/aspnetcore-runtime-3.1.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8438f49c-a336-4846-87ae-b3badfb978ee/2b4d72e03ccd0e737657e0534f4e092c/aspnetcore-runtime-3.1.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6827d794-a218-4352-b3b3-a19ec773c975/e3e53bc2f20df220a29c6e09f74d8a00/aspnetcore-runtime-3.1.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d4a6ce4-7d9f-4087-bd06-23aa54d1b9ac/e6fb7592489a5d5a8a2801196509dd72/aspnetcore-runtime-3.1.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/c21c6919-1016-49b9-a99b-3d99fe489f3c/5e25370475eb6a891d883de77ebc4613/aspnetcore-runtime-3.1.5-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6818f1f7-75de-43e5-9202-2b328ca127f7/039edc4bab29e5af63ed618e59f82fad/aspnetcore-runtime-3.1.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b5d221a7-f799-4ac2-9da9-26855a6778c1/7eefcd7210b825b98c4ad14190075f70/aspnetcore-runtime-3.1.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c5f311ca-3ed2-4249-8e09-51ff15250836/dfbee818fd022129a60f290187215b2f/aspnetcore-runtime-3.1.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7e417328-ef5b-4584-96c6-feaadcb8da80/e5c2f428da51907d6a2c6abc35fa172a/aspnetcore-runtime-3.1.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7c30d3a1-f519-4167-b850-b9c49bf2aa0e/dbfa957a76a41a1e1795f59d400d4ccd/dotnet-hosting-3.1.5-win.exe

[//]: # ( SDK 3.1.105 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/52f61afc-0897-4bc7-abf4-f936f9c6f637/8fca0abb8c378a32d966c1b762524c0d/dotnet-sdk-3.1.105-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2de5fc2-1c17-4ea2-bf3f-77c404e9263e/f9c79b6067afc819656ba9f6e6a4ed73/dotnet-sdk-3.1.105-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b1f4dd66-4a78-49a4-bcb9-bf73bdfa39d9/d144548fecee7312f70c40eb0aac7c3b/dotnet-sdk-3.1.105-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37268c18-226d-436b-b13c-4b77b7f42140/17e8a85360206006a557d634d16713cd/dotnet-sdk-3.1.105-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/47a85fd5-0b13-4c18-a9a7-5cf2cc3038aa/4ce0adb969338364899237f6644ba0b2/dotnet-sdk-3.1.105-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14a67d5a-a425-4590-9a69-ba6046d9cd66/840237e0763f50caa1ad02fdd00c59f5/dotnet-sdk-3.1.105-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10ad68c5-250a-4d93-8350-d4039da5e188/82512828fe1a8909e09c50fc2320ef26/dotnet-sdk-3.1.105-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7caeeb16-d88b-4971-b60f-37ba6f1f363d/ee1b90a2f88dc80c467245376b7f3b1c/dotnet-sdk-3.1.105-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9aa47df1-aa7a-4f15-9a7a-1d6076e257cd/d6a65f8cf039676b505a630b4e70e5b3/dotnet-sdk-3.1.105-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3b50c65a-b098-4d9d-aa1c-b3b24d364e47/9af666cb3326428ada9aef5847cf58c6/dotnet-sdk-3.1.105-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e048019a-f9b0-4aaf-9808-4f30775bf160/b1e456c8022b1fa81afcefc13c648926/dotnet-sdk-3.1.105-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ff6f7f4f-589f-4456-ba1f-338876583888/d62d8cca47071eafe42e18863f7411c2/dotnet-sdk-3.1.105-win-x86.zip

[//]: # ( Symbols )
