# .NET 5.0 Known Issues

You may encounter the following known issues, which may include workarounds, mitigations or expected resolution timeframes.

## .NET Runtime

1. When reading from a NegotiateStream at EOF, the stream will throw rather than return 0 or -1. This is fixed in 5.0.1. It is tracked by [dotnet/runtime/pr #43741](https://github.com/dotnet/runtime/pull/43741).

## .NET SDK

1. New Angular templates created via the `dotnet new` CLI or the new project UI in VS may fail to build on the command line due to an issue with the `node-gyp` install. To workaround this issue, upgrade the version of the `node-sass` dependency in `ClientApp/package.json` to `5.0.0`.

2. When creating a new **C# desktop** application in Visual Studio 2019 version 16.8 (including Console App, Windows Forms App, or WPF App), the project will default to targeting the latest LTS SDK that is installed (e.g. .NET Core 3.1). To create a new .NET 5 project, you can either use the CLI, or create a new project in Visual Studio and immediately retarget to .NET 5 in the project properties. When you retarget from 3.1 to .NET 5.0, it is no longer necessary to append .WindowsDestkop to the SDK reference. Consider changing **Microsoft.NET.Sdk.WindowsDesktop** to just **Microsoft.NET.Sdk**. You can also modify this behavior by enabling the Visual Studio preview feature: "Show all .NET Core templates in the New Project dialog".

3.  Design time build failure and dependency node warning icons when targeting *netcoreapp2.1* and specifying a *RuntimeIdentifier* in the project file.  This is the default for Service Fabric projects.

   **Error experience**
   
   `Project is targeting runtime 'win7-x64' but did not resolve any runtime-specific packages for the 'Microsoft.NETCore.App' package. This runtime may not be supported by .NET Core.`
   
   **Workaround**
   
   Add a *Directory.Build.Targets* file with the following content

   ```xml
   <Project>
     <Target Name="EnsureNETCoreAppRuntime" />
   </Project>
   ```
4. dotnet new -i for a template uses NuGet restore to download the template package and this requires a `TargetFramework`.  The template engine defaults to `netcoreapp1.0` to restore the template.  This will trigger warning NETSDK1138 as that target framework is no longer supported but has no negative affect on the template download.

## Windows Forms

* `PropertyGrid` values are rendered at incorrect location.

     The issue is tracked in [dotnet/winforms#4593](https://github.com/dotnet/winforms/issues/4593) and is expected to be fixed in 5.0.5.

* It is impossible to specify an image for a `ListViewGroup` in the Designer using either `TitleImageIndex` or `TitleImageKey` properties.

