# System.Diagnostics

``` diff
 namespace System.Diagnostics {
-    public class Activity {
+    public class Activity : IDisposable {
+        public ActivityContext Context { get; }
+        public string DisplayName { get; set; }
+        public IEnumerable<ActivityEvent> Events { get; }
+        public bool IsAllDataRequested { get; set; }
+        public ActivityKind Kind { get; }
+        public IEnumerable<ActivityLink> Links { get; }
+        public ActivitySource Source { get; }
+        public IEnumerable<KeyValuePair<string, object>> TagObjects { get; }
+        public Activity AddEvent(ActivityEvent e);
+        public Activity AddTag(string key, object value);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public object GetCustomProperty(string propertyName);
+        public void SetCustomProperty(string propertyName, object propertyValue);
+        public Activity SetTag(string key, object value);
     }
+    public readonly struct ActivityContext : IEquatable<ActivityContext> {
+        public ActivityContext(ActivityTraceId traceId, ActivitySpanId spanId, ActivityTraceFlags traceFlags, string traceState = null, bool isRemote = false);
+        public bool IsRemote { get; }
+        public ActivitySpanId SpanId { get; }
+        public ActivityTraceFlags TraceFlags { get; }
+        public ActivityTraceId TraceId { get; }
+        public string TraceState { get; }
+        public bool Equals(ActivityContext value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityContext left, ActivityContext right);
+        public static bool operator !=(ActivityContext left, ActivityContext right);
+        public static ActivityContext Parse(string traceParent, string traceState);
+        public static bool TryParse(string traceParent, string traceState, out ActivityContext context);
+    }
+    public readonly struct ActivityCreationOptions<T> {
+        public ActivityKind Kind { get; }
+        public IEnumerable<ActivityLink> Links { get; }
+        public string Name { get; }
+        public T Parent { get; }
+        public ActivityTagsCollection SamplingTags { get; }
+        public ActivitySource Source { get; }
+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
+        public ActivityTraceId TraceId { get; }
+    }
+    public readonly struct ActivityEvent {
+        public ActivityEvent(string name);
+        public ActivityEvent(string name, DateTimeOffset timestamp = default(DateTimeOffset), ActivityTagsCollection tags = null);
+        public string Name { get; }
+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
+        public DateTimeOffset Timestamp { get; }
+    }
+    public enum ActivityKind {
+        Client = 2,
+        Consumer = 4,
+        Internal = 0,
+        Producer = 3,
+        Server = 1,
+    }
+    public readonly struct ActivityLink : IEquatable<ActivityLink> {
+        public ActivityLink(ActivityContext context, ActivityTagsCollection tags = null);
+        public ActivityContext Context { get; }
+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
+        public bool Equals(ActivityLink value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityLink left, ActivityLink right);
+        public static bool operator !=(ActivityLink left, ActivityLink right);
+    }
+    public sealed class ActivityListener : IDisposable {
+        public ActivityListener();
+        public Action<Activity> ActivityStarted { get; set; }
+        public Action<Activity> ActivityStopped { get; set; }
+        public SampleActivity<ActivityContext> Sample { get; set; }
+        public SampleActivity<string> SampleUsingParentId { get; set; }
+        public Func<ActivitySource, bool> ShouldListenTo { get; set; }
+        public void Dispose();
+    }
+    public enum ActivitySamplingResult {
+        AllData = 2,
+        AllDataAndRecorded = 3,
+        None = 0,
+        PropagationData = 1,
+    }
+    public sealed class ActivitySource : IDisposable {
+        public ActivitySource(string name, string version = "");
+        public string Name { get; }
+        public string Version { get; }
+        public static void AddActivityListener(ActivityListener listener);
+        public void Dispose();
+        public bool HasListeners();
+        public Activity StartActivity(string name, ActivityKind kind = ActivityKind.Internal);
+        public Activity StartActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
+        public Activity StartActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
+    }
+    public class ActivityTagsCollection : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IEnumerable, IEnumerable<KeyValuePair<string, object>> {
+        public ActivityTagsCollection();
+        public ActivityTagsCollection(IEnumerable<KeyValuePair<string, object>> list);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public ICollection<string> Keys { get; }
+        public object this[string key] { get; set; }
+        public ICollection<object> Values { get; }
+        public void Add(KeyValuePair<string, object> item);
+        public void Add(string key, object value);
+        public void Clear();
+        public bool Contains(KeyValuePair<string, object> item);
+        public bool ContainsKey(string key);
+        public void CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
+        public ActivityTagsCollection.Enumerator GetEnumerator();
+        public bool Remove(KeyValuePair<string, object> item);
+        public bool Remove(string key);
+        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public bool TryGetValue(string key, out object value);
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, object>> {
+            public KeyValuePair<string, object> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+        }
+    }
    public class Process : Component, IDisposable {
+        public static Process Start(string fileName, IEnumerable<string> arguments);
+        public Task WaitForExitAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
+    public delegate ActivitySamplingResult SampleActivity<T>(ref ActivityCreationOptions<T> options);
     public class StackFrame {
-        public StackFrame(bool fNeedFileInfo);
+        public StackFrame(bool needFileInfo);
-        public StackFrame(int skipFrames, bool fNeedFileInfo);
+        public StackFrame(int skipFrames, bool needFileInfo);
     }
 }
```

