# System.Globalization

``` diff
 namespace System.Globalization {
-    public class CompareInfo : IDeserializationCallback {
+    public sealed class CompareInfo : IDeserializationCallback {
-        public virtual string Name { get; }
+        public string Name { get; }
+        public int Compare(ReadOnlySpan<char> string1, ReadOnlySpan<char> string2, CompareOptions options = CompareOptions.None);
-        public virtual int Compare(string string1, int offset1, int length1, string string2, int offset2, int length2);
+        public int Compare(string string1, int offset1, int length1, string string2, int offset2, int length2);
-        public virtual int Compare(string string1, int offset1, int length1, string string2, int offset2, int length2, CompareOptions options);
+        public int Compare(string string1, int offset1, int length1, string string2, int offset2, int length2, CompareOptions options);
-        public virtual int Compare(string string1, int offset1, string string2, int offset2);
+        public int Compare(string string1, int offset1, string string2, int offset2);
-        public virtual int Compare(string string1, int offset1, string string2, int offset2, CompareOptions options);
+        public int Compare(string string1, int offset1, string string2, int offset2, CompareOptions options);
-        public virtual int Compare(string string1, string string2);
+        public int Compare(string string1, string string2);
-        public virtual int Compare(string string1, string string2, CompareOptions options);
+        public int Compare(string string1, string string2, CompareOptions options);
-        public virtual int GetHashCode(string source, CompareOptions options);
+        public int GetHashCode(string source, CompareOptions options);
+        public int GetSortKey(ReadOnlySpan<char> source, Span<byte> destination, CompareOptions options = CompareOptions.None);
-        public virtual SortKey GetSortKey(string source);
+        public SortKey GetSortKey(string source);
-        public virtual SortKey GetSortKey(string source, CompareOptions options);
+        public SortKey GetSortKey(string source, CompareOptions options);
+        public int GetSortKeyLength(ReadOnlySpan<char> source, CompareOptions options = CompareOptions.None);
+        public int IndexOf(ReadOnlySpan<char> source, ReadOnlySpan<char> value, CompareOptions options = CompareOptions.None);
+        public int IndexOf(ReadOnlySpan<char> source, ReadOnlySpan<char> value, CompareOptions options, out int matchLength);
+        public int IndexOf(ReadOnlySpan<char> source, Rune value, CompareOptions options = CompareOptions.None);
-        public virtual int IndexOf(string source, char value);
+        public int IndexOf(string source, char value);
-        public virtual int IndexOf(string source, char value, CompareOptions options);
+        public int IndexOf(string source, char value, CompareOptions options);
-        public virtual int IndexOf(string source, char value, int startIndex);
+        public int IndexOf(string source, char value, int startIndex);
-        public virtual int IndexOf(string source, char value, int startIndex, CompareOptions options);
+        public int IndexOf(string source, char value, int startIndex, CompareOptions options);
-        public virtual int IndexOf(string source, char value, int startIndex, int count);
+        public int IndexOf(string source, char value, int startIndex, int count);
-        public virtual int IndexOf(string source, char value, int startIndex, int count, CompareOptions options);
+        public int IndexOf(string source, char value, int startIndex, int count, CompareOptions options);
-        public virtual int IndexOf(string source, string value);
+        public int IndexOf(string source, string value);
-        public virtual int IndexOf(string source, string value, CompareOptions options);
+        public int IndexOf(string source, string value, CompareOptions options);
-        public virtual int IndexOf(string source, string value, int startIndex);
+        public int IndexOf(string source, string value, int startIndex);
-        public virtual int IndexOf(string source, string value, int startIndex, CompareOptions options);
+        public int IndexOf(string source, string value, int startIndex, CompareOptions options);
-        public virtual int IndexOf(string source, string value, int startIndex, int count);
+        public int IndexOf(string source, string value, int startIndex, int count);
-        public virtual int IndexOf(string source, string value, int startIndex, int count, CompareOptions options);
+        public int IndexOf(string source, string value, int startIndex, int count, CompareOptions options);
+        public bool IsPrefix(ReadOnlySpan<char> source, ReadOnlySpan<char> prefix, CompareOptions options = CompareOptions.None);
+        public bool IsPrefix(ReadOnlySpan<char> source, ReadOnlySpan<char> prefix, CompareOptions options, out int matchLength);
-        public virtual bool IsPrefix(string source, string prefix);
+        public bool IsPrefix(string source, string prefix);
-        public virtual bool IsPrefix(string source, string prefix, CompareOptions options);
+        public bool IsPrefix(string source, string prefix, CompareOptions options);
+        public static bool IsSortable(ReadOnlySpan<char> text);
+        public static bool IsSortable(Rune value);
+        public bool IsSuffix(ReadOnlySpan<char> source, ReadOnlySpan<char> suffix, CompareOptions options = CompareOptions.None);
+        public bool IsSuffix(ReadOnlySpan<char> source, ReadOnlySpan<char> suffix, CompareOptions options, out int matchLength);
-        public virtual bool IsSuffix(string source, string suffix);
+        public bool IsSuffix(string source, string suffix);
-        public virtual bool IsSuffix(string source, string suffix, CompareOptions options);
+        public bool IsSuffix(string source, string suffix, CompareOptions options);
+        public int LastIndexOf(ReadOnlySpan<char> source, ReadOnlySpan<char> value, CompareOptions options = CompareOptions.None);
+        public int LastIndexOf(ReadOnlySpan<char> source, ReadOnlySpan<char> value, CompareOptions options, out int matchLength);
+        public int LastIndexOf(ReadOnlySpan<char> source, Rune value, CompareOptions options = CompareOptions.None);
-        public virtual int LastIndexOf(string source, char value);
+        public int LastIndexOf(string source, char value);
-        public virtual int LastIndexOf(string source, char value, CompareOptions options);
+        public int LastIndexOf(string source, char value, CompareOptions options);
-        public virtual int LastIndexOf(string source, char value, int startIndex);
+        public int LastIndexOf(string source, char value, int startIndex);
-        public virtual int LastIndexOf(string source, char value, int startIndex, CompareOptions options);
+        public int LastIndexOf(string source, char value, int startIndex, CompareOptions options);
-        public virtual int LastIndexOf(string source, char value, int startIndex, int count);
+        public int LastIndexOf(string source, char value, int startIndex, int count);
-        public virtual int LastIndexOf(string source, char value, int startIndex, int count, CompareOptions options);
+        public int LastIndexOf(string source, char value, int startIndex, int count, CompareOptions options);
-        public virtual int LastIndexOf(string source, string value);
+        public int LastIndexOf(string source, string value);
-        public virtual int LastIndexOf(string source, string value, CompareOptions options);
+        public int LastIndexOf(string source, string value, CompareOptions options);
-        public virtual int LastIndexOf(string source, string value, int startIndex);
+        public int LastIndexOf(string source, string value, int startIndex);
-        public virtual int LastIndexOf(string source, string value, int startIndex, CompareOptions options);
+        public int LastIndexOf(string source, string value, int startIndex, CompareOptions options);
-        public virtual int LastIndexOf(string source, string value, int startIndex, int count);
+        public int LastIndexOf(string source, string value, int startIndex, int count);
-        public virtual int LastIndexOf(string source, string value, int startIndex, int count, CompareOptions options);
+        public int LastIndexOf(string source, string value, int startIndex, int count, CompareOptions options);
     }
     public class CultureInfo : ICloneable, IFormatProvider {
+        public static CultureInfo GetCultureInfo(string name, bool predefinedOnly);
     }
-    public class SortKey {
+    public sealed class SortKey {
-        public virtual byte[] KeyData { get; }
+        public byte[] KeyData { get; }
-        public virtual string OriginalString { get; }
+        public string OriginalString { get; }
     }
-    public class TextInfo : ICloneable, IDeserializationCallback {
+    public sealed class TextInfo : ICloneable, IDeserializationCallback {
-        public virtual int ANSICodePage { get; }
+        public int ANSICodePage { get; }
-        public virtual int EBCDICCodePage { get; }
+        public int EBCDICCodePage { get; }
-        public virtual string ListSeparator { get; set; }
+        public string ListSeparator { get; set; }
-        public virtual int MacCodePage { get; }
+        public int MacCodePage { get; }
-        public virtual int OEMCodePage { get; }
+        public int OEMCodePage { get; }
-        public virtual object Clone();
+        public object Clone();
-        public virtual char ToLower(char c);
+        public char ToLower(char c);
-        public virtual string ToLower(string str);
+        public string ToLower(string str);
-        public virtual char ToUpper(char c);
+        public char ToUpper(char c);
-        public virtual string ToUpper(string str);
+        public string ToUpper(string str);
     }
 }
```

