# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public static class BindConverter {
+        public static string FormatValue(short value, CultureInfo culture = null);
+        public static string FormatValue(short? value, CultureInfo culture = null);
+        public static bool TryConvertToNullableShort(object obj, CultureInfo culture, out short? value);
+        public static bool TryConvertToShort(object obj, CultureInfo culture, out short value);
     }
     public readonly struct ElementReference {
+        public ElementReference(string id, ElementReferenceContext context);
+        public ElementReferenceContext Context { get; }
     }
+    public abstract class ElementReferenceContext {
+        protected ElementReferenceContext();
+    }
+    public static class ElementReferenceExtensions {
+        public static ValueTask FocusAsync(this ElementReference elementReference);
+    }
     public readonly struct EventCallback {
+        public Task InvokeAsync();
     }
     public readonly struct EventCallback<TValue> {
+        public Task InvokeAsync();
     }
     public static class EventCallbackFactoryBinderExtensions {
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<short> setter, short existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<short?> setter, short? existingValue, CultureInfo culture = null);
     }
+    public interface IComponentActivator {
+        IComponent CreateInstance(Type componentType);
+    }
+    public class WebElementReferenceContext : ElementReferenceContext {
+        public WebElementReferenceContext(IJSRuntime jsRuntime);
+    }
 }
```

