# Microsoft.AspNetCore.Connections

``` diff
 namespace Microsoft.AspNetCore.Connections {
+    public abstract class BaseConnectionContext : IAsyncDisposable {
+        protected BaseConnectionContext();
+        public virtual CancellationToken ConnectionClosed { get; set; }
+        public abstract string ConnectionId { get; set; }
+        public abstract IFeatureCollection Features { get; }
+        public abstract IDictionary<object, object> Items { get; set; }
+        public virtual EndPoint LocalEndPoint { get; set; }
+        public virtual EndPoint RemoteEndPoint { get; set; }
+        public abstract void Abort();
+        public abstract void Abort(ConnectionAbortedException abortReason);
+        public virtual ValueTask DisposeAsync();
+    }
-    public abstract class ConnectionContext : IAsyncDisposable {
+    public abstract class ConnectionContext : BaseConnectionContext, IAsyncDisposable {
-        public virtual CancellationToken ConnectionClosed { get; set; }

-        public abstract string ConnectionId { get; set; }

-        public abstract IFeatureCollection Features { get; }

-        public abstract IDictionary<object, object> Items { get; set; }

-        public virtual EndPoint LocalEndPoint { get; set; }

-        public virtual EndPoint RemoteEndPoint { get; set; }

-        public virtual void Abort();
+        public override void Abort();
-        public virtual void Abort(ConnectionAbortedException abortReason);
+        public override void Abort(ConnectionAbortedException abortReason);
-        public virtual ValueTask DisposeAsync();

     }
     public class UriEndPoint : EndPoint {
+        public override string ToString();
     }
 }
```

