# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    public class BadHttpRequestException : IOException {
+        public BadHttpRequestException(string message);
+        public BadHttpRequestException(string message, Exception innerException);
+        public BadHttpRequestException(string message, int statusCode);
+        public BadHttpRequestException(string message, int statusCode, Exception innerException);
+        public int StatusCode { get; }
+    }
     public static class HttpMethods {
+        public static bool Equals(string methodA, string methodB);
+        public static string GetCanonicalizedValue(string method);
     }
+    public static class HttpProtocol {
+        public static readonly string Http10;
+        public static readonly string Http11;
+        public static readonly string Http2;
+        public static readonly string Http3;
+        public static string GetHttpProtocol(Version version);
+        public static bool IsHttp10(string protocol);
+        public static bool IsHttp11(string protocol);
+        public static bool IsHttp2(string protocol);
+        public static bool IsHttp3(string protocol);
+    }
+    public static class HttpRequestJsonExtensions {
+        public static bool HasJsonContentType(this HttpRequest request);
+        public static ValueTask<object> ReadFromJsonAsync(this HttpRequest request, Type type, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<object> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> ReadFromJsonAsync<TValue>(this HttpRequest request, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public static class HttpResponseJsonExtensions {
+        public static Task WriteAsJsonAsync(this HttpResponse response, object value, Type type, JsonSerializerOptions options, string contentType, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync(this HttpResponse response, object value, Type type, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync(this HttpResponse response, object value, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions options, string contentType, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
+    }
 }
```

