# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public enum AddressFamily {
+        ControllerAreaNetwork = 65537,
+        Packet = 65536,
     }
     public class NetworkStream : Stream {
-        protected Socket Socket { get; }
+        public Socket Socket { get; }
     }
     public enum ProtocolFamily {
+        ControllerAreaNetwork = 65537,
+        Packet = 65536,
     }
+    public sealed class SafeSocketHandle : SafeHandleMinusOneIsInvalid {
+        public SafeSocketHandle(IntPtr preexistingHandle, bool ownsHandle);
+        protected override bool ReleaseHandle();
+    }
     public class SendPacketsElement {
+        public SendPacketsElement(FileStream fileStream);
+        public SendPacketsElement(FileStream fileStream, long offset, int count);
+        public SendPacketsElement(FileStream fileStream, long offset, int count, bool endOfPacket);
+        public SendPacketsElement(string filepath, long offset, int count);
+        public SendPacketsElement(string filepath, long offset, int count, bool endOfPacket);
+        public FileStream FileStream { get; }
+        public long OffsetLong { get; }
     }
     public class Socket : IDisposable {
+        public Socket(SafeSocketHandle handle);
+        public static bool OSSupportsUnixDomainSockets { get; }
+        public SafeSocketHandle SafeHandle { get; }
+        public int GetRawSocketOption(int optionLevel, int optionName, Span<byte> optionValue);
+        public void Listen();
+        public void SetRawSocketOption(int optionLevel, int optionName, ReadOnlySpan<byte> optionValue);
     }
     public class SocketAsyncEventArgs : EventArgs, IDisposable {
+        public SocketAsyncEventArgs(bool unsafeSuppressExecutionContextFlow);
     }
     public enum SocketOptionName {
+        TcpKeepAliveInterval = 17,
+        TcpKeepAliveRetryCount = 16,
+        TcpKeepAliveTime = 3,
     }
     public static class SocketTaskExtensions {
+        public static ValueTask ConnectAsync(this Socket socket, EndPoint remoteEP, CancellationToken cancellationToken);
+        public static ValueTask ConnectAsync(this Socket socket, IPAddress address, int port, CancellationToken cancellationToken);
+        public static ValueTask ConnectAsync(this Socket socket, IPAddress[] addresses, int port, CancellationToken cancellationToken);
+        public static ValueTask ConnectAsync(this Socket socket, string host, int port, CancellationToken cancellationToken);
     }
     public class TcpClient : IDisposable {
+        public ValueTask ConnectAsync(IPAddress address, int port, CancellationToken cancellationToken);
+        public ValueTask ConnectAsync(IPAddress[] addresses, int port, CancellationToken cancellationToken);
+        public ValueTask ConnectAsync(string host, int port, CancellationToken cancellationToken);
     }
 }
```

