# System.Net

``` diff
 namespace System.Net {
-    public class CookieCollection : ICollection, IEnumerable {
+    public class CookieCollection : ICollection, ICollection<Cookie>, IEnumerable, IEnumerable<Cookie>, IReadOnlyCollection<Cookie> {
+        public void Clear();
+        public bool Contains(Cookie cookie);
+        public bool Remove(Cookie cookie);
+        IEnumerator<Cookie> System.Collections.Generic.IEnumerable<System.Net.Cookie>.GetEnumerator();
     }
     public enum DecompressionMethods {
+        All = -1,
+        Brotli = 4,
     }
     public class FtpWebResponse : WebResponse, IDisposable {
-        public override string ContentType { get; }

     }
     public class IPAddress {
-        public static IPAddress Parse(ReadOnlySpan<char> ipString);
+        public static IPAddress Parse(ReadOnlySpan<char> ipSpan);
-        public static bool TryParse(ReadOnlySpan<char> ipString, out IPAddress address);
+        public static bool TryParse(ReadOnlySpan<char> ipSpan, out IPAddress address);
     }
     public class IPEndPoint : EndPoint {
+        public static IPEndPoint Parse(ReadOnlySpan<char> s);
+        public static IPEndPoint Parse(string s);
+        public static bool TryParse(ReadOnlySpan<char> s, out IPEndPoint result);
+        public static bool TryParse(string s, out IPEndPoint result);
     }
     public class NetworkCredential : ICredentials, ICredentialsByHost {
-        public NetworkCredential GetCredential(Uri uri, string authType);
+        public NetworkCredential GetCredential(Uri uri, string authenticationType);
     }
     public enum SecurityProtocolType {
+        Tls13 = 12288,
     }
     public class WebClient : Component {
+        public bool AllowReadStreamBuffering { get; set; }
+        public bool AllowWriteStreamBuffering { get; set; }
+        public event WriteStreamClosedEventHandler WriteStreamClosed;
+        protected virtual void OnWriteStreamClosed(WriteStreamClosedEventArgs e);
     }
     public class WebHeaderCollection : NameValueCollection, IEnumerable, ISerializable {
-        public new string this[string name] { get; set; }

     }
+    public class WriteStreamClosedEventArgs : EventArgs {
+        public WriteStreamClosedEventArgs();
+        public Exception Error { get; }
+    }
+    public delegate void WriteStreamClosedEventHandler(object sender, WriteStreamClosedEventArgs e);
 }
```

