# System.Reflection

``` diff
 namespace System.Reflection {
     public abstract class Assembly : ICustomAttributeProvider, ISerializable {
+        public virtual bool IsCollectible { get; }
     }
+    public static class AssemblyExtensions {
+        public static Type[] GetExportedTypes(this Assembly assembly);
+        public static Module[] GetModules(this Assembly assembly);
+        public static Type[] GetTypes(this Assembly assembly);
+    }
+    public enum AssemblyFlags {
+        ContentTypeMask = 3584,
+        DisableJitCompileOptimizer = 16384,
+        EnableJitCompileTracking = 32768,
+        PublicKey = 1,
+        Retargetable = 256,
+        WindowsRuntime = 512,
+    }
+    public enum AssemblyHashAlgorithm {
+        MD5 = 32771,
+        None = 0,
+        Sha1 = 32772,
+        Sha256 = 32780,
+        Sha384 = 32781,
+        Sha512 = 32782,
+    }
     public class CustomAttributeData {
-        public Type AttributeType { get; }
+        public virtual Type AttributeType { get; }
     }
-    public struct CustomAttributeNamedArgument
+    public readonly struct CustomAttributeNamedArgument
-    public struct CustomAttributeTypedArgument
+    public readonly struct CustomAttributeTypedArgument
+    public enum DeclarativeSecurityAction : short {
+        Assert = (short)3,
+        Demand = (short)2,
+        Deny = (short)4,
+        InheritanceDemand = (short)7,
+        LinkDemand = (short)6,
+        None = (short)0,
+        PermitOnly = (short)5,
+        RequestMinimum = (short)8,
+        RequestOptional = (short)9,
+        RequestRefuse = (short)10,
+    }
+    public static class EventInfoExtensions {
+        public static MethodInfo GetAddMethod(this EventInfo eventInfo);
+        public static MethodInfo GetAddMethod(this EventInfo eventInfo, bool nonPublic);
+        public static MethodInfo GetRaiseMethod(this EventInfo eventInfo);
+        public static MethodInfo GetRaiseMethod(this EventInfo eventInfo, bool nonPublic);
+        public static MethodInfo GetRemoveMethod(this EventInfo eventInfo);
+        public static MethodInfo GetRemoveMethod(this EventInfo eventInfo, bool nonPublic);
+    }
+    public interface ICustomTypeProvider {
+        Type GetCustomType();
+    }
+    public enum ManifestResourceAttributes {
+        Private = 2,
+        Public = 1,
+        VisibilityMask = 7,
+    }
     public abstract class MemberInfo : ICustomAttributeProvider {
+        public virtual bool IsCollectible { get; }
     }
+    public static class MemberInfoExtensions {
+        public static int GetMetadataToken(this MemberInfo member);
+        public static bool HasMetadataToken(this MemberInfo member);
+    }
     public enum MethodImplAttributes {
+        AggressiveOptimization = 512,
     }
+    public enum MethodImportAttributes : short {
+        BestFitMappingDisable = (short)32,
+        BestFitMappingEnable = (short)16,
+        BestFitMappingMask = (short)48,
+        CallingConventionCDecl = (short)512,
+        CallingConventionFastCall = (short)1280,
+        CallingConventionMask = (short)1792,
+        CallingConventionStdCall = (short)768,
+        CallingConventionThisCall = (short)1024,
+        CallingConventionWinApi = (short)256,
+        CharSetAnsi = (short)2,
+        CharSetAuto = (short)6,
+        CharSetMask = (short)6,
+        CharSetUnicode = (short)4,
+        ExactSpelling = (short)1,
+        None = (short)0,
+        SetLastError = (short)64,
+        ThrowOnUnmappableCharDisable = (short)8192,
+        ThrowOnUnmappableCharEnable = (short)4096,
+        ThrowOnUnmappableCharMask = (short)12288,
+    }
     public abstract class MethodInfo : MethodBase {
+        public T CreateDelegate<T>() where T : Delegate;
+        public T CreateDelegate<T>(object target) where T : Delegate;
     }
+    public static class MethodInfoExtensions {
+        public static MethodInfo GetBaseDefinition(this MethodInfo method);
+    }
+    public enum MethodSemanticsAttributes {
+        Adder = 8,
+        Getter = 2,
+        Other = 4,
+        Raiser = 32,
+        Remover = 16,
+        Setter = 1,
+    }
+    public static class ModuleExtensions {
+        public static Guid GetModuleVersionId(this Module module);
+        public static bool HasModuleVersionId(this Module module);
+    }
+    public static class PropertyInfoExtensions {
+        public static MethodInfo[] GetAccessors(this PropertyInfo property);
+        public static MethodInfo[] GetAccessors(this PropertyInfo property, bool nonPublic);
+        public static MethodInfo GetGetMethod(this PropertyInfo property);
+        public static MethodInfo GetGetMethod(this PropertyInfo property, bool nonPublic);
+        public static MethodInfo GetSetMethod(this PropertyInfo property);
+        public static MethodInfo GetSetMethod(this PropertyInfo property, bool nonPublic);
+    }
     public sealed class ReflectionTypeLoadException : SystemException, ISerializable {
+        public override string Message { get; }
+        public override string ToString();
     }
     public class TypeDelegator : TypeInfo {
+        public override bool IsCollectible { get; }
     }
+    public static class TypeExtensions {
+        public static ConstructorInfo GetConstructor(this Type type, Type[] types);
+        public static ConstructorInfo[] GetConstructors(this Type type);
+        public static ConstructorInfo[] GetConstructors(this Type type, BindingFlags bindingAttr);
+        public static MemberInfo[] GetDefaultMembers(this Type type);
+        public static EventInfo GetEvent(this Type type, string name);
+        public static EventInfo GetEvent(this Type type, string name, BindingFlags bindingAttr);
+        public static EventInfo[] GetEvents(this Type type);
+        public static EventInfo[] GetEvents(this Type type, BindingFlags bindingAttr);
+        public static FieldInfo GetField(this Type type, string name);
+        public static FieldInfo GetField(this Type type, string name, BindingFlags bindingAttr);
+        public static FieldInfo[] GetFields(this Type type);
+        public static FieldInfo[] GetFields(this Type type, BindingFlags bindingAttr);
+        public static Type[] GetGenericArguments(this Type type);
+        public static Type[] GetInterfaces(this Type type);
+        public static MemberInfo[] GetMember(this Type type, string name);
+        public static MemberInfo[] GetMember(this Type type, string name, BindingFlags bindingAttr);
+        public static MemberInfo[] GetMembers(this Type type);
+        public static MemberInfo[] GetMembers(this Type type, BindingFlags bindingAttr);
+        public static MethodInfo GetMethod(this Type type, string name);
+        public static MethodInfo GetMethod(this Type type, string name, BindingFlags bindingAttr);
+        public static MethodInfo GetMethod(this Type type, string name, Type[] types);
+        public static MethodInfo[] GetMethods(this Type type);
+        public static MethodInfo[] GetMethods(this Type type, BindingFlags bindingAttr);
+        public static Type GetNestedType(this Type type, string name, BindingFlags bindingAttr);
+        public static Type[] GetNestedTypes(this Type type, BindingFlags bindingAttr);
+        public static PropertyInfo[] GetProperties(this Type type);
+        public static PropertyInfo[] GetProperties(this Type type, BindingFlags bindingAttr);
+        public static PropertyInfo GetProperty(this Type type, string name);
+        public static PropertyInfo GetProperty(this Type type, string name, BindingFlags bindingAttr);
+        public static PropertyInfo GetProperty(this Type type, string name, Type returnType);
+        public static PropertyInfo GetProperty(this Type type, string name, Type returnType, Type[] types);
+        public static bool IsAssignableFrom(this Type type, Type c);
+        public static bool IsInstanceOfType(this Type type, object o);
+    }
 }
```

