# System

``` diff
 namespace System {
     public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable {
+        public Decimal(ReadOnlySpan<int> bits);
+        public static int GetBits(Decimal d, Span<int> destination);
+        public static bool TryGetBits(Decimal d, Span<int> destination, out int valuesWritten);
     }
     public static class MemoryExtensions {
+        public static void Sort<T, TComparer>(this Span<T> span, TComparer comparer) where TComparer : IComparer<T>;
+        public static void Sort<T>(this Span<T> span);
+        public static void Sort<T>(this Span<T> span, Comparison<T> comparison);
+        public static void Sort<TKey, TValue, TComparer>(this Span<TKey> keys, Span<TValue> items, TComparer comparer) where TComparer : IComparer<TKey>;
+        public static void Sort<TKey, TValue>(this Span<TKey> keys, Span<TValue> items);
+        public static void Sort<TKey, TValue>(this Span<TKey> keys, Span<TValue> items, Comparison<TKey> comparison);
     }
 }
```

