# System.Diagnostics

``` diff
 namespace System.Diagnostics {
-    public class Activity {
+    public class Activity : IDisposable {
+        public ActivityContext Context { get; }
+        public string DisplayName { get; set; }
+        public IEnumerable<ActivityEvent> Events { get; }
+        public bool IsAllDataRequested { get; set; }
+        public ActivityKind Kind { get; }
+        public IEnumerable<ActivityLink> Links { get; }
+        public ActivitySource Source { get; }
+        public Activity AddEvent(ActivityEvent e);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public object GetCustomProperty(string propertyName);
+        public void SetCustomProperty(string propertyName, object propertyValue);
     }
+    public readonly struct ActivityContext : IEquatable<ActivityContext> {
+        public ActivityContext(ActivityTraceId traceId, ActivitySpanId spanId, ActivityTraceFlags traceOptions, string traceState = null);
+        public ActivitySpanId SpanId { get; }
+        public ActivityTraceFlags TraceFlags { get; }
+        public ActivityTraceId TraceId { get; }
+        public string TraceState { get; }
+        public bool Equals(ActivityContext value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityContext left, ActivityContext right);
+        public static bool operator !=(ActivityContext left, ActivityContext right);
+    }
+    public readonly struct ActivityCreationOptions<T> {
+        public ActivityKind Kind { get; }
+        public IEnumerable<ActivityLink> Links { get; }
+        public string Name { get; }
+        public T Parent { get; }
+        public ActivitySource Source { get; }
+        public IEnumerable<KeyValuePair<string, string>> Tags { get; }
+    }
+    public enum ActivityDataRequest {
+        AllData = 2,
+        AllDataAndRecorded = 3,
+        None = 0,
+        PropagationData = 1,
+    }
+    public readonly struct ActivityEvent {
+        public ActivityEvent(string name);
+        public ActivityEvent(string name, IEnumerable<KeyValuePair<string, object>> attributes);
+        public ActivityEvent(string name, DateTimeOffset timestamp);
+        public ActivityEvent(string name, DateTimeOffset timestamp, IEnumerable<KeyValuePair<string, object>> attributes);
+        public IEnumerable<KeyValuePair<string, object>> Attributes { get; }
+        public string Name { get; }
+        public DateTimeOffset Timestamp { get; }
+    }
+    public enum ActivityKind {
+        Client = 2,
+        Consumer = 4,
+        Internal = 0,
+        Producer = 3,
+        Server = 1,
+    }
+    public readonly struct ActivityLink : IEquatable<ActivityLink> {
+        public ActivityLink(ActivityContext context);
+        public ActivityLink(ActivityContext context, IEnumerable<KeyValuePair<string, object>> attributes);
+        public IEnumerable<KeyValuePair<string, object>> Attributes { get; }
+        public ActivityContext Context { get; }
+        public bool Equals(ActivityLink value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityLink left, ActivityLink right);
+        public static bool operator !=(ActivityLink left, ActivityLink right);
+    }
+    public sealed class ActivityListener : IDisposable {
+        public ActivityListener();
+        public Action<Activity> ActivityStarted { get; set; }
+        public Action<Activity> ActivityStopped { get; set; }
+        public GetRequestedData<ActivityContext> GetRequestedDataUsingContext { get; set; }
+        public GetRequestedData<string> GetRequestedDataUsingParentId { get; set; }
+        public Func<ActivitySource, bool> ShouldListenTo { get; set; }
+        public void Dispose();
+    }
+    public sealed class ActivitySource : IDisposable {
+        public ActivitySource(string name, string version = "");
+        public string Name { get; }
+        public string Version { get; }
+        public static void AddActivityListener(ActivityListener listener);
+        public void Dispose();
+        public bool HasListeners();
+        public Activity StartActivity(string name, ActivityKind kind = ActivityKind.Internal);
+        public Activity StartActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, string>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
+        public Activity StartActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, string>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
+    }
+    public delegate ActivityDataRequest GetRequestedData<T>(ref ActivityCreationOptions<T> options);
 }
```

