# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
     public static class CookieExtensions {
+        public static AuthenticationBuilder AddCookie<TService>(this AuthenticationBuilder builder, Action<CookieAuthenticationOptions, TService> configureOptions) where TService : class;
+        public static AuthenticationBuilder AddCookie<TService>(this AuthenticationBuilder builder, string authenticationScheme, Action<CookieAuthenticationOptions, TService> configureOptions) where TService : class;
+        public static AuthenticationBuilder AddCookie<TService>(this AuthenticationBuilder builder, string authenticationScheme, string displayName, Action<CookieAuthenticationOptions, TService> configureOptions) where TService : class;
     }
     public static class HttpClientBuilderExtensions {
+        public static IHttpClientBuilder RedactLoggedHeaders(this IHttpClientBuilder builder, IEnumerable<string> redactedLoggedHeaderNames);
+        public static IHttpClientBuilder RedactLoggedHeaders(this IHttpClientBuilder builder, Func<string, bool> shouldRedactHeaderValue);
     }
     public static class HttpClientFactoryServiceCollectionExtensions {
+        public static IHttpClientBuilder AddHttpClient<TClient, TImplementation>(this IServiceCollection services, Func<HttpClient, IServiceProvider, TImplementation> factory) where TClient : class where TImplementation : class, TClient;
+        public static IHttpClientBuilder AddHttpClient<TClient, TImplementation>(this IServiceCollection services, Func<HttpClient, TImplementation> factory) where TClient : class where TImplementation : class, TClient;
+        public static IHttpClientBuilder AddHttpClient<TClient, TImplementation>(this IServiceCollection services, string name, Func<HttpClient, IServiceProvider, TImplementation> factory) where TClient : class where TImplementation : class, TClient;
+        public static IHttpClientBuilder AddHttpClient<TClient, TImplementation>(this IServiceCollection services, string name, Func<HttpClient, TImplementation> factory) where TClient : class where TImplementation : class, TClient;
     }
     public static class IdentityServiceCollectionExtensions {
+        public static IServiceCollection ConfigureApplicationCookie<TService>(this IServiceCollection services, Action<CookieAuthenticationOptions, TService> configure) where TService : class;
+        public static IServiceCollection ConfigureExternalCookie<TService>(this IServiceCollection services, Action<CookieAuthenticationOptions, TService> configure) where TService : class;
     }
     public static class OAuthExtensions {
+        public static AuthenticationBuilder AddOAuth<TOptions, THandler, TService>(this AuthenticationBuilder builder, string authenticationScheme, Action<TOptions, TService> configureOptions) where TOptions : OAuthOptions, new() where THandler : OAuthHandler<TOptions> where TService : class;
+        public static AuthenticationBuilder AddOAuth<TOptions, THandler, TService>(this AuthenticationBuilder builder, string authenticationScheme, string displayName, Action<TOptions, TService> configureOptions) where TOptions : OAuthOptions, new() where THandler : OAuthHandler<TOptions> where TService : class;
+        public static AuthenticationBuilder AddOAuth<TService>(this AuthenticationBuilder builder, string authenticationScheme, Action<OAuthOptions, TService> configureOptions) where TService : class;
+        public static AuthenticationBuilder AddOAuth<TService>(this AuthenticationBuilder builder, string authenticationScheme, string displayName, Action<OAuthOptions, TService> configureOptions) where TService : class;
     }
 }
```

