# System.Security.Cryptography.X509Certificates

``` diff
 namespace System.Security.Cryptography.X509Certificates {
     public sealed class CertificateRequest {
+        public X509Certificate2 Create(X500DistinguishedName issuerName, X509SignatureGenerator generator, DateTimeOffset notBefore, DateTimeOffset notAfter, ReadOnlySpan<byte> serialNumber);
+        public X509Certificate2 Create(X509Certificate2 issuerCertificate, DateTimeOffset notBefore, DateTimeOffset notAfter, ReadOnlySpan<byte> serialNumber);
     }
     public sealed class X500DistinguishedName : AsnEncodedData {
+        public X500DistinguishedName(ReadOnlySpan<byte> encodedDistinguishedName);
     }
     public class X509Certificate2 : X509Certificate {
+        public X509Certificate2(ReadOnlySpan<byte> rawData);
+        public X509Certificate2(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        public X509Certificate2(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        public static X509Certificate2 CreateFromEncryptedPem(ReadOnlySpan<char> certPem, ReadOnlySpan<char> keyPem, ReadOnlySpan<char> password);
+        public static X509Certificate2 CreateFromEncryptedPemFile(string certPemFilePath, ReadOnlySpan<char> password, string keyPemFilePath = null);
+        public static X509Certificate2 CreateFromPem(ReadOnlySpan<char> certPem, ReadOnlySpan<char> keyPem);
+        public static X509Certificate2 CreateFromPemFile(string certPemFilePath, string keyPemFilePath = null);
+        public static X509ContentType GetCertContentType(ReadOnlySpan<byte> rawData);
     }
     public class X509Certificate2Collection : X509CertificateCollection {
-        public void Import(byte[] rawData, string password, X509KeyStorageFlags keyStorageFlags);
+        public void Import(byte[] rawData, string password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        public void Import(ReadOnlySpan<byte> rawData);
+        public void Import(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        public void Import(ReadOnlySpan<byte> rawData, string password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        public void Import(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        public void Import(string fileName, string password, X509KeyStorageFlags keyStorageFlags);
+        public void Import(string fileName, string password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        public void ImportFromPem(ReadOnlySpan<char> certPem);
+        public void ImportFromPemFile(string certPemFilePath);
     }
     public class X509Extension : AsnEncodedData {
+        public X509Extension(Oid oid, ReadOnlySpan<byte> rawData, bool critical);
+        public X509Extension(string oid, ReadOnlySpan<byte> rawData, bool critical);
     }
     public sealed class X509SubjectKeyIdentifierExtension : X509Extension {
+        public X509SubjectKeyIdentifierExtension(ReadOnlySpan<byte> subjectKeyIdentifier, bool critical);
     }
 }
```

