# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public class AsnEncodedData {
+        public AsnEncodedData(ReadOnlySpan<byte> rawData);
+        public AsnEncodedData(Oid oid, ReadOnlySpan<byte> rawData);
+        public AsnEncodedData(string oid, ReadOnlySpan<byte> rawData);
     }
     public sealed class IncrementalHash : IDisposable {
+        public int HashLengthInBytes { get; }
+        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key);
+        public byte[] GetCurrentHash();
+        public int GetCurrentHash(Span<byte> destination);
+        public int GetHashAndReset(Span<byte> destination);
+        public bool TryGetCurrentHash(Span<byte> destination, out int bytesWritten);
     }
     public abstract class MD5 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA1 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA256 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA384 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA512 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
 }
```

