# System.Net

``` diff
 namespace System.Net {
     public static class HttpVersion {
-        public static readonly Version Version30;

     }
     public class IPAddress {
-        public static IPAddress Parse(ReadOnlySpan<char> ipString);
+        public static IPAddress Parse(ReadOnlySpan<char> ipSpan);
-        public static bool TryParse(ReadOnlySpan<char> ipString, out IPAddress address);
+        public static bool TryParse(ReadOnlySpan<char> ipSpan, out IPAddress address);
     }
     public class NetworkCredential : ICredentials, ICredentialsByHost {
-        public NetworkCredential GetCredential(Uri uri, string authType);
+        public NetworkCredential GetCredential(Uri uri, string authenticationType);
     }
+    public enum NetworkError {
+        ConnectionAborted = 6,
+        ConnectionRefused = 4,
+        ConnectionReset = 7,
+        EndPointInUse = 1,
+        HostNotFound = 2,
+        OperationAborted = 5,
+        Other = 0,
+        TimedOut = 3,
+    }
+    public class NetworkException : IOException {
+        public NetworkException(NetworkError error, Exception innerException = null);
+        protected NetworkException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public NetworkException(string message, NetworkError error, Exception innerException = null);
+        public NetworkError NetworkError { get; }
+    }
 }
```

