# System

``` diff
 namespace System {
-    public readonly struct ConsoleKeyInfo
+    public readonly struct ConsoleKeyInfo : IEquatable<ConsoleKeyInfo>
     public sealed class OperatingSystem : ICloneable, ISerializable {
+        public static bool IsAndroid();
+        public static bool IsAndroidVersionAtLeast(int major, int minor = 0, int build = 0, int revision = 0);
+        public static bool IsBrowser();
+        public static bool IsFreeBSD();
+        public static bool IsFreeBSDVersionAtLeast(int major, int minor = 0, int build = 0, int revision = 0);
+        public static bool IsIOS();
+        public static bool IsIOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsLinux();
+        public static bool IsMacOS();
+        public static bool IsMacOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsOSPlatform(string platform);
+        public static bool IsOSPlatformVersionAtLeast(string platform, int major, int minor = 0, int build = 0, int revision = 0);
+        public static bool IsTvOS();
+        public static bool IsTvOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsWatchOS();
+        public static bool IsWatchOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsWindows();
+        public static bool IsWindowsVersionAtLeast(int major, int minor = 0, int build = 0, int revision = 0);
     }
     public static class StringNormalizationExtensions {
-        public static bool IsNormalized(this string value);
+        public static bool IsNormalized(this string strInput);
-        public static bool IsNormalized(this string value, NormalizationForm normalizationForm);
+        public static bool IsNormalized(this string strInput, NormalizationForm normalizationForm);
-        public static string Normalize(this string value);
+        public static string Normalize(this string strInput);
-        public static string Normalize(this string value, NormalizationForm normalizationForm);
+        public static string Normalize(this string strInput, NormalizationForm normalizationForm);
     }
     public abstract class Type : MemberInfo, IReflect {
+        public bool IsAssignableTo(Type targetType);
     }
 }
```

