# .NET 6.0.0 Preview 3 - April 8, 2021

The .NET 6.0.0 Preview 3 and .NET SDK 6.0.100-preview.3.21202.5 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 Preview 3

.NET 6 is the next major release of .NET following .NET 5.0. You can see some of the new features available with .NET 6 Preview 3 at [dotnet/core #6141](https://github.com/dotnet/core/issues/6141).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 3.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](6.0.0-preview.3-install-instructions.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-preview.3.21202.5
```

### .NET Multi-Platform App UI Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET Multi-platform App UI](https://github.com/dotnet/maui). See [dotnet/net6-mobile-samples](https://github.com/dotnet/net6-mobile-samples) for additional setup instructions and sample projects you can run today.

|           | Android SDK Installer                        | iOS SDK Installer                 | Mac Catalyst SDK Installer                 | Mac Cocoa SDK Installer |
| --------- | :------------------------------------------:     | :----------------------:                 | :----------------------: | :----------------------: |
| Windows   | [x64][android-win] | [x64][ios-win]  | |
| macOS   | [x64][android-mac] | [x64][ios-mac]  | [x64][maccatalyst-mac]  | [x64][maccocoa-mac]  |

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.9 Preview 4](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 9.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #XXXX](https://github.com/dotnet/core/issues/XXXX) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/preview/6.0.0-preview.3.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.3-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-preview-3/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-preview-3
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-6-0-preview-3/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: 6.0.0-preview.3-install-instructions.md


[//]: # ( Runtime 6.0.0-preview.3.21201.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38227134-51b6-4275-bfa2-2c21ae2759d1/e8efe313494b4566762ea81f9d6c8495/dotnet-runtime-6.0.0-preview.3.21201.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbbc6b7c-d7c2-485b-a706-9e047a3f1eac/b194be59ddfd95cbc67d81a12b7753db/dotnet-runtime-6.0.0-preview.3.21201.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d906ec3f-d1db-4a8e-a80f-4103ceb74b78/b0966e846e06d434f2014d30961bc3f6/dotnet-runtime-6.0.0-preview.3.21201.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88c403c4-ab6a-453a-81a7-8f549350601d/d101984961ba75829f7c74afdb7ca176/dotnet-runtime-6.0.0-preview.3.21201.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee14de73-e734-4141-981c-0f724f1fadcb/db8c77ec1b0a3d2f89c9eb6594c52895/dotnet-runtime-6.0.0-preview.3.21201.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08d83899-a68e-486f-9dd6-b775bac12612/dd60b334b54191ba2b3821dc608a20af/dotnet-runtime-6.0.0-preview.3.21201.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/668c384c-9568-4261-9897-9d76a3d27e6f/60d295f764d49be02666ee1b46658a2e/dotnet-runtime-6.0.0-preview.3.21201.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e302306-3b57-4cd2-9886-c72aedaf51f9/68ac67f158bd663030b283b9ceb61ad0/dotnet-runtime-6.0.0-preview.3.21201.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e738a530-73a3-489a-8537-0b33e0084c38/c3c8697484a961efb8240ccddc5d22b3/dotnet-runtime-6.0.0-preview.3.21201.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b0ffd8c-781a-426d-ae29-48f602d2dc64/c129b2832dbb09ea92f11cc7d91bd714/dotnet-runtime-6.0.0-preview.3.21201.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4430f57-5598-4719-bb6e-affbb982823f/a3b8ec83a38592427d213c271bcf7131/dotnet-runtime-6.0.0-preview.3.21201.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5e3dad28-b04c-453c-a181-1f3986965307/d334ec9b386940cd6ba98558224866fc/dotnet-runtime-6.0.0-preview.3.21201.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/52a92f97-170d-4191-83ca-4ee49541efd8/e3c16206b362793154882032b1c35182/dotnet-runtime-6.0.0-preview.3.21201.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/22f3cbeb-0b64-47cf-828a-f6d2c8aa590a/e869b8cfa54261e7b558336c7d15459c/dotnet-runtime-6.0.0-preview.3.21201.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a1c31110-3f08-47bf-8f95-6f4d859b7111/53997c671882b0b6d717db049b69064a/dotnet-runtime-6.0.0-preview.3.21201.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/68448843-f04b-4d24-8d7e-fced3808ffe5/5e2f4fb35216b30c82256f91b5641ad0/dotnet-runtime-6.0.0-preview.3.21201.4-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-preview.3.21201.3)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9be73a62-9883-47e8-91a0-a833c32e1aba/77ba509610544a66723c7482d3936d7e/windowsdesktop-runtime-6.0.0-preview.3.21201.3-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2dfd66cc-99ec-46e0-ae4f-06feb5ceebbb/bb1888a004a85863d0f7698d9f7338cd/windowsdesktop-runtime-6.0.0-preview.3.21201.3-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d3f90906-2bfc-45a9-9c4c-24d0a8ecbd77/defeb2d6ce4cb37b2dea45b81fe26e9a/windowsdesktop-runtime-6.0.0-preview.3.21201.3-win-x86.exe

[//]: # ( ASP 6.0.0-preview.3.21201.13)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f3fc6ad-ec33-4644-a809-efe11adf4329/0ce2b8a29ccc643077b90ea9c37896ba/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5171161-ffd4-4649-9076-e3a20b6543e4/f9b1a9eec1cfd642266c73da656da1d7/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f85254ee-722a-478a-90a4-1a09cd81bd71/6e33b8f885ea99d1df50e088d84cf733/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/402979cb-f5be-467f-9b93-5adeffeedde7/b797aae2daa1643fe7febd2e03bd4da3/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/738fc66b-c39c-4e1d-b7ea-c4e294586f31/7d31db580581c1b72a996c690237a302/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57235015-0fcd-4785-a550-8fce2b489f81/303184bd837591ec206d06dc64284c3b/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17bef64a-d738-411d-9132-2579a5d8cabf/a0cc5fc006b367a5ad7aab80686eb81f/aspnetcore-runtime-6.0.0-preview.3.21201.13-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64fd0e40-dff2-4a5f-b29e-349d02614c4d/6a2d6354ab864142a30a035a66bbb7bc/aspnetcore-runtime-6.0.0-preview.3.21201.13-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b1492fe1-7075-4fa6-9e45-ddbc956d201a/bf00c3c7a4eb890d660d8881bb38d597/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/57a2f5fe-9502-4151-9f4a-b3fec48ed788/b1b2bae7e69e93f60e10c2f870250943/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/92738d69-7960-4ccf-b65a-121c4bf40f27/95b02161057afd3cb086179d6bc3cd3e/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3a85d34b-9bfb-434d-ba5c-3ed802b130c1/a378712c3efcf70c0924bf586f65b64b/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a4a29248-788d-4433-8e8c-b202da2089ca/def28d8ae53f7685b4ed1c806fe3a5ff/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/9459be22-f27e-40c4-8d9d-fa6544e95fe8/3a004010feb44ef799cfd4d00911ea25/dotnet-hosting-6.0.0-preview.3.21201.13-win.exe

[//]: # ( SDK 6.0.100-preview.3.21202.5 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd2c0cea-b1b5-4de8-941b-2b53f94df021/51bdc3008f95104c1e5bf1cd7f34cf78/dotnet-sdk-6.0.100-preview.3.21202.5-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90d8a5e0-ed8f-430c-a66c-d17a096024a9/95d17428d5b0da3552c502eede9f7f05/dotnet-sdk-6.0.100-preview.3.21202.5-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5339978-0298-4665-8d9a-cb0454dfe116/672ce296d354b7995fd10d54325ea01a/dotnet-sdk-6.0.100-preview.3.21202.5-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10adb511-cdf4-46af-b5b4-f67821160cfd/6d21a0a6780ff701d00ba7289f7c6a52/dotnet-sdk-6.0.100-preview.3.21202.5-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33b34e51-8630-45a8-8b00-66d3e81c9b47/8d5e94a58f6de1f0eaddaa30719f90aa/dotnet-sdk-6.0.100-preview.3.21202.5-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd855e4d-b02a-4327-b218-7ab500ecff83/c7649b00ee20e30244b8b84ff9139c71/dotnet-sdk-6.0.100-preview.3.21202.5-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/02dcd2c6-0f75-4956-a122-c5b451fa4035/b552d35e21f57de32371aec70277f6c5/dotnet-sdk-6.0.100-preview.3.21202.5-linux-x64.zip
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/293e469c-7948-4fc9-9d10-d5d39662e19d/1ae28ceb225f19d9aa922ffa3febb872/dotnet-sdk-6.0.100-preview.3.21202.5-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0a3877f-1b66-4e60-81f5-9b5d0769f60d/432bc7949c2d5b15ce218bf62e93520a/dotnet-sdk-6.0.100-preview.3.21202.5-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fc5fdd1f-fb4c-4b88-a507-158204030320/98497ef248883404ff5b0604dda944fb/dotnet-sdk-6.0.100-preview.3.21202.5-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a09e6477-34fe-4c68-b25d-3a77caa24312/a8657b444dcbaa72271ea7e6d2185547/dotnet-sdk-6.0.100-preview.3.21202.5-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0cc68783-f0f3-408e-b644-d1fb17ab4d4b/daa49f9cd3ae092169d4cc1676e8806c/dotnet-sdk-6.0.100-preview.3.21202.5-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f97da6a0-48da-427f-9c1c-17b506df5451/da85f3aea217299c5de0f6d00e960773/dotnet-sdk-6.0.100-preview.3.21202.5-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f650c921-3ee9-4352-b743-a052e45d9ce7/99c5e001a48d243d27765d84c74f1e37/dotnet-sdk-6.0.100-preview.3.21202.5-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2f1a6d2a-b2db-4f17-9f0b-4c7b615151d6/8d5722e58964248cd45fbc230fb16865/dotnet-sdk-6.0.100-preview.3.21202.5-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9eb55af4-c748-4980-b456-0738149e5477/0a6eb5cfd271944ee357f292e9834942/dotnet-sdk-6.0.100-preview.3.21202.5-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0f099673-eed8-4924-bf22-c004adf01543/75f8964ad97750990c47f980b1a63726/dotnet-sdk-6.0.100-preview.3.21202.5-win-x86.zip

[//]: # ( Runtime 6.0.0-preview.3.21201.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38227134-51b6-4275-bfa2-2c21ae2759d1/e8efe313494b4566762ea81f9d6c8495/dotnet-runtime-6.0.0-preview.3.21201.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbbc6b7c-d7c2-485b-a706-9e047a3f1eac/b194be59ddfd95cbc67d81a12b7753db/dotnet-runtime-6.0.0-preview.3.21201.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d906ec3f-d1db-4a8e-a80f-4103ceb74b78/b0966e846e06d434f2014d30961bc3f6/dotnet-runtime-6.0.0-preview.3.21201.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88c403c4-ab6a-453a-81a7-8f549350601d/d101984961ba75829f7c74afdb7ca176/dotnet-runtime-6.0.0-preview.3.21201.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee14de73-e734-4141-981c-0f724f1fadcb/db8c77ec1b0a3d2f89c9eb6594c52895/dotnet-runtime-6.0.0-preview.3.21201.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08d83899-a68e-486f-9dd6-b775bac12612/dd60b334b54191ba2b3821dc608a20af/dotnet-runtime-6.0.0-preview.3.21201.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/668c384c-9568-4261-9897-9d76a3d27e6f/60d295f764d49be02666ee1b46658a2e/dotnet-runtime-6.0.0-preview.3.21201.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e302306-3b57-4cd2-9886-c72aedaf51f9/68ac67f158bd663030b283b9ceb61ad0/dotnet-runtime-6.0.0-preview.3.21201.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e738a530-73a3-489a-8537-0b33e0084c38/c3c8697484a961efb8240ccddc5d22b3/dotnet-runtime-6.0.0-preview.3.21201.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b0ffd8c-781a-426d-ae29-48f602d2dc64/c129b2832dbb09ea92f11cc7d91bd714/dotnet-runtime-6.0.0-preview.3.21201.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4430f57-5598-4719-bb6e-affbb982823f/a3b8ec83a38592427d213c271bcf7131/dotnet-runtime-6.0.0-preview.3.21201.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5e3dad28-b04c-453c-a181-1f3986965307/d334ec9b386940cd6ba98558224866fc/dotnet-runtime-6.0.0-preview.3.21201.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/52a92f97-170d-4191-83ca-4ee49541efd8/e3c16206b362793154882032b1c35182/dotnet-runtime-6.0.0-preview.3.21201.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/22f3cbeb-0b64-47cf-828a-f6d2c8aa590a/e869b8cfa54261e7b558336c7d15459c/dotnet-runtime-6.0.0-preview.3.21201.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a1c31110-3f08-47bf-8f95-6f4d859b7111/53997c671882b0b6d717db049b69064a/dotnet-runtime-6.0.0-preview.3.21201.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/68448843-f04b-4d24-8d7e-fced3808ffe5/5e2f4fb35216b30c82256f91b5641ad0/dotnet-runtime-6.0.0-preview.3.21201.4-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-preview.3.21201.3)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9be73a62-9883-47e8-91a0-a833c32e1aba/77ba509610544a66723c7482d3936d7e/windowsdesktop-runtime-6.0.0-preview.3.21201.3-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2dfd66cc-99ec-46e0-ae4f-06feb5ceebbb/bb1888a004a85863d0f7698d9f7338cd/windowsdesktop-runtime-6.0.0-preview.3.21201.3-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d3f90906-2bfc-45a9-9c4c-24d0a8ecbd77/defeb2d6ce4cb37b2dea45b81fe26e9a/windowsdesktop-runtime-6.0.0-preview.3.21201.3-win-x86.exe

[//]: # ( ASP 6.0.0-preview.3.21201.13)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f3fc6ad-ec33-4644-a809-efe11adf4329/0ce2b8a29ccc643077b90ea9c37896ba/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5171161-ffd4-4649-9076-e3a20b6543e4/f9b1a9eec1cfd642266c73da656da1d7/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f85254ee-722a-478a-90a4-1a09cd81bd71/6e33b8f885ea99d1df50e088d84cf733/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/402979cb-f5be-467f-9b93-5adeffeedde7/b797aae2daa1643fe7febd2e03bd4da3/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/738fc66b-c39c-4e1d-b7ea-c4e294586f31/7d31db580581c1b72a996c690237a302/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57235015-0fcd-4785-a550-8fce2b489f81/303184bd837591ec206d06dc64284c3b/aspnetcore-runtime-6.0.0-preview.3.21201.13-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17bef64a-d738-411d-9132-2579a5d8cabf/a0cc5fc006b367a5ad7aab80686eb81f/aspnetcore-runtime-6.0.0-preview.3.21201.13-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64fd0e40-dff2-4a5f-b29e-349d02614c4d/6a2d6354ab864142a30a035a66bbb7bc/aspnetcore-runtime-6.0.0-preview.3.21201.13-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b1492fe1-7075-4fa6-9e45-ddbc956d201a/bf00c3c7a4eb890d660d8881bb38d597/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/57a2f5fe-9502-4151-9f4a-b3fec48ed788/b1b2bae7e69e93f60e10c2f870250943/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/92738d69-7960-4ccf-b65a-121c4bf40f27/95b02161057afd3cb086179d6bc3cd3e/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3a85d34b-9bfb-434d-ba5c-3ed802b130c1/a378712c3efcf70c0924bf586f65b64b/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a4a29248-788d-4433-8e8c-b202da2089ca/def28d8ae53f7685b4ed1c806fe3a5ff/aspnetcore-runtime-6.0.0-preview.3.21201.13-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/9459be22-f27e-40c4-8d9d-fa6544e95fe8/3a004010feb44ef799cfd4d00911ea25/dotnet-hosting-6.0.0-preview.3.21201.13-win.exe

[//]: # ( SDK 6.0.100-preview.3.21202.5 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd2c0cea-b1b5-4de8-941b-2b53f94df021/51bdc3008f95104c1e5bf1cd7f34cf78/dotnet-sdk-6.0.100-preview.3.21202.5-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90d8a5e0-ed8f-430c-a66c-d17a096024a9/95d17428d5b0da3552c502eede9f7f05/dotnet-sdk-6.0.100-preview.3.21202.5-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5339978-0298-4665-8d9a-cb0454dfe116/672ce296d354b7995fd10d54325ea01a/dotnet-sdk-6.0.100-preview.3.21202.5-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10adb511-cdf4-46af-b5b4-f67821160cfd/6d21a0a6780ff701d00ba7289f7c6a52/dotnet-sdk-6.0.100-preview.3.21202.5-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33b34e51-8630-45a8-8b00-66d3e81c9b47/8d5e94a58f6de1f0eaddaa30719f90aa/dotnet-sdk-6.0.100-preview.3.21202.5-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd855e4d-b02a-4327-b218-7ab500ecff83/c7649b00ee20e30244b8b84ff9139c71/dotnet-sdk-6.0.100-preview.3.21202.5-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/02dcd2c6-0f75-4956-a122-c5b451fa4035/b552d35e21f57de32371aec70277f6c5/dotnet-sdk-6.0.100-preview.3.21202.5-linux-x64.zip
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/293e469c-7948-4fc9-9d10-d5d39662e19d/1ae28ceb225f19d9aa922ffa3febb872/dotnet-sdk-6.0.100-preview.3.21202.5-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0a3877f-1b66-4e60-81f5-9b5d0769f60d/432bc7949c2d5b15ce218bf62e93520a/dotnet-sdk-6.0.100-preview.3.21202.5-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fc5fdd1f-fb4c-4b88-a507-158204030320/98497ef248883404ff5b0604dda944fb/dotnet-sdk-6.0.100-preview.3.21202.5-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a09e6477-34fe-4c68-b25d-3a77caa24312/a8657b444dcbaa72271ea7e6d2185547/dotnet-sdk-6.0.100-preview.3.21202.5-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0cc68783-f0f3-408e-b644-d1fb17ab4d4b/daa49f9cd3ae092169d4cc1676e8806c/dotnet-sdk-6.0.100-preview.3.21202.5-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f97da6a0-48da-427f-9c1c-17b506df5451/da85f3aea217299c5de0f6d00e960773/dotnet-sdk-6.0.100-preview.3.21202.5-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f650c921-3ee9-4352-b743-a052e45d9ce7/99c5e001a48d243d27765d84c74f1e37/dotnet-sdk-6.0.100-preview.3.21202.5-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2f1a6d2a-b2db-4f17-9f0b-4c7b615151d6/8d5722e58964248cd45fbc230fb16865/dotnet-sdk-6.0.100-preview.3.21202.5-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9eb55af4-c748-4980-b456-0738149e5477/0a6eb5cfd271944ee357f292e9834942/dotnet-sdk-6.0.100-preview.3.21202.5-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0f099673-eed8-4924-bf22-c004adf01543/75f8964ad97750990c47f980b1a63726/dotnet-sdk-6.0.100-preview.3.21202.5-win-x86.zip

[//]: # ( MAUI )
[ios-win]:  https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview3/f68d4d9c2a342daf9eaad364ccbe252e009d3901/4623693/package/Microsoft.NET.Workload.iOS.14.4.100-preview.3.1326.msi
[ios-mac]: https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview3/f68d4d9c2a342daf9eaad364ccbe252e009d3901/4623693/package/notarized/Microsoft.iOS.Bundle.14.4.100-preview.3.1326.pkg
[maccatalyst-mac]: https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview3/f68d4d9c2a342daf9eaad364ccbe252e009d3901/4623693/package/notarized/Microsoft.MacCatalyst.Bundle.14.3.100-preview.3.471.pkg
[maccocoa-mac]: https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview3/f68d4d9c2a342daf9eaad364ccbe252e009d3901/4623693/package/notarized/Microsoft.macOS.Bundle.11.1.100-preview.3.1379.pkg
[android-win]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4624420/6.0.1xx-preview3/7d6cd1cde4182d7db2cfc5d0b55364c972b6d34f/Microsoft.NET.Workload.Android.11.0.200.196.msi
[android-mac]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4624420/6.0.1xx-preview3/7d6cd1cde4182d7db2cfc5d0b55364c972b6d34f/Microsoft.NET.Workload.Android-11.0.200-preview.3.196.pkg

[//]: # ( Symbols )
