# System.IO.Compression

``` diff
 namespace System.IO.Compression {
     public sealed class BrotliStream : Stream {
+        public override int ReadByte();
+        public override void WriteByte(byte value);
     }
     public enum CompressionLevel {
+        SmallestSize = 3,
     }
     public class DeflateStream : Stream {
-        public override IAsyncResult BeginWrite(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
-        public override int Read(byte[] array, int offset, int count);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override Task<int> ReadAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
-        public override void Write(byte[] array, int offset, int count);
+        public override void Write(byte[] buffer, int offset, int count);
-        public override Task WriteAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
     }
     public class GZipStream : Stream {
-        public override IAsyncResult BeginRead(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
-        public override IAsyncResult BeginWrite(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
-        public override int Read(byte[] array, int offset, int count);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override Task<int> ReadAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
-        public override void Write(byte[] array, int offset, int count);
+        public override void Write(byte[] buffer, int offset, int count);
-        public override Task WriteAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
     }
+    public sealed class ZLibStream : Stream {
+        public ZLibStream(Stream stream, CompressionLevel compressionLevel);
+        public ZLibStream(Stream stream, CompressionLevel compressionLevel, bool leaveOpen);
+        public ZLibStream(Stream stream, CompressionMode mode);
+        public ZLibStream(Stream stream, CompressionMode mode, bool leaveOpen);
+        public Stream BaseStream { get; }
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override void CopyTo(Stream destination, int bufferSize);
+        public override Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
+        protected override void Dispose(bool disposing);
+        public override ValueTask DisposeAsync();
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override int Read(Span<byte> buffer);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override void Write(ReadOnlySpan<byte> buffer);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteByte(byte value);
+    }
 }
```

