# System.IO

``` diff
 namespace System.IO {
     public class BinaryReader : IDisposable {
+        public virtual Half ReadHalf();
     }
     public class BinaryWriter : IAsyncDisposable, IDisposable {
+        public virtual void Write(Half value);
     }
     public sealed class BufferedStream : Stream {
-        public override int Read(byte[] array, int offset, int count);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override void Write(byte[] array, int offset, int count);
+        public override void Write(byte[] buffer, int offset, int count);
     }
     public class FileStream : Stream {
-        public override IAsyncResult BeginRead(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override IAsyncResult BeginWrite(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override int Read(byte[] array, int offset, int count);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override void Write(byte[] array, int offset, int count);
+        public override void Write(byte[] buffer, int offset, int count);
     }
     public class MemoryStream : Stream {
-        public override int Read(Span<byte> destination);
+        public override int Read(Span<byte> buffer);
-        public override ValueTask<int> ReadAsync(Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
-        public override void Write(ReadOnlySpan<byte> source);
+        public override void Write(ReadOnlySpan<byte> buffer);
-        public override ValueTask WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class Stream : MarshalByRefObject, IAsyncDisposable, IDisposable {
+        protected static void ValidateBufferArguments(byte[] buffer, int offset, int count);
+        protected static void ValidateCopyToArguments(Stream destination, int bufferSize);
     }
     public class UnmanagedMemoryStream : Stream {
-        public override int Read(Span<byte> destination);
+        public override int Read(Span<byte> buffer);
-        public override void Write(ReadOnlySpan<byte> source);
+        public override void Write(ReadOnlySpan<byte> buffer);
     }
 }
```

