# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public class NetworkStream : Stream {
-        public override IAsyncResult BeginRead(byte[] buffer, int offset, int size, AsyncCallback callback, object state);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int size, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override int Read(byte[] buffer, int offset, int size);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override Task<int> ReadAsync(byte[] buffer, int offset, int size, CancellationToken cancellationToken);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
-        public override void Write(byte[] buffer, int offset, int size);
+        public override void Write(byte[] buffer, int offset, int count);
-        public override Task WriteAsync(byte[] buffer, int offset, int size, CancellationToken cancellationToken);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
     }
     public sealed class SafeSocketHandle : SafeHandleMinusOneIsInvalid {
+        public SafeSocketHandle();
     }
     public class SendPacketsElement {
+        public SendPacketsElement(ReadOnlyMemory<byte> buffer);
+        public SendPacketsElement(ReadOnlyMemory<byte> buffer, bool endOfPacket);
+        public ReadOnlyMemory<byte>? MemoryBuffer { get; }
     }
     public class Socket : IDisposable {
+        public Task<Socket> AcceptAsync();
+        public Task<Socket> AcceptAsync(Socket acceptSocket);
+        public Task ConnectAsync(EndPoint remoteEP);
+        public ValueTask ConnectAsync(EndPoint remoteEP, CancellationToken cancellationToken);
+        public Task ConnectAsync(IPAddress address, int port);
+        public ValueTask ConnectAsync(IPAddress address, int port, CancellationToken cancellationToken);
+        public Task ConnectAsync(IPAddress[] addresses, int port);
+        public ValueTask ConnectAsync(IPAddress[] addresses, int port, CancellationToken cancellationToken);
+        public Task ConnectAsync(string host, int port);
+        public ValueTask ConnectAsync(string host, int port, CancellationToken cancellationToken);
+        public Task<int> ReceiveAsync(ArraySegment<byte> buffer, SocketFlags socketFlags);
+        public Task<int> ReceiveAsync(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags);
+        public ValueTask<int> ReceiveAsync(Memory<byte> buffer, SocketFlags socketFlags, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<SocketReceiveFromResult> ReceiveFromAsync(ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint);
+        public Task<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint);
+        public Task<int> SendAsync(ArraySegment<byte> buffer, SocketFlags socketFlags);
+        public Task<int> SendAsync(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags);
+        public ValueTask<int> SendAsync(ReadOnlyMemory<byte> buffer, SocketFlags socketFlags, CancellationToken cancellationToken = default(CancellationToken));
+        public void SendFile(string fileName, ReadOnlySpan<byte> preBuffer, ReadOnlySpan<byte> postBuffer, TransmitFileOptions flags);
+        public Task<int> SendToAsync(ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEP);
     }
     public class TcpClient : IDisposable {
+        public Task ConnectAsync(IPEndPoint remoteEP);
+        public ValueTask ConnectAsync(IPEndPoint remoteEP, CancellationToken cancellationToken);
     }
 }
```

