# System

``` diff
 namespace System {
     public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
+        public static object Parse(Type enumType, ReadOnlySpan<char> value);
+        public static object Parse(Type enumType, ReadOnlySpan<char> value, bool ignoreCase);
+        public static TEnum Parse<TEnum>(ReadOnlySpan<char> value) where TEnum : struct;
+        public static TEnum Parse<TEnum>(ReadOnlySpan<char> value, bool ignoreCase) where TEnum : struct;
+        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, bool ignoreCase, out object result);
+        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, out object result);
+        public static bool TryParse<TEnum>(ReadOnlySpan<char> value, bool ignoreCase, out TEnum result) where TEnum : struct;
+        public static bool TryParse<TEnum>(ReadOnlySpan<char> value, out TEnum result) where TEnum : struct;
     }
     public static class MemoryExtensions {
+        public static bool SequenceEqual<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other, IEqualityComparer<T> comparer = null);
+        public static bool SequenceEqual<T>(this Span<T> span, ReadOnlySpan<T> other, IEqualityComparer<T> comparer = null);
     }
 }
```

