# Microsoft.AspNetCore.HttpLogging

``` diff
+namespace Microsoft.AspNetCore.HttpLogging {
+    public enum HttpLoggingFields : long {
+        All = (long)3327,
+        None = (long)0,
+        Request = (long)1119,
+        RequestBody = (long)1024,
+        RequestHeaders = (long)64,
+        RequestMethod = (long)8,
+        RequestPath = (long)1,
+        RequestProperties = (long)31,
+        RequestPropertiesAndHeaders = (long)95,
+        RequestProtocol = (long)4,
+        RequestQuery = (long)2,
+        RequestScheme = (long)16,
+        RequestTrailers = (long)256,
+        Response = (long)2208,
+        ResponseBody = (long)2048,
+        ResponseHeaders = (long)128,
+        ResponsePropertiesAndHeaders = (long)160,
+        ResponseStatusCode = (long)32,
+        ResponseTrailers = (long)512,
+    }
+    public sealed class HttpLoggingOptions {
+        public HttpLoggingOptions();
+        public HttpLoggingFields LoggingFields { get; set; }
+        public MediaTypeOptions MediaTypeOptions { get; }
+        public int RequestBodyLogLimit { get; set; }
+        public ISet<string> RequestHeaders { get; }
+        public int ResponseBodyLogLimit { get; set; }
+        public ISet<string> ResponseHeaders { get; }
+    }
+    public sealed class MediaTypeOptions {
+        public void AddBinary(MediaTypeHeaderValue mediaType);
+        public void AddBinary(string contentType);
+        public void AddText(string contentType);
+        public void AddText(string contentType, Encoding encoding);
+        public void Clear();
+    }
+}
```

