# .NET Core 1.0.4 & 1.1.1 SDK 1.0.1

The installers and binary archives on this page include .NET Core 1.0.4 SDK 1.0.1. 

CheckSum files to verify downloads are available as follows:
* [Checksums_Shared_Framework](https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.0.4-1.1.1-sharedfx-SHA.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.0.1-SDK-SHA.txt) 

|                         | SDK Installer                                        | SDK Binaries                                        | Runtime Installer | Runtime Binaries |
| ----------------------- | :----------------------------------------------: | :----------------------------------------------:| :--: | :--: |
| Windows                 | [32-bit](https://go.microsoft.com/fwlink/?LinkID=843452) / [64-bit](https://go.microsoft.com/fwlink/?LinkID=843448)  | [32-bit](https://go.microsoft.com/fwlink/?LinkID=843458) / [64-bit](https://go.microsoft.com/fwlink/?LinkID=843454) | [32-bit](https://go.microsoft.com/fwlink/?LinkID=843417) / [64-bit](https://go.microsoft.com/fwlink/?LinkID=843412) | [32-bit](https://go.microsoft.com/fwlink/?LinkID=843407) / [64-bit](https://go.microsoft.com/fwlink/?LinkID=843402) |
| macOS                   | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843444)  | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843455)                          | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843401) | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843403) |
| CentOS 7.1              | -                                                         | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843449)                          | - | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843405) |
| Debian 8                | -                                                         | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843453)                          | - | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843409) |
| Ubuntu 14.04            |[64-bit](https://go.microsoft.com/fwlink/?LinkID=843445)   | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843450)                          |[64-bit](https://go.microsoft.com/fwlink/?LinkID=843408) | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843415) |
| Ubuntu 16.04            |[64-bit](https://go.microsoft.com/fwlink/?LinkID=843456)   | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843462)                          |[64-bit](https://go.microsoft.com/fwlink/?LinkID=843404) | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843410) |
| RHEL 7                  | -                                                         | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843459)                          | - | [64-bit](https://go.microsoft.com/fwlink/?LinkID=843406) |
## Installation from a binary archive

When using binary archives to install, we recommend the contents be extracted to `/opt/dotnet` and a symbolic link created for `dotnet`. If an earlier release of .NET Core is already installed, the directory and symbolic link may already exist. Ubuntu and Mint users should follow the instructions in the Ubuntu Installation section below.

```bash
sudo mkdir -p /opt/dotnet
sudo tar zxf [tar.gz filename] -C /opt/dotnet
sudo ln -s /opt/dotnet/dotnet /usr/local/bin
```

## Ubuntu installation

```
dotnet-host-ubuntu-x64.deb
dotnet-hostfxr-ubuntu-x64.deb
dotnet-sharedframework-ubuntu-x64.deb
dotnet-sdk-ubuntu-x64.1.0.1.deb
```

### Set up package source

The first step is to establish the source feed for the package manager. This is only needed if you have not previously set up the source or if you are installing for the first time.

#### Ubuntu 14.04 and Linux Mint 17

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-sdk-ubuntu-x64.1.0.1

```

Installed packages

```
dotnet-host-ubuntu-x64.1.0.1.deb
dotnet-hostfxr-ubuntu-x64.1.0.1.deb
dotnet-sharedframework-ubuntu-x64.1.0.4.deb
dotnet-sdk-ubuntu-x64.1.0.1.deb
```

#### Ubuntu 16.04 and Linux Mint 18

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-sdk-ubuntu-x64.1.0.1
```

Installed packages

```
dotnet-host-ubuntu.16.04-x64.1.0.1.deb
dotnet-hostfxr-ubuntu.16.04-x64.1.0.1.deb
dotnet-sharedframework-ubuntu.16.04-x64.1.0.4.deb
dotnet-sdk-ubuntu-x64.1.0.1.deb
```

## Windows Server Hosting
If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the [Windows (Server Hosting) installer](https://go.microsoft.com/fwlink/?LinkID=844461) and run the following command from an Administrator command prompt:


``DotNetCore.1.0.4_1.1.1-WindowsHosting.exe OPT_INSTALL_LTS_REDIST=0 OPT_INSTALL_FTS_REDIST=0``

