"""Tests for the deep sleep component."""


def test_deep_sleep_setup(generate_main):
    """
    When the deep sleep is set in the yaml file, it should be registered in main
    """
    main_cpp = generate_main(
        "tests/component_tests/deep_sleep/test_deep_sleep1.yaml"
    )

    assert "deepsleep = new deep_sleep::DeepSleepComponent();" in main_cpp
    assert "App.register_component(deepsleep);" in main_cpp


def test_deep_sleep_sleep_duration(generate_main):
    """
    When deep sleep is configured with sleep duration, it should be set.
    """
    main_cpp = generate_main(
        "tests/component_tests/deep_sleep/test_deep_sleep1.yaml"
    )

    assert "deepsleep->set_sleep_duration(60000);" in main_cpp


def test_deep_sleep_run_duration_simple(generate_main):
    """
    When deep sleep is configured with run duration, it should be set.
    """
    main_cpp = generate_main(
        "tests/component_tests/deep_sleep/test_deep_sleep1.yaml"
    )

    assert "deepsleep->set_run_duration(10000);" in main_cpp


def test_deep_sleep_run_duration_dictionary(generate_main):
    """
    When deep sleep is configured with dictionary run duration, it should be set.
    """
    main_cpp = generate_main(
        "tests/component_tests/deep_sleep/test_deep_sleep2.yaml"
    )

    assert (
        "deepsleep->set_run_duration(deep_sleep::WakeupCauseToRunDuration{\n"
        "    .default_cause = 10000,\n"
        "    .touch_cause = 10000,\n"
        "    .gpio_cause = 30000,\n"
        "});"
    ) in main_cpp
