![elabftw logo](https://i.imgur.com/hq6SAZf.png)

[Official website](https://www.elabftw.net) | [Live demo](https://demo.elabftw.net) | [Documentation](https://doc.elabftw.net)

[![CircleCI](https://circleci.com/gh/elabftw/elabftw/tree/master.svg?style=svg)](https://circleci.com/gh/elabftw/elabftw/tree/master)

[![Codacy Badge](https://api.codacy.com/project/badge/Grade/9942fbe6c6f14f488be69e51e93a1c10)](https://www.codacy.com/app/elabftw/elabftw)
[![Codeclimate](https://d3s6mut3hikguw.cloudfront.net/github/elabftw/elabftw/badges/gpa.svg)](https://codeclimate.com/github/elabftw/elabftw)
[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/elabftw/elabftw/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/elabftw/elabftw/?branch=master)
[![Join the chat at https://gitter.im/elabftw/elabftw](https://badges.gitter.im/elabftw/elabftw.svg)](https://gitter.im/elabftw/elabftw?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![License](https://img.shields.io/badge/license-AGPL-blue.svg)](https://www.gnu.org/licenses/agpl-3.0.en.html)
[![Release](https://img.shields.io/github/release/elabftw/elabftw.svg)](https://github.com/elabftw/elabftw/releases/latest)
[![StackShare](https://img.shields.io/badge/tech-stack-0690fa.svg?style=flat)](https://stackshare.io/elabftw/elabftw)
[![Joss](http://joss.theoj.org/papers/10.21105/joss.00146/status.svg)](http://joss.theoj.org/papers/10.21105/joss.00146)

# Description

- Tired of that shared excel file for your antibodies or plasmids ?

- Want to be able to search in your past experiments as easily as you'd do it on google ?

- Want an electronic lab notebook that lets you timestamp legally your experiments ?

Then you are at the right place !

**eLabFTW** is an electronic lab notebook manager for research teams. It also features a database where you can store any kind of objects (think antibodies, plasmids, cell lines, boxes, _etc_…)
It is accessed _via_ the browser by the users. Several research teams can be hosted on the same install, so **eLabFTW** can be installed at the institute level and host everyone at the same place (this is what is done at [Institut Curie](http://www.curie.fr) and in several other research centers around the globe).

Click the image below to see it in bigger size:
[![Demo gif](https://i.imgur.com/pH6Qvwf.gif)](https://gfycat.com/WillingIncompleteAstarte)

**eLabFTW** is designed to be installed on a server, and people from the team would just log into it from their browser.

![server client](https://i.imgur.com/BcfFgQS.gif)

Don't have a server ? That's okay, you can use an old computer with 1 Go of RAM and an old CPU, it's more than enough. Just install a recent GNU/Linux distribution on it and plug it to the intranet.

# Installation

**eLabFTW** can easily be installed on any GNU/Linux server. It requires 512 Mo of RAM (1 Go recommended) and 300 Mo of disk space minimum. It is installed with Docker, so you will also need to have [Docker](https://www.docker.com/) installed. Because it runs in a Docker container, you don't have to install php, a webserver or mysql on your server, you also don't need to worry about which version will work or which extension you need. Everything is provided by the container.

The documentation explains everything:

## [Installation instructions](https://doc.elabftw.net)

# Contributing

**eLabFTW** is a collaborative project. See the [contributing page](https://doc.elabftw.net/contributing.html).

If you've found a security issue, please report it by email to the address associated to my GPG key:

~~~bash
gpg --search-keys "Nicolas CARPi"
~~~

# Support

Please [open a GitHub issue](https://github.com/elabftw/elabftw/issues/new) if you have a problem, want to make a suggestion, ask a question or discuss a feature.

[Subscribe to the newsletter](http://eepurl.com/bTjcMj) to be warned when a new release is out!

# Funding

This project is sponsored by [Institut Curie](https://science.curie.fr/).

Thank you for using **eLabFTW**, I hope it will bring happiness in your lab ;)
