---
title: Apache Mesos - Committer Candidate Checklist
layout: documentation
---

# Apache Mesos Committer Candidate Checklist

This document contains categories of contributions and behaviors relevant to becoming an Apache Mesos  committer. As a committer candidate you can use a copy of this list to collect and aggregate data on what you have achieved so far. Neither is this an exhaustive list nor do all categories need to be addressed, since there can be reasonably diverse committer profiles. But some categories are always crucial to have covered, e.g., writing high quality source code and performing meaningful code reviews. Eventually, your nominator can hand in your filled-out variant of this list to the PMC to facilitate their reviewing your case.

* Candidate name: <input type="text"/>

* JIRA user name: <input type="text"/>

* Github user name: <input type="text"/>

* Reviewboard user name: <input type="text"/>

* Nominator: <input type="text"/>

* Understanding of the Apache philosophy ([The Apache Way](http://theapacheway.com)).
Demonstrated by: <input type="text"/>

* Understanding of the Mesos project's goals.
Demonstrated by: <input type="text"/>

* Commitment to the Mesos project.
Demonstrated by: <input type="text"/>

* Knowledge and activity breadth and depth in the Mesos project as well as areas where the candidate could be a maintainer:
<input type="text"/>

* Can the candidate be trusted to act the right way outside of known areas where he/she has already demonstrated committer-level expertise and behavior:
<input type="text"/>

* High quality source code.
A committer vouches that the candidate writes high-quality, "readable" code, adhering to Mesos style and best practices standards, both formal and informal.
Name of the committer: <input type="text"/>

* Community participation.
    + IRC: <input type="text"/>
    + dev mailing list: <input type="text"/>
    + user mailing list: <input type="text"/>
    + JIRA comments: <input type="text"/>
    + Stack Overflow: <input type="text"/>
    + Quora: <input type="text"/>
    + Developer Community Sync Meetings: <input type="text"/>
    + Release votes: <input type="text"/>
    + Documentation added: <input type="text"/>
    + Other: <input type="text"/>

* General comments on community engagement: <input type="text"/>

* Helping new contributors: <input type="text"/>

* Presentations at meetups, conferences, etc.: <input type="text"/>

* Reviews catching functionality issues.
List reviews and a committer for each as witness: <input type="text"/>

* Reviews catching style issues.
List reviews and a committer for each as witness: <input type="text"/>

* Major source code contribution.
Description of the contribution: <input type="text"/>

* JIRA tickets created.
List initiated JIRA tickets (or an equivalent JIRA query and count/summary): <input type="text"/>

* JIRA tickets completed.
List resolved JIRA tickets and committed review requests (or an equivalent JIRA query and count/summary): <input type="text"/>

* Evidence of testing as a priority:
A simple metric could be <#tests written> / <#testable tickets>. Or you could detail a particularly complex set of unit tests you had to write. Or explain how you have improved the project's testing infrastructure or best practices.
NOTE: These are just suggestions for documenting testing efforts. The ultimate goal here is convincingly corroborating that all contributed source code is adequately covered by tests.

* Initiated design documents: <input type="text"/>

* Reviewed design documents: <input type="text"/>

* Contributions to Documentation: <input type="text"/>

* Dependability.
Issues quickly / immediately solved that arose out of own contributions: <input type="text"/>
