---
title: Apache Mesos - Committers
layout: documentation
---

# Committers

An Apache Mesos committer is a contributor who has been given write access to the Apache Mesos code repository and related Apache infrastructure. In the Mesos project, each committer is also a voting member of the PMC.

## Becoming a committer

Every new committer has to be proposed by a current committer and then voted in by the members of the Mesos PMC. For details about this process and for candidate requirements see the general [Apache guidelines for assessing new candidates for committership](https://community.apache.org/newcommitter.html). Candidates prepare for their nomination as committer by contributing to the Mesos project and its community, by acting according to the [Apache Way](http://theapacheway.com), and by generally following the path [from contributor to committer](https://community.apache.org/contributors/) for Apache projects. Specifically for the Mesos project, you can make use of the [Apache Mesos Committer Candidate Checklist](committer-candidate-checklist.md) for suggestions of what kind of contributions and demonstrated behaviors can be instrumental, and to keep track of your progress.

## Current Committers

We'd like to thank the following committers to the Apache Mesos project who have helped get the project to where it is today. This list might be stale, the canonical list is located on [Apache's website](http://people.apache.org/committers-by-project.html#mesos).

<table class="table table-hover table-condensed">
  <thead>
    <tr>
      <th>Timezone GMT</th>
      <th>Full Name</th>
      <th>Company/Organization</th>
      <th>IRC Handle</th>
      <th>Email Address</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>-8</td>
      <td>Ross Allen</td>
      <td>Facebook</td>
      <td></td>
      <td>ssorallen@apache.org</td>
    </tr>
    <tr>
      <td>-5</td>
      <td>Kapil Arya</td>
      <td>Mesosphere / Northeastern University</td>
      <td></td>
      <td>kapil@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Adam B</td>
      <td>Mesosphere</td>
      <td>adam-mesos</td>
      <td>me@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Tim Chen</td>
      <td>Mesosphere</td>
      <td>tnachen</td>
      <td>tnachen@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Ian Downes</td>
      <td>Twitter</td>
      <td>idownes</td>
      <td>idownes@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Ali Ghodsi</td>
      <td>UC Berkeley</td>
      <td></td>
      <td>alig@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Dominic Hamon</td>
      <td>YouTube</td>
      <td></td>
      <td>dma@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Benjamin Hindman</td>
      <td>Mesosphere</td>
      <td>_benh_</td>
      <td>benh@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Ian Holsman</td>
      <td></td>
      <td></td>
      <td>ianh@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Vinod Kone</td>
      <td>Mesosphere</td>
      <td>vinodkone</td>
      <td>vinodkone@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Andy Konwinski</td>
      <td>Databricks</td>
      <td></td>
      <td>andrew@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Dave Lester</td>
      <td>Apple</td>
      <td>dlester</td>
      <td>dlester@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Benjamin Mahler</td>
      <td>Mesosphere</td>
      <td>bmahler</td>
      <td>bmahler@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Thomas Marshall</td>
      <td>Carnegie Mellon University</td>
      <td></td>
      <td>tmarshall@apache.org</td>
    </tr>
    <tr>
      <td>+1</td>
      <td>Bernd Mathiske</td>
      <td>Mesosphere</td>
      <td>bernd</td>
      <td>bernd@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Brenden Matthews</td>
      <td>Mesosphere</td>
      <td>brenden_</td>
      <td>brenden@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Chris Mattmann</td>
      <td>NASA JPL</td>
      <td></td>
      <td>mattmann@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Anand Mazumdar</td>
      <td>Mesosphere</td>
      <td>anandm</td>
      <td>anand@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Brian McCallister</td>
      <td>Groupon</td>
      <td></td>
      <td>brianm@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Niklas Quarfot Nielsen</td>
      <td>Intel</td>
      <td>niq_</td>
      <td>nnielsen@apache.org</td>
    </tr>
    <tr>
      <td>-5</td>
      <td>Michael Park</td>
      <td>Mesosphere</td>
      <td>mpark</td>
      <td>mpark@apache.org</td>
    </tr>
    <tr>
      <td>+1</td>
      <td>Alex R</td>
      <td>Mesosphere</td>
      <td>alexr</td>
      <td>alexr@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Charles Reiss</td>
      <td>UC Berkeley</td>
      <td></td>
      <td>woggle@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Joris Van Remoortere</td>
      <td>Mesosphere</td>
      <td>joris</td>
      <td>joris@apache.org</td>
    </tr>
    <tr>
      <td>-5</td>
      <td>Timothy St Clair</td>
      <td>Redhat</td>
      <td>tstclair</td>
      <td>tstclair@apache.org</td>
    </tr>
    <tr>
      <td>+1</td>
      <td>Till Toenshoff</td>
      <td>Mesosphere</td>
      <td>tillt</td>
      <td>tillt@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Thomas White</td>
      <td>Cloudera</td>
      <td></td>
      <td>tomwhite@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Joseph Wu</td>
      <td>Mesosphere</td>
      <td></td>
      <td>josephwu@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Yan Xu</td>
      <td>Apple</td>
      <td>xujyan</td>
      <td>yan@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Jie Yu</td>
      <td>Mesosphere</td>
      <td>jieyu</td>
      <td>jieyu@apache.org</td>
    </tr>
    <tr>
      <td>-8</td>
      <td>Matei Alexandru Zaharia</td>
      <td>Databricks</td>
      <td></td>
      <td>matei@apache.org</td>
    </tr>
  </tbody>
</table>

If you're interested in becoming a committer yourself, the best way to do so is by participating in developer discussions and contributing patches to the project.


## Component Maintainers

We currently make no distinction between committers and PMC members. As such, **every committer is responsible for the quality of the entire codebase**. Some components are widely maintained (e.g. build and support tooling, tests, etc), whereas some components are inherently more critical / complex and have committers with increased context, interest, and long-term perspective.

We aim to have more than one maintainer for each component, in order to ensure that contributors can obtain timely feedback. To avoid information silos, we encourage committers to learn about areas of the code that they are unfamiliar with.

When sending reviews, it can be valuable to consult the component maintainers, as specified below. Component maintainers do not have any special "ownership" over the code, but merely serve as a resource for obtaining valuable feedback in a timely manner. We trust every committer to use good judgement to determine when to obtain feedback from component maintainers.

<table class="table table-hover table-condensed">
  <thead>
    <tr>
      <th>Component</th>
      <th>Maintainers (alphabetical)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>Master / Agent</td>
      <td>Benjamin Hindman, Vinod Kone, Benjamin Mahler, Jie Yu</td>
    </tr>
    <tr>
      <td>Framework API</td>
      <td>Benjamin Hindman, Vinod Kone, Benjamin Mahler, Jie Yu</td>
    </tr>
    <tr>
      <td>State Libraries</td>
      <td>Benjamin Hindman, Benjamin Mahler</td>
    </tr>
    <tr>
      <td>Replicated Log</td>
      <td>Benjamin Hindman, Jie Yu</td>
    </tr>
    <tr>
      <td>ZooKeeper Bindings</td>
      <td>Benjamin Hindman, Vinod Kone, Benjamin Mahler, Yan Xu</td>
    </tr>
    <tr>
      <td>Authentication / Authorization</td>
      <td>Adam B, Vinod Kone, Till Toenshoff</td>
    </tr>
    <tr>
      <td>Modules / Hooks</td>
      <td>Kapil Arya, Benjamin Hindman, Niklas Nielsen</td>
    </tr>
    <tr>
      <td>Oversubscription</td>
      <td>Vinod Kone, Niklas Nielsen, Jie Yu</td>
    </tr>
    <tr>
      <td>CLI</td>
      <td><i>maintainers needed</i></td>
    </tr>
    <tr>
      <td>WebUI</td>
      <td><i>maintainers needed</i></td>
    </tr>
    <tr>
      <td>Project Website</td>
      <td>Dave Lester</td>
    </tr>
  </tbody>
</table>


#### Containerization

<table class="table table-hover table-condensed">
  <thead>
    <tr>
      <th>Component</th>
      <th>Maintainers (alphabetical)</th>
    </tr>
    <tbody>
      <tr>
        <td>Mesos Containerizer</td>
        <td>Ian Downes, Jie Yu</td>
      </tr>
      <tr>
        <td>Docker Containerizer</td>
        <td>Tim Chen, Benjamin Hindman</td>
      </tr>
      <tr>
        <td>External Containerizer</td>
        <td>Till Toenshoff, Benjamin Hindman</td>
      </tr>
    </tbody>
  </thead>
</table>

#### C++ Libraries

<table class="table table-hover table-condensed">
  <thead>
    <tr>
      <th>Component</th>
      <th>Maintainers (alphabetical)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>Libprocess</td>
      <td>Benjamin Hindman, Benjamin Mahler, Jie Yu</td>
    </tr>
    <tr>
      <td>Stout</td>
      <td>Benjamin Hindman, Vinod Kone, Benjamin Mahler, Jie Yu</td>
    </tr>
  </tbody>
</table>
