---
title: Apache Mesos - Design docs
layout: documentation
---

# Design docs

## Documents describing Mesos design

- [Upcoming Renaming of Memory Statistics from /monitor/statistics.json (MESOS-2104)](https://docs.google.com/document/d/1SKio0kwaql7l5Bk_ui6-FUXzJuXhlkpuXG1H60U8NP0/edit)
- [ClangFormat](https://docs.google.com/document/d/13mC3CuG89x0-4mGUD1NK-M0mYsqvEcZ-ttx9CRmAXq8/edit)
- [Design Doc: Updating SlaveInfo](https://docs.google.com/document/d/1PWv7YIdV3nN2l1oUW7Nybm4KdnxZ7Px2JGc5UM-PKoQ/edit)
- [Mesos: User defined resources](https://docs.google.com/document/d/1amdq08UyV4pR2dt9xTUCYNFXhRmXKZNzO7qG6k7JCF4/edit#heading=h.i69rr23o39vl)
- [jsonify](https://docs.google.com/document/d/1Hm7Q6eiv8Wq2lAiuYceVV8n-YbBOQDdf7oc_0N2Tk9s/edit?usp=sharing)
- [Dynamic weights](https://docs.google.com/document/d/1raTcwzq2Z2He2DIcbzm2g_Ym1YN6wLNP2tbGjUJyAgA/edit?usp=sharing)
- [Mesos: exclusive resources](https://docs.google.com/document/d/1Aby-U3-MPKE51s4aYd41L4Co2S97eM6LPtyzjyR_ecI/edit)
- [Implicit Roles Design Doc](https://docs.google.com/document/d/1SCFfrBd4edSY3bVCMrNJYMxIVllD0bHJuGmgG-4vCXA/edit)
- [Fetcher refactor](https://docs.google.com/document/d/1p8tmQrGtxG6keZVo19gvHPr9WHxeny6PHTVofcLWqco/edit)
- [Structured External Volumes Specification](https://docs.google.com/document/d/1sSgPh_0Muvdec0__q9Ecs8Uq0qvEuETs0AGinevOr3w)
- [Design for Persistent Tasks](https://docs.google.com/document/d/1l7goeISpYmCjM03l20lmjZ6_BMfdxBs31znEBRtzsuU/edit)
- [Make Mesos own configuration of roles/weights](https://docs.google.com/document/d/1OIgceqpsjV3-_LGF83IMAFnrh1Ea3Zc16w9kWWPpUj4/edit#)
- [Sharing of volumes](https://docs.google.com/document/d/18O4SH3H4BQriW6CTrg3TlQTiVC-rBRsMePhz99Y_bss/edit#heading=h.1i2fqek1ko3e)
- [Proposal Resources Discovery](https://docs.google.com/document/d/15OkebDezFxzeyLsyQoU0upB0eoVECAlzEkeg0HQAX9w/edit)
- [Design Doc: Optimistic Offers](https://docs.google.com/document/d/1RGrkDNnfyjpOQVxk_kUFJCalNMqnFlzaMRww7j7HSKU/edit)
- [Allow executors to create nested containers](https://docs.google.com/document/d/1rwDumptgM4jCQQCXWgjeARRHNHkKYRuHJVhwYEFXQRU/edit)
- [Container Image Support with Custom Executor](https://docs.google.com/document/d/16hyLVRL0nz-KBts1J5stGyxZPniFPbPbs7R-ZRQVCH4/edit)
- [Mesos Master Event Streaming](https://docs.google.com/document/d/1b2gheqWPw4V-60RdKu-dGWTy-qLGL5p5xJwmUXteDYE/edit?pli=1#heading=h.86u1r3w05n13)
- [Mesos HTTP Authentication Design](https://docs.google.com/document/d/1kM3_f7DSqXcE2MuERrLTGp_XMC6ss2wmpkNYDCY5rOM)
- [Docker Authorization Token Manager](https://docs.google.com/document/d/1OFQJPawKAITRn7Cf5-DImq4Vh-aV-0VfOQK2aIwgYPw/edit#heading=h.g0x18durmhim)
- [Mesos HTTP API Versioning](https://docs.google.com/document/d/1-iQjo6778H_fU_1Zi_Yk6szg8qj-wqYgVgnx7u3h6OU/edit#)
- [Docker Registry Client](https://docs.google.com/document/d/1kE-HXPQl4lQgamPIiaD4Ytdr-N4HeQc4fnE93WHR4X4/edit#heading=h.2y16g3b23pbq)
- [Simulating Mesos for Scale v3](https://docs.google.com/document/d/1Ygq9MPWrqcQLf0J-mraVeEIRYk3xNXXQ0xRHFqTiXsQ/edit?usp=sharing)
- [Master Endpoint Implementation Challenges](https://docs.google.com/document/d/1cwVz4aKiCYP9Y4MOwHYZkyaiuEv7fArCye-vPvB2lAI/edit)
- [Support Executor with Mesos Containerizer with Image](https://docs.google.com/document/d/1YVErNiIvVIt8xAUp-_ygr3LKHYmlgKdGZBETTN8CG1U/edit)
- [Generalized authorizer interface](https://docs.google.com/document/d/1-XARWJFUq0r_TgRHz_472NvLZNjbqE4G8c2JL44OSMQ/edit)
- [Quota](https://docs.google.com/document/d/16iRNmziasEjVOblYp5bbkeBZ7pnjNlaIzPQqMTHQ-9I/edit)
- [Global Resources](https://docs.google.com/document/d/1Feiou-KvF65kUOJno2xk07pNRhSv9sKlVrkaMD7AWr0/edit#)
- [Per-Container IP in Mesos](https://docs.google.com/a/mesosphere.io/document/d/17mXtAmdAXcNBwp_JfrxmZcQrs7EO6ancSbejrqjLQ0g/edit?usp=sharing)
- [HTTP API - Master Discovery Design Doc](https://docs.google.com/document/d/1i2pWJaIjnFYhuR-000NG-AC1rFKKrRh3Wn47Y2G6lRE/edit#)
- [Mesos Executor HTTP API](https://docs.google.com/document/d/1dFmTrSZXCo5zj8H8SkJ4HT-V0z2YYnEZVV8Fd_-AupM/edit)
- [APM in Mesos](https://docs.google.com/document/d/1EfBESIeqJvj_hVGz_oIVHDnJiQtFASKwrtAIQgL0x0k/edit#heading=h.pldb4jdil4u1)
- [Libprocess Firewall Proposal](https://docs.google.com/document/d/1JSJTJMJ6ZXLkCSmvOIabTLrjtqqr0E-u99Rx2BHR1hs/edit)
- [Mesos Image Provisioning Design](https://docs.google.com/a/twitter.com/document/d/1Fx5TS0LytV7u5MZExQS0-g-gScX2yKCKQg9UPFzhp6U/edit?usp=sharing)
- [Design Doc: Task Info for Service Discovery](https://docs.google.com/document/d/1tpnjfHsa5Joka23CqgGppqnK0jODcElBvTFUBBO-A38/edit)
- [Docker Containerizer Update](https://docs.google.com/a/mesosphere.io/document/d/1_1oLHXg_aHj_fYCzsjYwox9xvIYNAKIeVjO5BFxsUGI/edit#)
- [Dynamic Reservation](https://docs.google.com/document/d/1e3j69pfBgtc8xM00DhcuiMl6ImkEB5na0TzOMyzrg8A/edit?usp=sharing)
- [Design Doc: Mesos Cluster Maintenance](https://docs.google.com/document/d/16k0lVwpSGVOyxPSyXKmGC-gbNmRlisNEe4p-fAUSojk/edit)
- [Task Resizing Design](https://docs.google.com/document/d/15rVmS2AXLzTDSEugAVDxWuHFUentp82KhL2yzxBCsi8/edit)
- [pluggable containerizer architecture](https://docs.google.com/document/d/1oO0oDmCphku4X-CO0Mja_QeH-LuHeWySHOcxMbtvLDg/edit)
- [Mesos Oversubscription Design](https://docs.google.com/document/d/1pUnElxHy1uWfHY_FOvvRC73QaOGgdXE0OXN-gbxdXA0/edit#heading=h.yvd9qbi4swb4)
- [Design Doc: Multiple Disk Support](https://docs.google.com/document/d/1syPxygVNEHjG6FoyqslnpUGgNpYKU9QzKBuV2yKmjfQ/edit#heading=h.4fzj9sl24cwy)
- [Resource Monitoring Design Doc (Recovered)](https://docs.google.com/document/d/1LwFKbybtkAPt4MRmxGZQePp16IHcELsFrGbF2BEQopA/edit?usp=sharing)
- [Mesos HTTP API](https://docs.google.com/document/d/1pnIY_HckimKNvpqhKRhbc9eSItWNFT-priXh_urR-T0/edit#heading=h.ej7mjb84f6x9)
