---
title: Apache Mesos - Operator HTTP API
layout: documentation
---

# Operator HTTP API

Mesos 1.0.0 added **experimental** support for v1 Operator HTTP API.


## Overview

The base URL at `/api/v1` is utilized as the single endpoint on both masters and agents for performing operator related operations.

Similar to the [Scheduler](scheduler-http-api.md) and [Executor](executor-http-api.md) HTTP APIs, the endpoints only accept HTTP POST requests. The request body should be encoded in JSON (**Content-Type: application/json**) or protobuf (**Content-Type: application/x-protobuf**).

For requests that Mesos can answer synchronously and immediately, an HTTP response with status **200 OK**, possibly including response body encoded in JSON or Protobuf is sent. The encoding depends on the **Accept-Type** header present in the request (default is JSON). Also, note that responses will be gzip compressed if **Accept-Encoding** header is set to "gzip".

For requests that require the master to process the request asynchronously (e.g., `RESERVE_RESOURCES`), an HTTP response with status **202 Accepted** is sent. For the requests that result in a never ending stream of events (`SUBSCRIBE`), a streaming HTTP response with [RecordIO](scheduler-http-api.md#recordio-response-format) encoding is sent. Currently, gzip compression is not supported for streaming response.

## Master API

This API contains all the calls accepted by the master. The canonical source of this information is [master.proto](https://github.com/apache/mesos/blob/master/include/mesos/v1/master/master.proto) (NOTE: The protobuf definitions are subject to change before the beta API is finalized). These calls are typically made by human operators, tooling or services (e.g., Mesos WebUI). While schedulers can make these calls as well, it is expected for those to use the [Scheduler HTTP API](scheduler-http-api.md).

## Agent API

This API contains all the calls accepted by the agent. The canonical source of this information is [agent.proto](https://github.com/apache/mesos/blob/master/include/mesos/v1/agent/agent.proto) (NOTE: The protobuf definitions are subject to change before the beta API is finalized). These calls are typically made by human operators, tooling or services (e.g., Mesos WebUI). While executors can make these calls as well, it is expected for those to use the [Executor HTTP API](executor-http-api.md).


## Calls and Responses

Below are some example calls that result in synchronous responses from the API.

### GET_VERSION

```
GET_VERSION HTTP Request (JSON):

POST /api/v1/  HTTP/1.1

Host: masterhost:5050
Content-Type: application/json
Accept-Type: application/json

{
  “type”		: “GET_VERSION”
}


GET_VERSION HTTP Response (JSON):

HTTP/1.1 200 OK

Content-Type: application/json

{
  “type”    : GET_VERSION,

  “get_version” : {
    “version_info” : {
      "version" : "1.0.0",
      "build_date" : "2016-06-24 23:18:37",
      "build_time" : 1466810317,
      "build_user" : "root"
    }
  }
}

```

### SET_LOGGING_LEVEL

```
SET_LOGGING_LEVEL HTTP Request (JSON):

POST /api/v1/  HTTP/1.1

Host: masterhost:5050
Content-Type: application/json
Accept-Type: application/json

{
  “type”		: “SET_LOGGING_LEVEL”,

 “set_logging_level” : {

    “level” : 1,

    "duration" : {
      "nanoseconds" : 1224553
    }

  }
}

SET_LOGGING_LEVEL HTTP Response:

HTTP/1.1 200 Accepted

```

## Events

Currently, the only call that results in a streaming response is the `SUBSCRIBE` call sent to the master API.

```
SUBSCRIBE Request (JSON):

POST /api/v1/executor  HTTP/1.1

Host: agenthost:5051
Content-Type: application/json
Accept: application/json

{
  "type": "SUBSCRIBE",
}

SUBSCRIBE Response Event (JSON):
HTTP/1.1 200 OK

Content-Type: application/json
Transfer-Encoding: chunked

<event-length>
{
  "type": "SUBSCRIBED",

  "subscribed" : {

    "get_state" : {...}

  }

}
<more events>
```

The client is expected to keep a **persistent** connection open to the endpoint even after getting a `SUBSCRIBED` HTTP Response event. This is indicated by "Connection: keep-alive" and "Transfer-Encoding: chunked" headers with *no* "Content-Length" header set. All subsequent events generated by Mesos are streamed on this connection. Master encodes each Event in [RecordIO](scheduler-http-api.md#recordio-response-format) format, i.e., string representation of length of the event in bytes followed by JSON or binary Protobuf encoded event.

The following events are currently sent by the master. The canonical source of this information is at [master.proto](https://github.com/apache/mesos/blob/master/include/mesos/v1/master/master.proto). Note that when sending JSON encoded events, master encodes raw bytes in Base64 and strings in UTF-8.

### SUBSCRIBED

The first event sent by the master when a client sends a `SUBSCRIBE` request on the persistent connection. This includes a snapshot of the cluster state. See `SUBSCRIBE` above for details. Subsequent changes to the cluster state can result in more events (currently only `TASK_ADDED` and `TASK_UPDATED` are supported).

### TASK_ADDED

Sent whenever a task has been added to the master. This can happen either when a new task launch is processed by the master or when an agent re-registers with a failed over master.

```
TASK_ADDED Event (JSON)

<event-length>
{
  "type": "TASK_ADDED",

  "task_added": {
    "task": {
      "name": "dummy-task",
      "task_id": {
        "value": "d40f3f3e-bbe3-44af-a230-4cb1eae72f67"
      },
      "agent_id": {
        "value": "f1c9cdc5-195e-41a7-a0d7-adaa9af07f81"
      },
      "command": {
        "value": "sleep",
        "arguments": [
          "100"
        ]
      }
    }
  }
}
```

### TASK_UPDATED

Sent whenever the state of the task changes in the master. This can happen when a status update is received or generated by the master. Since status updates are retried by the agent, not all status updates received by the master result in the event being sent.

```
TASK_UPDATED Event (JSON)

<event-length>
{
  "type": "TASK_UPDATED",

  "task_updated": {
    "task_id": {
        "value": "42154f1b-adcd-4421-bf13-8bd11adfafaf"
    },

    "framework_id": {
        "value": "49154f1b-8cf6-4421-bf13-8bd11dccd1f1"
    },

    "agent_id": {
        "value": "2915adf-8aff-4421-bf13-afdafaf1f1"
    },

    "executor_id": {
        "value": "adfaf-adff-2421-bf13-adf23tafa21"
    },

    "state" : "TASK_RUNNING"
  }
}
```
